/*
 * Decompiled with CFR 0.152.
 */
package at.redi2go.photonic.client.rendering.world;

import at.redi2go.photonic.client.rendering.opengl.objects.Destructable;
import at.redi2go.photonic.client.rendering.world.WorldRegistry;

public class WorldCompilerThread
extends Thread
implements Destructable {
    private WorldRegistry worldRegistry;
    private boolean started = false;

    public WorldCompilerThread(WorldRegistry worldRegistry) {
        this.worldRegistry = worldRegistry;
        super.setDaemon(true);
        super.setName("WorldCompilerThread");
    }

    public void ensureRunning() {
        if (this.started) {
            return;
        }
        this.start();
        this.started = true;
    }

    public void sendStopSignal() {
        this.started = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        super.run();
        while (this.started) {
            if (this.worldRegistry == null) {
                return;
            }
            try {
                this.worldRegistry.compileWorld();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            WorldCompilerThread worldCompilerThread = this;
            synchronized (worldCompilerThread) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void free() {
        this.sendStopSignal();
        this.worldRegistry = null;
    }
}

