/*
 * Decompiled with CFR 0.152.
 */
package at.redi2go.photonic.client.rendering.world;

import at.redi2go.photonic.client.Raytracer;
import at.redi2go.photonic.client.rendering.MinecraftAccessor;
import at.redi2go.photonic.client.rendering.opengl.objects.Destructable;
import at.redi2go.photonic.client.rendering.opengl.objects.GlTarget;
import at.redi2go.photonic.client.rendering.opengl.rendering.IRenderDispatcher;
import at.redi2go.photonic.client.rendering.schematics.Schematic;
import at.redi2go.photonic.client.rendering.util.BufferUtils;
import at.redi2go.photonic.client.rendering.world.LightRegistry;
import at.redi2go.photonic.client.rendering.world.PBlock;
import at.redi2go.photonic.client.rendering.world.PChunk;
import at.redi2go.photonic.client.rendering.world.WorldCompilerThread;
import at.redi2go.photonic.client.rendering.world.buffer.GlMemoryManager;
import at.redi2go.photonic.client.rendering.world.buffer.MemoryOwner;
import at.redi2go.photonic.client.rendering.world.buffer.MemoryRegion;
import at.redi2go.photonic.client.rendering.world.buffer.SimpleMemoryOwner;
import at.redi2go.photonic.client.rendering.world.position.PBlockPos;
import at.redi2go.photonic.client.rendering.world.position.PChunkPos;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class WorldRegistry
implements MemoryOwner,
Destructable {
    private final IRenderDispatcher renderDispatcher;
    private final WorldCompilerThread worldCompilerThread;
    private final LightRegistry lightRegistry;
    private final GlMemoryManager cbMemoryManager;
    private final SimpleMemoryOwner blockLightRegistry;
    private final GlMemoryManager rootMemoryManager;
    private MemoryRegion rootMemory;
    private final Schematic rootSchematic;
    private final ConcurrentLinkedQueue<Runnable> buildQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Runnable> glQueue = new ConcurrentLinkedQueue();
    private final Map<PChunkPos, PChunk> chunks = new HashMap<PChunkPos, PChunk>();
    private PBlockPos rtToWorldBlockOffset = new PBlockPos(0, 0, 0);
    private PChunkPos rtToWorldChunkOffset = new PChunkPos(0, 0, 0);
    private Vector3f liveWorldBlockOffset = new Vector3f();
    private PBlockPos liveWorldMinVoxel = new PBlockPos(0, 0, 0);
    private PBlockPos liveWorldMaxVoxel = new PBlockPos(0, 0, 0);
    private BuildStage buildStage = BuildStage.IDLE;
    private boolean closeChunkUpdate = false;
    private boolean closeChunkUpload = false;
    private final int worldBlockSize;
    private final int worldChunkSize;
    private PBlockPos worldMinVoxel = new PBlockPos(0, 0, 0);
    private PBlockPos worldMaxVoxel = new PBlockPos(0, 0, 0);
    private boolean dirty = true;

    public WorldRegistry(IRenderDispatcher renderDispatcher) {
        this.renderDispatcher = renderDispatcher;
        this.worldChunkSize = 32;
        this.worldBlockSize = 16 * this.worldChunkSize;
        this.rootSchematic = new Schematic(this.worldChunkSize, this.worldChunkSize, this.worldChunkSize);
        this.lightRegistry = new LightRegistry(20, 8, this.worldBlockSize, renderDispatcher::isChunkEmpty);
        this.cbMemoryManager = new GlMemoryManager(GlTarget.SSBO, "cb_block", 0x20000000, true);
        int maxBlockCount = this.cbMemoryManager.getCapacity() / 16384;
        this.blockLightRegistry = new SimpleMemoryOwner(this.cbMemoryManager, 32 * maxBlockCount);
        this.rootMemoryManager = new GlMemoryManager(GlTarget.SSBO, "root_uniform", 4 * this.worldChunkSize * this.worldChunkSize * this.worldChunkSize, false);
        this.worldCompilerThread = new WorldCompilerThread(this);
        this.allocate(this.rootMemoryManager);
    }

    public void upload() {
        if (this.buildStage != BuildStage.WAIT_FOR_UPLOAD) {
            return;
        }
        this.changeBuildStage(BuildStage.UPLOAD);
        this.cbMemoryManager.queueUpload(this.blockLightRegistry);
        boolean uploadDone = true;
        uploadDone &= this.lightRegistry.upload();
        if (!(uploadDone &= this.cbMemoryManager.upload())) {
            this.buildStage = BuildStage.WAIT_FOR_UPLOAD;
            return;
        }
        this.rootMemoryManager.upload();
        this.liveWorldBlockOffset = new Vector3f((float)this.rtToWorldBlockOffset.x, (float)this.rtToWorldBlockOffset.y, (float)this.rtToWorldBlockOffset.z);
        this.liveWorldMinVoxel = this.worldMinVoxel;
        this.liveWorldMaxVoxel = this.worldMaxVoxel;
        if (this.closeChunkUpdate) {
            this.renderDispatcher.onChunkLoad();
            this.closeChunkUpload = true;
            this.closeChunkUpdate = false;
        }
        this.changeBuildStage(BuildStage.IDLE);
        if (!this.buildQueue.isEmpty()) {
            this.wakeUpWorldBuilder();
        }
    }

    public void compileWorld() {
        if (this.buildStage != BuildStage.IDLE) {
            return;
        }
        this.ensureWorldThread();
        this.changeBuildStage(BuildStage.COMPILE);
        while (!this.buildQueue.isEmpty()) {
            this.buildQueue.poll().run();
        }
        Vector3f worldOffset = new Vector3f((Vector3fc)MinecraftAccessor.getCameraPosition());
        worldOffset.floor();
        worldOffset.add((float)(-this.worldBlockSize) / 2.0f, (float)(-this.worldBlockSize) / 2.0f, (float)(-this.worldBlockSize) / 2.0f);
        worldOffset.mul(0.0625f);
        worldOffset.floor();
        this.rtToWorldChunkOffset = new PChunkPos((int)worldOffset.x, (int)worldOffset.y, (int)worldOffset.z);
        this.rtToWorldBlockOffset = new PChunkPos(this.rtToWorldChunkOffset.x, this.rtToWorldChunkOffset.y, this.rtToWorldChunkOffset.z).toBlockPos();
        this.synchronizeChunks();
        this.dirty = this.update(this.rootMemoryManager);
        if (this.dirty) {
            this.lightRegistry.compileRegistry(this.rtToWorldBlockOffset);
        }
        this.changeBuildStage(BuildStage.WAIT_FOR_UPLOAD);
    }

    public void synchronizeChunks() {
        this.ensureWorldThread();
        HashSet<PChunkPos> inboundNonEmptyChunks = new HashSet<PChunkPos>();
        for (PChunkPos chunkPos : this.renderDispatcher.getInboundChunks()) {
            if (this.renderDispatcher.isChunkEmpty(chunkPos)) continue;
            PChunkPos rtChunkPos = new PChunkPos(chunkPos.x - this.rtToWorldChunkOffset.x, chunkPos.y - this.rtToWorldChunkOffset.y, chunkPos.z - this.rtToWorldChunkOffset.z);
            if (rtChunkPos.x < 0 || rtChunkPos.x >= this.worldChunkSize || rtChunkPos.y < 0 || rtChunkPos.y >= this.worldChunkSize || rtChunkPos.z < 0 || rtChunkPos.z >= this.worldChunkSize) continue;
            inboundNonEmptyChunks.add(chunkPos);
        }
        for (PChunkPos chunkPos : inboundNonEmptyChunks) {
            if (this.chunks.containsKey(chunkPos)) continue;
            this.loadChunk(chunkPos);
        }
        for (Iterator<PChunkPos> iterator : this.chunks.keySet().toArray(new PChunkPos[0])) {
            if (inboundNonEmptyChunks.contains(iterator)) continue;
            this.unloadChunk((PChunkPos)((Object)iterator));
        }
        this.worldMinVoxel = new PBlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.worldMaxVoxel = new PBlockPos(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        for (PChunkPos chunkPos : this.chunks.keySet()) {
            PBlockPos blockPos = chunkPos.toBlockPos();
            this.worldMinVoxel.min(blockPos.x, blockPos.y, blockPos.z);
            this.worldMaxVoxel.max(blockPos.x, blockPos.y, blockPos.z);
        }
        this.worldMinVoxel.sub(this.rtToWorldBlockOffset.x, this.rtToWorldBlockOffset.y, this.rtToWorldBlockOffset.z);
        this.worldMinVoxel.scale(16, 16, 16);
        this.worldMaxVoxel.add(16, 16, 16);
        this.worldMaxVoxel.sub(this.rtToWorldBlockOffset.x, this.rtToWorldBlockOffset.y, this.rtToWorldBlockOffset.z);
        this.worldMaxVoxel.scale(16, 16, 16);
    }

    public void loadChunk(PChunkPos chunkPos) {
        this.ensureWorldThread();
        this.onChunkLoad(chunkPos);
        PChunk chunk = this.chunks.computeIfAbsent(chunkPos, k -> {
            PChunk newChunk = new PChunk();
            newChunk.allocate(this.cbMemoryManager);
            return newChunk;
        });
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    PBlockPos blockPos = new PBlockPos(16 * chunkPos.x + x, 16 * chunkPos.y + y, 16 * chunkPos.z + z);
                    PBlock block = Raytracer.INSTANCE.getBlockRegistry().getBlock(blockPos);
                    if (block != null && block.getMemory() == null) {
                        throw new IllegalStateException();
                    }
                    chunk.set(x, y, z, block);
                }
            }
        }
    }

    public void unloadChunk(PChunkPos chunkPos) {
        this.ensureWorldThread();
        PChunk chunk = this.chunks.remove(chunkPos);
        if (chunk == null) {
            return;
        }
        chunk.free(this.cbMemoryManager);
    }

    @Override
    public void allocate(GlMemoryManager memoryManager) {
        this.rootMemory = memoryManager.allocate(this.getSize());
    }

    @Override
    public void free(GlMemoryManager memoryManager) {
        memoryManager.free(this.rootMemory);
        this.rootMemory = null;
    }

    @Override
    public boolean update(GlMemoryManager memoryManager) {
        Arrays.fill(this.rootSchematic.getData(), 0);
        for (Map.Entry<PChunkPos, PChunk> entry : this.chunks.entrySet()) {
            PChunkPos chunkPos = entry.getKey();
            PChunk chunk = entry.getValue();
            PChunkPos rtChunkPos = new PChunkPos(chunkPos.x, chunkPos.y, chunkPos.z);
            rtChunkPos.sub(this.rtToWorldChunkOffset.x, this.rtToWorldChunkOffset.y, this.rtToWorldChunkOffset.z);
            if (rtChunkPos.x < 0 || rtChunkPos.x >= this.worldChunkSize || rtChunkPos.y < 0 || rtChunkPos.y >= this.worldChunkSize || rtChunkPos.z < 0 || rtChunkPos.z >= this.worldChunkSize) continue;
            chunk.update(this.cbMemoryManager);
            this.rootSchematic.setEntry(rtChunkPos.x, rtChunkPos.y, rtChunkPos.z, chunk.getMemory().begin >> 2);
        }
        try {
            this.rootSchematic.reset();
            this.rootSchematic.initialize();
            this.rootSchematic.optimizeThreaded().get();
            this.rootMemory.getBuffer().asIntBuffer().put(this.rootSchematic.getData());
            memoryManager.queueUpload(this);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public void registerEmittableBlock(PBlock block, Vector3f color) {
        int index = block.getMemory().begin / 16384;
        this.blockLightRegistry.getMemory().getBuffer().put(4 * index, BufferUtils.packUnorm4x8(color.x, color.y, color.z, 0.0f));
        block.setLightSourceRegistered(true);
    }

    @Override
    public void afterUpload() {
        this.dirty = false;
    }

    @Override
    public int getSize() {
        return 4 * this.worldChunkSize * this.worldChunkSize * this.worldChunkSize;
    }

    @Override
    public MemoryRegion getMemory() {
        return this.rootMemory;
    }

    private void onChunkLoad(PChunkPos chunkPos) {
        Vector3f cameraPosition = MinecraftAccessor.getCameraPosition();
        PBlockPos chunkBlockPos = chunkPos.toBlockPos();
        float cameraDistance = new Vector3f((float)chunkBlockPos.x, (float)chunkBlockPos.y, (float)chunkBlockPos.z).add((Vector3fc)new Vector3f(8.0f)).add((Vector3fc)new Vector3f((Vector3fc)cameraPosition).mul(-1.0f)).length();
        if (cameraDistance < 32.0f) {
            this.closeChunkUpdate = true;
        }
    }

    @Override
    public void free() {
        this.worldCompilerThread.free();
        this.buildQueue.clear();
        this.glQueue.clear();
        this.lightRegistry.free();
        this.cbMemoryManager.free();
        this.rootMemoryManager.free();
    }

    public Map<PChunkPos, PChunk> getChunks() {
        return this.chunks;
    }

    public void ensureWorldThread() {
        if (Thread.currentThread() != this.worldCompilerThread) {
            throw new IllegalStateException("Called from wrong thread!");
        }
    }

    public void queueBuildJob(Runnable job) {
        this.buildQueue.add(job);
    }

    public void queueGlJob(Runnable job) {
        this.glQueue.add(job);
    }

    public Vector3f toRt(Vector3f vector3f) {
        return new Vector3f((Vector3fc)vector3f).sub((Vector3fc)this.liveWorldBlockOffset);
    }

    public boolean fetchLightReload() {
        boolean lightReload = this.closeChunkUpload;
        this.closeChunkUpload = false;
        return lightReload;
    }

    public void startWorldBuilder() {
        this.worldCompilerThread.ensureRunning();
    }

    public void stopWorldBuilder() {
        this.worldCompilerThread.sendStopSignal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUpWorldBuilder() {
        WorldCompilerThread worldCompilerThread = this.worldCompilerThread;
        synchronized (worldCompilerThread) {
            this.worldCompilerThread.notifyAll();
        }
    }

    public Vector3f getWorldOffset() {
        return this.liveWorldBlockOffset;
    }

    public ConcurrentLinkedQueue<Runnable> getGlQueue() {
        return this.glQueue;
    }

    public void changeBuildStage(BuildStage buildStage) {
        if (buildStage.before != this.buildStage) {
            throw new IllegalStateException();
        }
        this.buildStage = buildStage;
    }

    public GlMemoryManager getRootMemoryManager() {
        return this.rootMemoryManager;
    }

    public GlMemoryManager getCbMemoryManager() {
        return this.cbMemoryManager;
    }

    public LightRegistry getLightRegistry() {
        return this.lightRegistry;
    }

    public PBlockPos getWorldMinVoxel() {
        return this.liveWorldMinVoxel;
    }

    public PBlockPos getWorldMaxVoxel() {
        return this.liveWorldMaxVoxel;
    }

    static {
        BuildStage.IDLE.before = BuildStage.UPLOAD;
        BuildStage.COMPILE.before = BuildStage.IDLE;
        BuildStage.WAIT_FOR_UPLOAD.before = BuildStage.COMPILE;
        BuildStage.UPLOAD.before = BuildStage.WAIT_FOR_UPLOAD;
    }

    public static enum BuildStage {
        IDLE,
        COMPILE,
        WAIT_FOR_UPLOAD,
        UPLOAD;

        public BuildStage before;
    }
}

