/*
 * Decompiled with CFR 0.152.
 */
package at.redi2go.photonic.client.rendering.world.buffer;

import at.redi2go.photonic.client.rendering.opengl.objects.Destructable;
import at.redi2go.photonic.client.rendering.opengl.objects.GlTarget;
import at.redi2go.photonic.client.rendering.util.BufferUtils;
import at.redi2go.photonic.client.rendering.world.buffer.MemoryOwner;
import at.redi2go.photonic.client.rendering.world.buffer.MemoryRegion;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Consumer;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL31;
import org.lwjgl.opengl.GL43;

public class GlMemoryManager
implements Destructable {
    private int id;
    private final GlTarget target;
    private final boolean staticData;
    private final String name;
    private final ByteBuffer buffer;
    public int index = 0;
    private int uploadBatchSize = Integer.MAX_VALUE;
    private final Deque<MemoryOwner> uploadQueue = new LinkedList<MemoryOwner>();
    public final Queue<MemoryRegion> unusedBuffers = new LinkedList<MemoryRegion>();

    public GlMemoryManager(GlTarget target, String name, int byteSize, boolean staticData) {
        this.target = target;
        this.name = name;
        this.staticData = staticData;
        this.buffer = BufferUtils.createByteBuffer(byteSize);
    }

    public MemoryRegion allocate(int byteSize) {
        Iterator memoryIterator = this.unusedBuffers.iterator();
        while (memoryIterator.hasNext()) {
            MemoryRegion region = (MemoryRegion)memoryIterator.next();
            if (region.end - region.begin != byteSize) continue;
            memoryIterator.remove();
            region.allocated = true;
            return region;
        }
        int begin = this.index;
        int end = this.index + byteSize;
        this.index += byteSize;
        return new MemoryRegion(this.buffer.slice(begin, end - begin).order(this.buffer.order()), begin, end);
    }

    public void bind(int program, int blockIndex, int bindingPointIndex) {
        this.ensureAllocated();
        GL30.glBindBufferBase((int)this.target.target, (int)bindingPointIndex, (int)this.id);
        if (this.target == GlTarget.SSBO) {
            GL43.glShaderStorageBlockBinding((int)program, (int)blockIndex, (int)bindingPointIndex);
        } else if (this.target == GlTarget.UBO) {
            GL31.glUniformBlockBinding((int)program, (int)blockIndex, (int)bindingPointIndex);
        }
    }

    public int findInProgram(int program) {
        this.ensureAllocated();
        return switch (this.target) {
            default -> throw new MatchException(null, null);
            case GlTarget.SSBO -> GL43.glGetProgramResourceIndex((int)program, (int)37606, (CharSequence)this.name);
            case GlTarget.UBO -> GL31.glGetUniformBlockIndex((int)program, (CharSequence)this.name);
        };
    }

    public boolean upload() {
        this.ensureAllocated();
        GL15.glBindBuffer((int)this.target.target, (int)this.id);
        for (int i = 0; i < this.uploadBatchSize && !this.uploadQueue.isEmpty(); ++i) {
            MemoryOwner memoryOwner = this.uploadQueue.poll();
            MemoryRegion memoryRegion = memoryOwner.getMemory();
            GL15.glBufferSubData((int)this.target.target, (long)memoryRegion.begin, (ByteBuffer)memoryRegion.getBuffer());
            memoryOwner.afterUpload();
        }
        GL15.glBindBuffer((int)this.target.target, (int)0);
        return this.uploadQueue.isEmpty();
    }

    public void download(Consumer<ByteBuffer> downloadContext) {
        this.ensureAllocated();
        GL15.glBindBuffer((int)this.target.target, (int)this.id);
        ByteBuffer downloadedBuffer = GL15.glMapBuffer((int)this.target.target, (int)35002, null);
        downloadContext.accept(downloadedBuffer);
        GL15.glUnmapBuffer((int)this.target.target);
        GL15.glBindBuffer((int)this.target.target, (int)0);
    }

    public void queueUpload(MemoryOwner memoryOwner) {
        this.uploadQueue.addLast(memoryOwner);
    }

    public void queueUploadPriority(MemoryOwner memoryOwner) {
        this.uploadQueue.addFirst(memoryOwner);
    }

    public void free(MemoryRegion memoryRegion) {
        memoryRegion.allocated = false;
        this.unusedBuffers.add(memoryRegion);
    }

    private void ensureAllocated() {
        if (this.id != 0) {
            return;
        }
        this.id = GL15.glGenBuffers();
        GL15.glBindBuffer((int)this.target.target, (int)this.id);
        GL15.glBufferData((int)this.target.target, (long)this.buffer.capacity(), (int)(this.staticData ? 35044 : 35048));
        GL15.glBindBuffer((int)this.target.target, (int)0);
    }

    public void setUploadBatchSize(int uploadBatchSize) {
        this.uploadBatchSize = uploadBatchSize;
    }

    public int getCapacity() {
        return this.buffer.capacity();
    }

    @Override
    public void free() {
        if (this.id == 0) {
            return;
        }
        GL15.glDeleteBuffers((int)this.id);
    }
}

