/*
 * Decompiled with CFR 0.152.
 */
package at.redi2go.photonic.client.rendering.world.position;

import at.redi2go.photonic.client.rendering.world.position.PChunkPos;
import java.util.Objects;
import org.joml.Vector3i;

public class PBlockPos {
    public int x;
    public int y;
    public int z;

    public PBlockPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void add(int x, int y, int z) {
        this.x += x;
        this.y += y;
        this.z += z;
    }

    public void sub(int x, int y, int z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
    }

    public void min(int x, int y, int z) {
        this.x = Math.min(this.x, x);
        this.y = Math.min(this.y, y);
        this.z = Math.min(this.z, z);
    }

    public void max(int x, int y, int z) {
        this.x = Math.max(this.x, x);
        this.y = Math.max(this.y, y);
        this.z = Math.max(this.z, z);
    }

    public void scale(int x, int y, int z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
    }

    public PChunkPos toChunkPos() {
        return new PChunkPos(Math.floorDiv(this.x, 16), Math.floorDiv(this.y, 16), Math.floorDiv(this.z, 16));
    }

    public Vector3i toVector() {
        return new Vector3i(this.x, this.y, this.z);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PBlockPos blockPos = (PBlockPos)object;
        return this.x == blockPos.x && this.y == blockPos.y && this.z == blockPos.z;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }
}

