/*
 * Decompiled with CFR 0.152.
 */
package obro1961.chatpatches.mixin.gui;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_338;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_408;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import net.minecraft.class_8494;
import net.minecraft.class_8623;
import obro1961.chatpatches.ChatLog;
import obro1961.chatpatches.ChatPatches;
import obro1961.chatpatches.accessor.ChatHudAccess;
import obro1961.chatpatches.accessor.ChatScreenAccess;
import obro1961.chatpatches.config.Config;
import obro1961.chatpatches.gui.ContextMenu;
import obro1961.chatpatches.gui.SearchButton;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_408.class})
public abstract class ChatScreenMixin
extends class_437
implements ChatScreenAccess {
    @Unique
    private static final String SEARCH_SUGGESTION = class_1074.method_4662((String)"text.chatpatches.search.suggestion", (Object[])new Object[0]);
    @Unique
    private static final class_2561 SEARCH_TOOLTIP = class_2561.method_43471((String)"text.chatpatches.search.desc");
    @Unique
    private static final Matcher SMWYG_ITEM_PATTERN = Pattern.compile("^\\[[\\w\\s]+]$").matcher("");
    @Unique
    private static final int SEARCH_X = 22;
    @Unique
    private static final int SEARCH_Y_OFFSET = -31;
    @Unique
    private static final int SEARCH_HEIGHT = 12;
    @Unique
    private static final double SEARCH_W_MULT = 0.25;
    @Unique
    private static final int MENU_WIDTH = 146;
    @Unique
    private static final int MENU_HEIGHT = 76;
    @Unique
    private static final int MENU_X = 2;
    @Unique
    private static final int MENU_Y_OFFSET = -113;
    @Unique
    private static ContextMenu contextMenu = new ContextMenu(null, -1.0, -1.0);
    @Unique
    private boolean blockSpaceConsumption = false;
    @Unique
    private static final BooleanList searchSettings = new BooleanArrayList(List.of(Boolean.valueOf(ChatPatches.config.caseSensitive), Boolean.valueOf(ChatPatches.config.regex)));
    @Unique
    private static final List<class_303> searchResults = new ObjectArrayList();
    @Unique
    private static boolean showSearchBar = true;
    @Unique
    private static Matcher searchMatcher = Pattern.compile(".*?").matcher("");
    @Unique
    private static String searchDraft = "";
    @Unique
    private static String messageDraft = "";
    @Unique
    private class_342 searchField;
    @Unique
    private SearchButton searchButton;
    @Unique
    private PatternSyntaxException searchError;
    @Unique
    private boolean showSettingsMenu = false;
    @Unique
    private class_4185 caseSensitiveButton;
    @Unique
    private class_4185 regexButton;
    @NotNull
    protected class_310 minecraft = class_310.method_1551();
    @Shadow
    protected class_342 field_2382;
    @Shadow
    protected String field_18973;
    @Shadow
    private int field_2387;

    @Override
    public class_342 chatpatches$getChatField() {
        return this.field_2382;
    }

    protected ChatScreenMixin(class_2561 title) {
        super(title);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void chatScreenInit(String initialChat, CallbackInfo ci) {
        if (ChatPatches.config.messageDrafting && !messageDraft.isBlank()) {
            if (FabricLoader.getInstance().isModLoaded("smwyg") && SMWYG_ITEM_PATTERN.reset(initialChat).matches()) {
                messageDraft = initialChat;
            } else if (!initialChat.equals("/")) {
                this.field_18973 = messageDraft;
            }
        }
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    protected void initSearchWidgets(CallbackInfo ci) {
        this.searchButton = new SearchButton(2, this.field_22790 - 35, me -> {
            showSearchBar = !showSearchBar;
        }, me -> {
            this.showSettingsMenu = !this.showSettingsMenu;
        });
        this.searchButton.method_47400(class_7919.method_47407((class_2561)SEARCH_TOOLTIP));
        this.searchField = new class_342(this.minecraft.field_1772, 22, this.field_22790 + -31, (int)((double)this.field_22789 * 0.25), 12, (class_2561)class_2561.method_43471((String)"chat.editBox"));
        this.searchField.method_1880(256);
        this.searchField.method_1858(false);
        this.searchField.method_1887(SEARCH_SUGGESTION);
        this.searchField.method_1863(newText -> this.onSearchFieldUpdate((String)newText, false));
        if (ChatPatches.config.searchDrafting) {
            this.searchField.method_1852(searchDraft);
            if (!searchDraft.isEmpty()) {
                this.onSearchFieldUpdate(this.searchField.method_1882(), true);
            }
        }
        if (ChatLog.isRestoring()) {
            this.field_2382.method_1888(false);
            this.field_2382.method_1852("Chat log not available - try reopening the chat");
        }
        this.caseSensitiveButton = this.makeSettingButton("caseSensitive", 0);
        this.regexButton = this.makeSettingButton("regex", 22);
        if (ChatPatches.config.search) {
            this.method_37063((class_364)this.searchButton);
            this.method_25429((class_364)this.searchField);
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V")})
    private void renderCustomWidgets(class_332 graphics, int mX, int mY, float delta, CallbackInfo ci) {
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, -1.0f);
        if (showSearchBar && ChatPatches.config.search) {
            graphics.method_25294(20, this.field_22790 + -31 - 2, (int)((double)this.field_22789 * 0.31), this.field_22790 + -31 + 12 - 2, this.minecraft.field_1690.method_19344(Integer.MIN_VALUE));
            this.searchField.method_25394(graphics, mX, mY, delta);
            if (this.searchError != null) {
                int x = this.searchField.method_46426() + 8 + (int)((double)this.field_22789 * 0.25);
                graphics.method_25303(this.field_22793, this.searchError.getMessage().split(System.lineSeparator())[0], x, this.searchField.method_46427(), class_124.field_1079.method_532().intValue());
            }
        }
        if (this.showSettingsMenu && ChatPatches.config.search) {
            graphics.method_25290(class_1921::method_62277, ChatPatches.id("textures/gui/search_settings_panel.png"), 2, this.field_22790 + -113, 0.0f, 0.0f, 146, 76, 146, 76);
            this.caseSensitiveButton.method_25394(graphics, mX, mY, delta);
            this.regexButton.method_25394(graphics, mX, mY, delta);
        }
        graphics.method_51448().method_22909();
        contextMenu.render(graphics, mX, mY, delta);
    }

    @WrapWithCondition(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;renderComponentHoverEffect(Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Style;II)V")})
    public boolean renderTooltipSmartly(class_332 graphics, class_327 textRenderer, class_2583 style, int mX, int mY) {
        return !this.isMouseOverSettingsMenu(mX, mY) && !contextMenu.method_25405(mX, mY);
    }

    @Inject(method={"removed"}, at={@At(value="TAIL")})
    public void onScreenClose(CallbackInfo ci) {
        messageDraft = this.field_2382.method_1882();
        searchDraft = this.searchField.method_1882();
        if (!this.searchField.method_1882().isEmpty()) {
            this.minecraft.field_1705.method_1743().method_1817();
        }
        contextMenu.close(x$0 -> this.method_37066((class_364)x$0));
        BooleanList cfg = BooleanList.of((boolean)ChatPatches.config.caseSensitive, (boolean)ChatPatches.config.regex);
        if (!searchSettings.equals((Object)cfg)) {
            searchSettings.setElements(cfg.toBooleanArray());
            Config.serialize();
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;keyPressed(III)Z")})
    private void emptyInvasiveDrafts(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (ChatPatches.config.onlyInvasiveDrafting && keyCode == 256) {
            this.field_2382.method_1852("");
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;setScreen(Lnet/minecraft/client/gui/screens/Screen;)V", ordinal=1, shift=At.Shift.AFTER)})
    private void emptySentDrafts(CallbackInfoReturnable<Boolean> cir) {
        messageDraft = "";
    }

    @WrapOperation(method={"mouseClicked"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/EditBox;mouseClicked(DDI)Z")})
    private boolean disableChatFieldFocus(class_342 chatField, double mX, double mY, int button, Operation<Boolean> mouseClicked) {
        return (!ChatPatches.config.search || !showSearchBar) && (Boolean)mouseClicked.call(new Object[]{chatField, mX, mY, button}) != false;
    }

    @WrapOperation(method={"mouseClicked"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/ChatComponent;handleChatQueueClicked(DD)Z")})
    private boolean fixMenuClickthroughClick(class_338 chatHud, double mX, double mY, Operation<Boolean> mouseClicked) {
        return !this.isMouseOverSettingsMenu(mX, mY) && !contextMenu.method_25405(mX, mY) && (Boolean)mouseClicked.call(new Object[]{chatHud, mX, mY}) != false;
    }

    @WrapOperation(method={"mouseClicked"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/ChatScreen;getComponentStyleAt(DD)Lnet/minecraft/network/chat/Style;")})
    private class_2583 fixStyleClickthrough(class_408 screen, double mX, double mY, Operation<class_2583> getTextStyleAt) {
        return this.isMouseOverSettingsMenu(mX, mY) || contextMenu.method_25405(mX, mY) ? null : (class_2583)getTextStyleAt.call(new Object[]{screen, mX, mY});
    }

    @WrapMethod(method={"mouseClicked"})
    private boolean fixContextMenuNotClosing(double mX, double mY, int button, Operation<Boolean> mouseClicked) {
        boolean clicked = (Boolean)mouseClicked.call(new Object[]{mX, mY, button});
        if (button != 1) {
            contextMenu.close(x$0 -> this.method_37066((class_364)x$0));
        }
        return clicked;
    }

    @Inject(method={"mouseClicked"}, at={@At(value="TAIL")}, cancellable=true)
    public void mouseClickedEvents(double mX, double mY, int button, CallbackInfoReturnable<Boolean> cir) {
        if (cir.getReturnValueZ()) {
            return;
        }
        if (this.searchField.method_25402(mX, mY, button)) {
            cir.setReturnValue((Object)true);
        }
        if (this.isMouseOverSettingsMenu(mX, mY)) {
            if (this.caseSensitiveButton.method_25402(mX, mY, button)) {
                cir.setReturnValue((Object)true);
            } else if (this.regexButton.method_25402(mX, mY, button)) {
                cir.setReturnValue((Object)true);
            }
        } else if (contextMenu.method_25402(mX, mY, button)) {
            contextMenu.close(x$0 -> this.method_37066((class_364)x$0));
            cir.setReturnValue((Object)true);
        } else if (button == 1) {
            ContextMenu newMenu = new ContextMenu((class_408)this, mX, mY);
            if (ChatScreenMixin.contextMenu.clickPos.x != mX || ChatScreenMixin.contextMenu.clickPos.y != mY && newMenu.isFunctional()) {
                contextMenu.close(x$0 -> this.method_37066((class_364)x$0));
                newMenu.init(x$0 -> {
                    class_4264 cfr_ignored_0 = (class_4264)this.method_25429((class_364)x$0);
                });
                this.method_25395(newMenu);
                contextMenu = newMenu;
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void allowContextMenuKeyPressing(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (contextMenu.method_25404(keyCode, scanCode, modifiers) && class_8494.method_51255((int)keyCode)) {
            contextMenu.close(x$0 -> this.method_37066((class_364)x$0));
            this.blockSpaceConsumption = true;
            cir.setReturnValue((Object)true);
        }
    }

    public boolean method_25400(char chr, int mods) {
        return this.blockSpaceConsumption && chr == ' ' && this.field_2382.method_25370() ? (this.blockSpaceConsumption = false) : super.method_25400(chr, mods);
    }

    public void method_16014(double mX, double mY) {
        contextMenu.method_16014(mX, mY);
    }

    @WrapOperation(method={"keyPressed"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/ChatScreen;moveInHistory(I)V")})
    private void searchHistory(class_408 chatScreen, int offset, Operation<Void> setChatFromHistory) {
        if (!ChatPatches.config.searchPrefix) {
            setChatFromHistory.call(new Object[]{chatScreen, offset});
            return;
        }
        int cursor = this.field_2382.method_1881();
        String prefix = this.field_2382.method_1882().substring(0, cursor);
        class_8623 history = this.minecraft.field_1705.method_1743().method_1809();
        int newOffset = 0;
        for (int newHistoryIndex = this.field_2387 + offset; 0 <= newHistoryIndex && newHistoryIndex < history.size(); newHistoryIndex += offset) {
            if (!((String)history.get(newHistoryIndex)).startsWith(prefix)) continue;
            newOffset = newHistoryIndex - this.field_2387;
            break;
        }
        setChatFromHistory.call(new Object[]{chatScreen, newOffset});
        this.field_2382.method_1875(cursor);
        this.field_2382.method_1884(cursor);
    }

    @Unique
    private boolean isMouseOverSettingsMenu(double mX, double mY) {
        return this.showSettingsMenu && mX >= 2.0 && mX <= 148.0 && mY >= (double)(this.field_22790 + -113) && mY <= (double)(this.field_22790 + -113 + 76);
    }

    @Unique
    private class_4185 makeSettingButton(String key, int yOffset) {
        Config.Setting setting = ChatPatches.config.getOption(key);
        class_5250 name = class_2561.method_43471((String)("text.chatpatches.search." + key));
        class_5250 text = class_5244.method_30619((class_2561)name, (boolean)((Boolean)setting.get()));
        return class_4185.method_46430((class_2561)text, arg_0 -> this.lambda$makeSettingButton$9(setting, (class_2561)name, arg_0)).method_46434(8, this.field_22790 + -56 - 51 + yOffset, this.minecraft.field_1772.method_1727(text.getString()) + 10, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)("text.chatpatches.search.desc." + key)))).method_46431();
    }

    @Override
    @Unique
    public List<class_303> getSearchResults() {
        return searchResults;
    }

    @Unique
    private void onSearchFieldUpdate(String text, boolean refresh) {
        if (text.equals(searchDraft) && !refresh) {
            return;
        }
        class_338 chatHud = this.minecraft.field_1705.method_1743();
        if (!text.isEmpty() || refresh) {
            if (!text.isEmpty()) {
                this.searchField.method_1887(null);
            }
            class_124 status = class_124.field_1068;
            if (ChatPatches.config.regex) {
                try {
                    searchMatcher = Pattern.compile(text, ChatPatches.config.caseSensitive ? 0 : 2).matcher("");
                    this.searchError = null;
                }
                catch (PatternSyntaxException e) {
                    this.searchError = e;
                    status = class_124.field_1061;
                    chatHud.method_1817();
                }
            } else {
                this.searchError = null;
            }
            if (this.searchError == null) {
                List<class_303> messages = ((ChatHudAccess)chatHud).chatpatches$getMessages();
                List<class_303> copy = List.copyOf(messages);
                messages.removeIf(Predicate.not(msg -> {
                    String m = class_124.method_539((String)msg.comp_893().getString());
                    return ChatPatches.config.regex ? searchMatcher.reset(m).matches() : (ChatPatches.config.caseSensitive ? m.contains(text) : StringUtils.containsIgnoreCase((CharSequence)m, (CharSequence)text));
                }));
                searchResults.clear();
                if (!messages.isEmpty()) {
                    searchResults.addAll(messages);
                    chatHud.method_1817();
                    messages.clear();
                    messages.addAll(copy);
                    status = class_124.field_1060;
                } else {
                    messages.addAll(copy);
                    chatHud.method_1817();
                    status = class_124.field_1054;
                }
            }
            this.searchField.method_1868(status.method_532().intValue());
        } else {
            this.searchError = null;
            this.searchField.method_1868(0xE0E0E0);
            this.searchField.method_1887(SEARCH_SUGGESTION);
            searchResults.clear();
            chatHud.method_1817();
        }
        searchDraft = text;
    }

    private /* synthetic */ void lambda$makeSettingButton$9(Config.Setting setting, class_2561 name, class_4185 me) {
        setting.set((Boolean)setting.get() == false);
        me.method_25355((class_2561)class_5244.method_30619((class_2561)name, (boolean)((Boolean)setting.get())));
        this.onSearchFieldUpdate(this.searchField.method_1882(), true);
    }
}

