/*
 * Decompiled with CFR 0.152.
 */
package obro1961.chatpatches.util;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_338;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import obro1961.chatpatches.Boundary;
import obro1961.chatpatches.ChatLog;
import obro1961.chatpatches.ChatPatches;
import obro1961.chatpatches.accessor.ChatHudAccess;
import obro1961.chatpatches.util.TextUtils;
import org.apache.logging.log4j.core.util.Integers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChatUtils {
    public static final class_303 NIL_HUD_LINE = new class_303(0, class_5244.field_39003, null, null);
    public static final MessageData NIL_MESSAGE_DATA;
    public static final int TIMESTAMP_INDEX = 0;
    public static final int MESSAGE_INDEX = 1;
    public static final int DUPE_INDEX = 2;
    public static final int MSG_TEAM_INDEX = 0;
    public static final int MSG_SENDER_INDEX = 1;
    public static final int MSG_CONTENT_INDEX = 2;
    public static final int MAX_MESSAGE_LENGTH = 256;
    public static MessageData messageData;
    public static final Matcher VANILLA_FORMAT;
    public static final Matcher PARSEABLE_MESSAGE_KEYS;

    private static class_310 mc() {
        return class_310.method_1551();
    }

    public static int message2Visible(int messageIndex) {
        List<class_303.class_7590> visibles = ((ChatHudAccess)ChatUtils.mc().field_1705.method_1743()).chatpatches$getVisibleMessages();
        if (messageIndex == -1) {
            return -1;
        }
        int EoEs = -1;
        for (int j = 0; j < visibles.size(); ++j) {
            if (!visibles.get(j).comp_898() || ++EoEs != messageIndex) continue;
            return j;
        }
        return -1;
    }

    public static int visible2Message(int visibleIndex) {
        List<class_303.class_7590> visibles = ((ChatHudAccess)ChatUtils.mc().field_1705.method_1743()).chatpatches$getVisibleMessages();
        if (visibleIndex == -1 || visibleIndex >= visibles.size()) {
            return -1;
        }
        return (int)((long)visibleIndex - visibles.subList(0, visibleIndex).stream().filter(Predicate.not(class_303.class_7590::comp_898)).count());
    }

    public static class_2561 getPart(class_2561 message, int index) {
        return message.method_10855().size() > index ? (class_2561)message.method_10855().get(index) : class_5244.field_39003;
    }

    public static class_2561 getMsgPart(class_2561 message, int index) {
        return ChatUtils.getPart(ChatUtils.getPart(message, 1), index);
    }

    public static class_5250 getArg(class_2588 content, int index) {
        return TextUtils.asText(content.method_11023()[index]);
    }

    @NotNull
    public static class_5250 buildMessage(@Nullable class_2583 rootStyle, @Nullable class_2561 first, @Nullable class_2561 second, @Nullable class_2561 third) {
        class_5250 root = class_2561.method_43473();
        if (rootStyle != null) {
            root.method_10862(rootStyle);
        }
        first = (class_2561)Objects.requireNonNullElse(first, class_2561.method_43473());
        second = (class_2561)Objects.requireNonNullElse(second, class_2561.method_43473());
        third = (class_2561)Objects.requireNonNullElse(third, class_2561.method_43473());
        return root.method_10852(first).method_10852(second).method_10852(third);
    }

    private static String optimizeEmpties(Object o) {
        String str;
        return (o instanceof String ? (str = (String)o) : String.valueOf(o)).replace("literal{}", "empty").replace("[style={}]", "");
    }

    public static class_2561 modifyMessage(@NotNull class_2561 m) {
        class_5250 content;
        class_5250 timestamp;
        block15: {
            if (ChatLog.isRestoring()) {
                return ChatUtils.tryCondenseDupes(m);
            }
            boolean lastEmpty = messageData.equals(NIL_MESSAGE_DATA);
            boolean boundary = Boundary.isBoundaryLine(m);
            Date now = lastEmpty ? new Date() : ChatUtils.messageData.timestamp;
            class_2583 style = m.method_10866();
            timestamp = null;
            content = m.method_27661();
            try {
                timestamp = ChatPatches.config.makeTimestamp(now, lastEmpty, boundary);
                if (ChatPatches.config.name && !lastEmpty && ChatUtils.messageData.vanilla && VANILLA_FORMAT.reset(m.getString()).matches()) {
                    class_2588 ttc;
                    content = class_2561.method_43473().method_10862(style);
                    class_7417 class_74172 = m.method_10851();
                    if (class_74172 instanceof class_2588 && PARSEABLE_MESSAGE_KEYS.reset((ttc = (class_2588)class_74172).method_11022()).matches()) {
                        boolean team = ttc.method_11022().contains("team");
                        class_5250 teamPart = class_2561.method_43473();
                        if (team) {
                            if (ttc.method_11022().endsWith("sent")) {
                                teamPart.method_10852((class_2561)class_2561.method_43470((String)"-> ").method_10862(style));
                            }
                            teamPart.method_10852((class_2561)ChatUtils.getArg(ttc, 0).method_27661().method_27693(" "));
                        }
                        content.method_10852((class_2561)teamPart);
                        content.method_10852((class_2561)ChatPatches.config.formatPlayername(ChatUtils.messageData.sender));
                        content.method_10852((class_2561)ChatUtils.getArg(ttc, team ? 2 : 1));
                    } else {
                        String afterEndBracket;
                        class_5250 realContent = class_2561.method_43473();
                        List parts = Lists.asList((Object)m.method_27662().method_10862(style), (Object[])m.method_10855().toArray(new class_2561[0]));
                        class_2561 firstPart = parts.stream().filter(p -> p.getString().contains(">")).findFirst().orElseGet(() -> {
                            String error = "No closing angle bracket found in vanilla message '" + m.getString() + "'!";
                            ChatPatches.logReportMsg(new IllegalStateException(error));
                            ChatPatches.pushErrorToast("Message modification error", error);
                            return class_2561.method_43470((String)">");
                        });
                        String[] split = firstPart.getString().split(">");
                        String string = afterEndBracket = split.length > 1 ? split[1] : "";
                        if (!afterEndBracket.isEmpty()) {
                            realContent.method_10852((class_2561)class_2561.method_43470((String)afterEndBracket).method_10862(firstPart.method_10866()));
                        }
                        for (int i = parts.indexOf(firstPart) + 1; i < parts.size(); ++i) {
                            realContent.method_10852((class_2561)parts.get(i));
                        }
                        content.method_10852(class_5244.field_39003);
                        content.method_10852((class_2561)ChatPatches.config.formatPlayername(ChatUtils.messageData.sender));
                        content.method_10852((class_2561)realContent);
                    }
                }
                if (ChatPatches.config.logMessageStructures) {
                    throw new AssertionError("Time to log those message structures!", null);
                }
            }
            catch (AssertionError | RuntimeException e) {
                ChatPatches.LOGGER.error("[ChatUtils.modifyMessage] An error occurred while modifying '{}'", (Object)m.getString());
                ChatPatches.LOGGER.error("\tTimestamp: {}", (Object)ChatUtils.optimizeEmpties(timestamp));
                ChatPatches.LOGGER.error("\tBody:");
                if (content.method_10855().size() == 3 && !content.equals((Object)m)) {
                    ChatPatches.LOGGER.error("\t\tTeam: {}", (Object)ChatUtils.optimizeEmpties(ChatUtils.getPart((class_2561)content, 0)));
                    ChatPatches.LOGGER.error("\t\tSender: {}", (Object)ChatUtils.optimizeEmpties(ChatUtils.getPart((class_2561)content, 1)));
                    ChatPatches.LOGGER.error("\t\tContent: {}", (Object)ChatUtils.optimizeEmpties(ChatUtils.getPart((class_2561)content, 2)));
                } else {
                    ChatPatches.LOGGER.error("\t\tRoot: {}", (Object)ChatUtils.optimizeEmpties(content.method_10851()));
                    for (int i = 0; i < content.method_10855().size(); ++i) {
                        ChatPatches.LOGGER.error("\t\tSibling {}: {}", (Object)i, (Object)ChatUtils.optimizeEmpties(ChatUtils.getPart((class_2561)content, i)));
                    }
                }
                if (m.method_10855().size() == 3) {
                    ChatPatches.LOGGER.error("\tDupes: {}", (Object)ChatUtils.optimizeEmpties(ChatUtils.getPart(m, 2)));
                }
                ChatPatches.LOGGER.error("[ChatUtils.modifyMessage] -- End of message structure --");
                if (!(e instanceof RuntimeException)) break block15;
                ChatPatches.logReportMsg((Throwable)e);
                ChatPatches.pushErrorToast("Message modification error", ((Throwable)e).getMessage());
            }
        }
        class_2561 modified = ChatUtils.tryCondenseDupes((class_2561)ChatUtils.buildMessage(null, (class_2561)timestamp, (class_2561)content, null));
        ChatLog.addMessage(modified);
        messageData = NIL_MESSAGE_DATA;
        return modified;
    }

    private static class_2561 tryCondenseDupes(class_2561 incoming) {
        class_338 hud = ChatUtils.mc().field_1705.method_1743();
        ChatHudAccess access = (ChatHudAccess)hud;
        List<class_303> messages = access.chatpatches$getMessages();
        if (!ChatPatches.config.counter || messages.isEmpty()) {
            return incoming;
        }
        ObjectArrayList siblings = new ObjectArrayList((Collection)incoming.method_10855());
        List<class_303.class_7590> visibles = access.chatpatches$getVisibleMessages();
        int attemptDistance = switch (ChatPatches.config.compactChat ? Math.abs(ChatPatches.config.compactDistance) : 1) {
            case 0 -> hud.method_1813();
            case 1 -> 1;
            default -> Math.min(ChatPatches.config.compactDistance, messages.size());
        };
        int dupeCount = 1;
        for (int i = 0; i < attemptDistance && i < messages.size(); ++i) {
            class_2561 msg = messages.get(i).comp_893();
            if (!ChatUtils.getPart(incoming, 1).getString().equalsIgnoreCase(ChatUtils.getPart(msg, 1).getString()) || ChatPatches.config.counterCheckStyle && !TextUtils.withoutContent(incoming).equals((Object)TextUtils.withoutContent(msg))) continue;
            dupeCount += Integers.parseInt((String)ChatUtils.getPart(msg, 2).getString().replaceAll("(\u00a7\\d)|\\D", ""), (int)1);
            int v = ChatPatches.config.compactChat ? ChatUtils.message2Visible(i) : i;
            do {
                visibles.remove(v);
            } while (v < visibles.size() && !visibles.get(v).comp_898());
            messages.remove(i);
            --i;
            --attemptDistance;
        }
        if (dupeCount > 1) {
            if (siblings.size() > 2) {
                siblings.set(2, (Object)ChatPatches.config.makeDupeCounter(dupeCount));
            } else {
                siblings.add((Object)ChatPatches.config.makeDupeCounter(dupeCount));
            }
        }
        return TextUtils.newText(incoming.method_10851(), (List<class_2561>)siblings, incoming.method_10866());
    }

    static {
        messageData = NIL_MESSAGE_DATA = new MessageData(new GameProfile(class_156.field_25140, ""), Date.from(Instant.EPOCH), false);
        VANILLA_FORMAT = Pattern.compile("(?i)^((-> )?\\[.+] )?<.{3,}>\\s.+$").matcher("");
        PARSEABLE_MESSAGE_KEYS = Pattern.compile("chat.type.(text|team.(text|sent))").matcher("");
    }

    public record MessageData(GameProfile sender, Date timestamp, boolean vanilla) {
    }
}

