/*
 * Decompiled with CFR 0.152.
 */
package obro1961.chatpatches.config;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.RecordBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_268;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_407;
import net.minecraft.class_410;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5699;
import net.minecraft.class_640;
import net.minecraft.class_642;
import net.minecraft.class_745;
import net.minecraft.class_746;
import obro1961.chatpatches.ChatPatches;
import obro1961.chatpatches.accessor.ChatHudAccess;
import obro1961.chatpatches.config.YaclConfig;
import obro1961.chatpatches.util.ChatUtils;
import obro1961.chatpatches.util.TextUtils;

public class Config {
    public static final Config DEFAULTS = new Config();
    public static final Path PATH = FabricLoader.getInstance().getConfigDir().resolve("chatpatches.json");
    public static final String PLACEHOLDER = "$";
    protected static final int IO_THRESHOLD_SUGGESTION = 500;
    protected static String lastWorld = "";
    public boolean time = true;
    public boolean timeSystemMessages = true;
    public String timeDate = "HH:mm:ss";
    public String timeFormat = "[$]";
    public int timeColor = class_124.field_1076.method_532();
    public boolean hover = true;
    public String hoverDate = "MM/dd/yyyy";
    public String hoverFormat = "$";
    public int hoverColor = class_124.field_1068.method_532();
    public boolean counter = true;
    public String counterFormat = "&8(&7x&r$&8)";
    public int counterColor = class_124.field_1054.method_532();
    public boolean counterCheckStyle = false;
    public boolean compactChat = false;
    public int compactDistance = 0;
    public boolean boundary = true;
    public String boundaryFormat = "&8[&r$&8]";
    public int boundaryColor = class_124.field_1075.method_532();
    public boolean chatlog = true;
    public int chatlogSaveInterval = 0;
    public boolean name = true;
    public String nameFormat = "<$>";
    public int nameColor = class_124.field_1068.method_532();
    public int chatMaxMessages = 16384;
    public int chatWidth = 0;
    public int chatHeight = 0;
    public int chatShift = 0;
    public boolean dynamicChatShift = true;
    public boolean vanillaClearing = false;
    public boolean chatHidePacket = true;
    public boolean messageDrafting = false;
    public boolean onlyInvasiveDrafting = false;
    public boolean contextMenu = true;
    public int contextOutlineColor = class_124.field_1075.method_532();
    public String contextReplyFormat = "/msg $ ";
    public boolean search = true;
    public boolean searchDrafting = true;
    public boolean searchPrefix = false;
    public boolean caseSensitive = true;
    public boolean regex = false;
    public boolean logMessageStructures = false;

    protected static class_310 mc() {
        return class_310.method_1551();
    }

    public static Config initialize() {
        FabricLoader f = FabricLoader.getInstance();
        boolean accessibleInGame = f.isModLoaded("modmenu") || f.isModLoaded("catalogue") && f.isModLoaded("menulogue");
        ChatPatches.config = accessibleInGame ? new YaclConfig() : DEFAULTS;
        Config.deserialize();
        return ChatPatches.config;
    }

    public class_437 getConfigScreen(class_437 parent) {
        boolean suggestYACL = class_155.method_31372() >= 759;
        String link = "https://modrinth.com/mod/" + (suggestYACL ? "yacl" : "cloth-config");
        return new class_410(clicked -> {
            if (clicked) {
                class_407.method_49623((String)link, (class_437)parent, (boolean)true);
            } else {
                Config.mc().method_1507(parent);
            }
        }, (class_2561)class_2561.method_43471((String)"text.chatpatches.help.missing"), (class_2561)class_2561.method_43469((String)"text.chatpatches.desc.help.missing", (Object[])new Object[]{suggestYACL ? "YACL" : "Cloth Config"}), class_5244.field_41873, class_5244.field_24339);
    }

    private class_5250 makeText(String formatStr, String varStr, String prefix, String suffix, int rgbColor) {
        return TextUtils.text(prefix + TextUtils.fillVars(formatStr, varStr) + suffix).method_27694(s -> s.method_36139(rgbColor));
    }

    public class_5250 makeTimestamp(Date when, boolean system) {
        class_5250 timestamp = this.time && (this.timeSystemMessages || !system) ? this.makeText(this.timeFormat, new SimpleDateFormat(this.timeDate).format(when), "", " ", this.timeColor) : class_2561.method_43473();
        class_5250 hoverText = this.makeText(this.hoverFormat, new SimpleDateFormat(this.hoverDate).format(when), "", "", this.hoverColor);
        return timestamp.method_27694(s -> s.method_10949(this.hover ? TextUtils.showText((class_2561)hoverText) : null).method_10958(this.hover ? TextUtils.suggestCommand(hoverText.getString()) : null).method_10975(String.valueOf(when.getTime())).method_36139(this.timeColor));
    }

    public class_5250 formatPlayername(GameProfile profile) {
        class_2583 style = class_2583.field_24360.method_36139(this.nameColor);
        String name = profile != null ? profile.getName() : "<null>";
        try {
            String[] stringArray;
            class_268 team = Config.mc().field_1687.method_8428().method_1164(name);
            class_2583 hoverStyle = new class_745(Config.mc().field_1687, profile).method_5476().method_10866().method_27702(style);
            if (this.nameFormat.equals(PLACEHOLDER)) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "";
                stringArray = stringArray2;
                stringArray2[1] = "";
            } else {
                stringArray = this.nameFormat.split("\\$");
            }
            String[] configFormat = stringArray;
            ObjectArrayList components = new ObjectArrayList(team != null ? 5 : 3);
            components.add((Object)TextUtils.text(configFormat[0]));
            components.add((Object)TextUtils.text(name));
            components.add((Object)TextUtils.text(configFormat[1] + " "));
            if (team != null) {
                components.add(1, (Object)team.method_1144());
                components.add(3, (Object)team.method_1136());
            }
            return TextUtils.newText(class_2585.field_39004, (List<class_2561>)components, hoverStyle);
        }
        catch (RuntimeException e) {
            ChatPatches.LOGGER.error("[Config.formatPlayername] /!\\ An error occurred while trying to format '{}'s playername /!\\", (Object)name);
            if (Config.mc().field_1687 == null) {
                e.addSuppressed(new IllegalStateException("[Config#formatPlayername] Expected existing ClientWorld"));
            }
            ChatPatches.logReportMsg(e);
            ChatPatches.pushErrorToast("Playername formatting error", e.getMessage());
            return this.makeText(this.nameFormat, name, "", " ", style.method_10973().method_27716()).method_27696(style);
        }
    }

    public class_5250 makeDupeCounter(int dupes) {
        return this.makeText(this.counterFormat, Integer.toString(dupes), " ", "", this.counterColor);
    }

    public void sendBoundaryLine() {
        Object object;
        if (!this.boundary || this.vanillaClearing) {
            return;
        }
        List<class_303> messages = ((ChatHudAccess)Config.mc().field_1705.method_1743()).chatpatches$getMessages();
        if (Config.mc().method_1496()) {
            object = "C_" + Config.mc().method_1576().method_27728().method_150();
        } else {
            class_642 class_6422 = Config.mc().method_1558();
            if (class_6422 instanceof class_642) {
                class_642 entry = class_6422;
                object = "S_" + (entry.field_3752.isBlank() ? entry.field_3761 : entry.field_3752);
            } else {
                object = "?_?";
            }
        }
        String world = object;
        class_5250 boundary = ChatUtils.buildMessage(null, null, null, (class_2561)this.makeText(this.boundaryFormat, world.substring(2), "", "", this.boundaryColor));
        if (!(messages.isEmpty() || messages.get(0).comp_893().getString().equals(boundary.getString()) || world.startsWith("S_") && lastWorld.startsWith("S_") && world.equals(lastWorld))) {
            try {
                boolean time = ChatPatches.config.time;
                lastWorld = world;
                ChatPatches.config.time = false;
                Config.mc().field_1705.method_1743().method_1812((class_2561)boundary);
                ChatPatches.config.time = time;
            }
            catch (RuntimeException e) {
                ChatPatches.LOGGER.warn("[Config.sendBoundaryLine] An error occurred while adding the boundary line:", (Throwable)e);
            }
        }
    }

    public int calcDynamicChatShift() {
        class_640 entry;
        class_746 player = Config.mc().field_1724;
        if (!ChatPatches.config.dynamicChatShift || player == null) {
            return this.chatShift;
        }
        class_640 class_6402 = Config.mc().method_1562().method_2871(player.method_5667());
        if (class_6402 instanceof class_640 && !(entry = class_6402).method_2958().method_8388()) {
            return this.chatShift;
        }
        int armor = player.method_6096();
        float absorption = player.method_6067();
        float health = player.method_6063();
        double scale = Config.mc().field_1705.method_1743().method_1814();
        int armorHeightMultiplier = armor == 0 ? 0 : 1 + (armor - 1) / 20;
        int healthHeightMultiplier = (int)(health + absorption - 1.0f) / 20;
        float healthScale = healthHeightMultiplier > 7 ? 0.3f : 0.00583333f * (float)Math.pow(healthHeightMultiplier, 3.0) - 0.0722619f * (float)Math.pow(healthHeightMultiplier, 2.0) + 0.154048f * (float)healthHeightMultiplier + 0.918571f;
        return armorHeightMultiplier * class_3532.method_15357((double)(10.0 / scale)) + healthHeightMultiplier * class_3532.method_15357((double)((double)(10.0f * healthScale) / scale)) + this.chatShift;
    }

    public static void deserialize() {
        long start = System.currentTimeMillis();
        ChatPatches.LOGGER.info("[Config.deserialize] Reading...");
        if (!Files.exists(PATH, new LinkOption[0])) {
            ChatPatches.config.resetValues();
            ChatPatches.LOGGER.info("[Config.deserialize] No config file found; using default values");
            return;
        }
        try {
            String raw = Files.readString(PATH);
            JsonObject json = class_3518.method_15285((String)raw);
            ChatPatches.config = (Config)ChatPatches.config.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(e -> ChatPatches.logReportMsg((Throwable)new JsonParseException(e))).orElseThrow();
            ChatPatches.LOGGER.info("[Config.deserialize] Read config data from '{}'!", (Object)PATH);
        }
        catch (IOException | NoSuchElementException e2) {
            ChatPatches.config.resetValues();
            String action = e2 instanceof NoSuchElementException ? "decode" : "read";
            ChatPatches.LOGGER.error("[Config.deserialize] An error occurred while trying to {} config data from '{}', backing up and using default settings:", new Object[]{action, PATH, e2});
            Config.backup();
        }
        catch (RuntimeException e3) {
            ChatPatches.config.resetValues();
            ChatPatches.LOGGER.error("[Config.deserialize] An unexpected error occurred, backing up and using default settings");
            ChatPatches.logReportMsg(e3);
            Config.backup();
        }
        ChatPatches.logDuration(start, 500L);
    }

    public static void serialize() {
        ChatPatches.executeIoTask(() -> {
            long start = System.currentTimeMillis();
            ChatPatches.LOGGER.info("[Config.serialize] Saving...");
            try {
                JsonElement json = (JsonElement)ChatPatches.config.encodeStart((DynamicOps)JsonOps.INSTANCE).resultOrPartial(e -> ChatPatches.logReportMsg((Throwable)new JsonParseException(e))).orElseThrow();
                String pretty = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create().toJson(json);
                Files.writeString(PATH, (CharSequence)pretty, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                ChatPatches.LOGGER.info("[Config.serialize] Saved config data to '{}'!", (Object)PATH);
            }
            catch (IOException | NoSuchElementException e2) {
                String action = e2 instanceof NoSuchElementException ? "encode" : "save";
                ChatPatches.LOGGER.error("[Config.serialize] An error occurred while trying to {} config data to '{}'", (Object)action, (Object)PATH);
                ChatPatches.logReportMsg(e2);
            }
            ChatPatches.logDuration(start, 500L);
        });
    }

    public static void backup() {
        ChatPatches.executeIoTask(() -> {
            try {
                Files.copy(PATH, PATH.resolveSibling("chatpatches_" + class_156.method_44893() + ".json"), new CopyOption[0]);
            }
            catch (IOException e) {
                ChatPatches.LOGGER.warn("[Config.backup] An error occurred trying to back up the original config file:", (Throwable)e);
            }
        });
    }

    public ObjectList<Setting<?>> getOptions() {
        Field[] fields = Config.class.getFields();
        ObjectArrayList options = new ObjectArrayList(fields.length);
        try {
            for (Field f : fields) {
                if (Modifier.isStatic(f.getModifiers())) continue;
                options.add(new Setting<Object>(f.get(ChatPatches.config), f.get(DEFAULTS), f.getName()));
            }
        }
        catch (IllegalAccessException e) {
            ChatPatches.logReportMsg(e);
        }
        return options;
    }

    public <T> Setting<T> getOption(String key) {
        return this.getOptions().stream().filter(opt -> opt.key.equals(key)).findFirst().orElseGet(() -> {
            ChatPatches.logReportMsg(new IllegalArgumentException("No such option: " + key));
            return new Setting<Object>(new Object(), new Object(), key);
        });
    }

    protected void resetValues() {
        ChatPatches.config = ChatPatches.config instanceof YaclConfig ? new YaclConfig() : DEFAULTS;
    }

    public <R, T> DataResult<R> encodeStart(DynamicOps<R> ops) {
        RecordBuilder builder = ops.mapBuilder();
        for (Setting opt : this.getOptions()) {
            Object val = opt.val;
            MapCodec optCodec = opt.getTypeCodec();
            builder = optCodec.encode(val, ops, builder);
        }
        return builder.build(ops.empty());
    }

    public <S, T> DataResult<Config> parse(DynamicOps<S> ops, S encoded) {
        for (Setting opt : this.getOptions()) {
            MapCodec optCodec = opt.getTypeCodec();
            DataResult result = optCodec.decoder().parse(ops, encoded);
            if (result.error().isPresent() || result.result().isEmpty()) {
                String message = "[Config.parse] Failed to parse field '" + opt.key + "': " + result.error().map(e -> e.message()).orElse("<unknown>");
                ChatPatches.logReportMsg(new IllegalStateException(message));
                return DataResult.error(() -> message);
            }
            opt.set(result.result().get());
        }
        return DataResult.success((Object)this);
    }

    public static class Setting<T> {
        public final String key;
        public final T def;
        protected T val;

        public Setting(T val, T def, String key) {
            this.val = Objects.requireNonNull(val, "Cannot create a setting option without a value");
            this.def = Objects.requireNonNull(def, "Cannot create a setting option without a default value");
            this.key = Objects.requireNonNull(key, "Cannot create a setting option without a lang key");
        }

        public T get() {
            return this.val;
        }

        public Class<T> getType() {
            return this.def.getClass();
        }

        public void set(Object obj) {
            try {
                Object inc = obj;
                if (inc != null && !inc.equals(this.val)) {
                    ChatPatches.config.getClass().getField(this.key).set(ChatPatches.config, inc);
                    this.val = inc;
                }
            }
            catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
                ChatPatches.LOGGER.error("[Setting.set({})] An error occurred trying to change config option '{}'", obj, (Object)this.key);
                ChatPatches.logReportMsg(e);
            }
        }

        public MapCodec<T> getTypeCodec() {
            Codec codec;
            if (this.key.contains("Color")) {
                codec = class_5699.method_52465((Codec)class_5251.field_39242, (Codec)Codec.INT.xmap(class_5251::method_27717, class_5251::method_27716)).xmap(class_5251::method_27716, class_5251::method_27717);
            } else {
                codec = switch (this.getType().getName()) {
                    case "java.lang.Boolean", "boolean" -> Codec.BOOL;
                    case "java.lang.Integer", "int" -> Codec.INT;
                    case "java.lang.String" -> {
                        if (this.key.contains("Format")) {
                            yield Codec.STRING.comapFlatMap(raw -> raw.contains(Config.PLACEHOLDER) ? DataResult.success((Object)raw) : DataResult.error(() -> "Format string '" + raw + "' for option '" + this.key + "' is missing a '$' placeholder"), Function.identity());
                        }
                        if (this.key.contains("Date")) {
                            yield Codec.STRING.comapFlatMap(raw -> {
                                try {
                                    new SimpleDateFormat((String)raw);
                                    return DataResult.success((Object)raw);
                                }
                                catch (IllegalArgumentException e) {
                                    return DataResult.error(() -> "Date string '" + raw + "' for option '" + this.key + "' is not a valid SimpleDateFormat");
                                }
                            }, Function.identity());
                        }
                        yield Codec.STRING;
                    }
                    default -> {
                        ChatPatches.logReportMsg(new IllegalStateException("Option '" + this.key + "' is not a valid type for serialization"));
                        yield Codec.STRING;
                    }
                };
            }
            return codec.optionalFieldOf(this.key, this.def);
        }
    }
}

