/*
 * Decompiled with CFR 0.152.
 */
package obro1961.chatpatches.util;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5699;
import net.minecraft.class_7417;

public class TextUtils {
    public static final Matcher AMPERSAND_REGEX = Pattern.compile("(?im)&([0-9a-fk-or])").matcher("");
    public static final Matcher NO_BACKSLASH_AMPERSAND_REGEX = Pattern.compile("(?im)(?<!\\\\)&([0-9a-fk-or])").matcher("");
    public static final Matcher DUPLICATE_COLOR_AMPERSAND_REGEX = Pattern.compile("(?im)&(?:#[\\da-f]{6}|[\\da-f])(\\s*)&(#[\\da-f]{6}|[\\da-f])").matcher("");
    public static final Int2ObjectMap<class_124> COLOR_TO_FORMATTING = (Int2ObjectMap)class_156.method_656(() -> {
        Int2ObjectArrayMap map = new Int2ObjectArrayMap(16);
        for (class_124 f : class_124.values()) {
            if (!f.method_543()) continue;
            map.put(f.method_532().intValue(), (Object)f);
        }
        return map;
    });

    public static Codec<class_2561> textCodec() {
        return class_5699.field_40722;
    }

    public static String fillVars(String str, String variable) {
        return str.replace("$", variable).replace("\\n", "\n");
    }

    public static class_5250 asText(Object o) {
        String string;
        if (o == null) {
            return class_2561.method_43473();
        }
        if (o instanceof class_2561) {
            return (class_5250)o;
        }
        if (o instanceof class_5348) {
            class_5348 ft = (class_5348)o;
            string = ft.getString();
        } else {
            string = String.valueOf(o);
        }
        return class_2561.method_43470((String)string);
    }

    public static class_5250 truncate(class_2561 text, int max) {
        if (class_124.method_539((String)text.getString()).length() <= max) {
            return (class_5250)text;
        }
        class_5250 truncated = class_2561.method_43473();
        int[] len = new int[]{0};
        text.method_27658((style, str) -> {
            if (str.length() + len[0] > max) {
                if (len[0] >= max) {
                    return Optional.empty();
                }
                str = str.substring(0, max - len[0]);
            }
            truncated.method_10852((class_2561)class_2561.method_43470((String)str).method_10862(style));
            len[0] = len[0] + str.length();
            return Optional.empty();
        }, class_2583.field_24360);
        return truncated;
    }

    public static class_5250 newText(class_7417 content, List<class_2561> siblings, class_2583 style) {
        class_5250 text = class_5250.method_43477((class_7417)content).method_10862(style);
        siblings.forEach(arg_0 -> ((class_5250)text).method_10852(arg_0));
        return text;
    }

    public static class_5250 newSiblings(class_2561 text, List<class_2561> siblings) {
        return TextUtils.newText(text.method_10851(), siblings, text.method_10866());
    }

    public static class_5250 withoutContent(class_2561 text) {
        return TextUtils.newText(class_7417.field_39004, text.method_10855(), text.method_10866());
    }

    public static class_2558 openUrl(String url) {
        return new class_2558(class_2558.class_2559.field_11749, url);
    }

    public static class_2558 suggestCommand(String command) {
        return new class_2558(class_2558.class_2559.field_11745, command);
    }

    public static class_2568 showText(class_2561 text) {
        return new class_2568(class_2568.class_5247.field_24342, (Object)text);
    }

    public static class_5250 text(String unformatted) {
        String s = NO_BACKSLASH_AMPERSAND_REGEX.reset(unformatted).replaceAll("\u00a7$1");
        s = AMPERSAND_REGEX.reset(s).replaceAll("&$2");
        return class_2561.method_43470((String)s);
    }

    public static String toCodedString(class_2561 text) {
        StringBuilder builder = new StringBuilder();
        AtomicReference<class_2583> lastStyle = new AtomicReference<class_2583>(class_2583.field_24360);
        text.method_27658((style, str) -> {
            if (!style.equals(lastStyle.get())) {
                builder.append(class_124.field_1075);
                builder.append(TextUtils.getFormattingCodes(style, (class_2583)lastStyle.get()));
                builder.append(class_124.field_1070);
                lastStyle.set(style);
            }
            builder.append(str.replace('\u00a7', '&'));
            return Optional.empty();
        }, class_2583.field_24360);
        while (builder.toString().startsWith("&r")) {
            builder.delete(0, 2);
        }
        while (builder.toString().endsWith("&r&r")) {
            builder.setLength(builder.length() - 4);
        }
        return DUPLICATE_COLOR_AMPERSAND_REGEX.reset(builder.toString()).replaceAll("$1&$2");
    }

    public static String getFormattingCodes(class_2583 style, class_2583 last) {
        class_124 formatting;
        StringJoiner joiner = new StringJoiner("&", "&", "").setEmptyValue("");
        class_5251 color = style.method_10973();
        class_124 class_1242 = formatting = color != null ? class_124.method_533((String)color.method_27721()) : class_124.field_1070;
        if (formatting != class_124.field_1070 && (last.method_10973() == null || color.method_27716() != last.method_10973().method_27716())) {
            if (formatting != null) {
                joiner.add("" + formatting.method_36145());
            } else if (COLOR_TO_FORMATTING.containsKey(color.method_27716())) {
                joiner.add("" + ((class_124)COLOR_TO_FORMATTING.get(color.method_27716())).method_36145());
            } else {
                joiner.add(color.method_27723());
            }
        } else if (style.equals((Object)class_2583.field_24360) && !last.equals((Object)class_2583.field_24360)) {
            return "&r";
        }
        if (style.method_10984() && !last.method_10984()) {
            joiner.add("l");
        }
        if (style.method_10966() && !last.method_10966()) {
            joiner.add("o");
        }
        if (style.method_10965() && !last.method_10965()) {
            joiner.add("n");
        }
        if (style.method_10986() && !last.method_10986()) {
            joiner.add("m");
        }
        if (style.method_10987() && !last.method_10987()) {
            joiner.add("k");
        }
        return joiner.toString();
    }
}

