/*
 * Decompiled with CFR 0.152.
 */
package obro1961.chatpatches.gui;

import com.google.common.collect.Iterables;
import com.google.gson.JsonParseException;
import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_338;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_364;
import net.minecraft.class_408;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6382;
import net.minecraft.class_7532;
import net.minecraft.class_7845;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8685;
import obro1961.chatpatches.ChatPatches;
import obro1961.chatpatches.accessor.ChatHudAccess;
import obro1961.chatpatches.accessor.ChatScreenAccess;
import obro1961.chatpatches.mixin.accessor.GridWidgetAccessor;
import obro1961.chatpatches.util.ChatUtils;
import obro1961.chatpatches.util.RenderUtils;
import obro1961.chatpatches.util.TextUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oshi.util.Memoizer;

public class ContextMenu
implements class_364 {
    public static final int MAX_ROWS = (int)FieldUtils.getAllFieldsList(ContextMenu.class).stream().filter(f -> f.getName().startsWith("MENU_") && f.getType().isInstance(class_5244.field_39003)).count();
    public static final int MAX_COLUMNS = 2;
    public static final String LANG_PREFIX = "text.chatpatches.context.";
    private static final int BUTTON_HEIGHT = 14;
    private static final int BUTTON_PADDING = 4;
    private static final Supplier<Pattern> URL_PATTERN = Memoizer.memoize(() -> Pattern.compile("\\b(?:https?://|www)[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]"));
    static final Function<Object, class_2561> UNKNOWN = id -> class_2561.method_43469((String)"text.chatpatches.context.unknown", (Object[])new Object[]{TextUtils.asText(id)});
    static final class_2561 MENU_STRING = class_2561.method_43471((String)"text.chatpatches.context.copyText");
    static final class_2561 RAW_TEXT = class_2561.method_43471((String)"text.chatpatches.context.rawText");
    static final class_2561 FORMATTED_STR = class_2561.method_43471((String)"text.chatpatches.context.formattedString");
    static final class_2561 NO_TIMESTAMP_TEXT = class_2561.method_43471((String)"text.chatpatches.context.noTimestampText");
    static final class_2561 NO_DUPE_TEXT = class_2561.method_43471((String)"text.chatpatches.context.noCounterText");
    static final class_2561 JSON_STR = class_2561.method_43471((String)"text.chatpatches.context.jsonString");
    static final class_2561 MENU_TIMESTAMP = class_2561.method_43471((String)"text.chatpatches.context.timestamp");
    static final class_2561 TIMESTAMP = class_2561.method_43471((String)"text.chatpatches.context.timestampText");
    static final class_2561 TIMESTAMP_HOVER = class_2561.method_43471((String)"text.chatpatches.context.timestampHoverText");
    static final class_2561 MENU_DUPE_COUNTER = class_2561.method_43471((String)"text.chatpatches.context.counter");
    static final class_2561 COUNTER_TEXT = class_2561.method_43471((String)"text.chatpatches.context.counterText");
    static final class_2561 COUNTER_VALUE = class_2561.method_43471((String)"text.chatpatches.context.counterValue");
    static final class_2561 MENU_UNIX = class_2561.method_43471((String)"text.chatpatches.context.unix");
    static final class_2561 MENU_LINKS = class_2561.method_43471((String)"text.chatpatches.context.links");
    static final Int2ObjectFunction<class_2561> LINK_N = n -> class_2561.method_43469((String)"text.chatpatches.context.linkN", (Object[])new Object[]{n});
    static final class_2561 MENU_SENDER = class_2561.method_43471((String)"text.chatpatches.context.sender");
    static final class_2561 NAME = class_2561.method_43471((String)"text.chatpatches.context.name");
    static final class_2561 UUID = class_2561.method_43471((String)"text.chatpatches.context.uuid");
    static final class_2561 MENU_REPLY = class_2561.method_43471((String)"text.chatpatches.context.reply");
    private final Grid grid;
    @Nullable
    private final class_408 screen;
    private final class_338 hud;
    private final ChatHudAccess access;
    public final RenderUtils.MousePos clickPos;
    private final class_303 selectedLine;
    private final GameProfile messageSender;
    private final int visibleMessageIndex;
    private final int visibleLines;
    private boolean noOp = false;

    private static class_310 mc() {
        return class_310.method_1551();
    }

    public ContextMenu(class_408 screen, double mX, double mY) {
        GameProfile gameProfile;
        Object object;
        int messageIndex;
        if (!ChatPatches.config.contextMenu || mX < 0.0 || mY < 0.0) {
            this.noOp = true;
        }
        this.clickPos = RenderUtils.MousePos.of(mX, mY);
        this.grid = new Grid();
        this.hud = ContextMenu.mc().field_1705.method_1743();
        this.access = (ChatHudAccess)this.hud;
        this.screen = this.noOp ? null : screen;
        ObjectList searchResults = this.noOp ? ObjectList.of() : ((ChatScreenAccess)screen).getSearchResults();
        ObjectList messages = searchResults.isEmpty() ? this.access.chatpatches$getMessages() : searchResults;
        int n = messageIndex = this.noOp ? -1 : this.access.getChatHudLineIndex(mX, mY);
        if (messageIndex == -1) {
            this.noOp = true;
        }
        this.selectedLine = this.noOp ? ChatUtils.NIL_HUD_LINE : (class_303)Iterables.get((Iterable)messages, (int)messageIndex, (Object)ChatUtils.NIL_HUD_LINE);
        this.visibleMessageIndex = this.noOp ? -1 : this.access.getEoEIndex(mX, mY);
        this.visibleLines = this.noOp ? 0 : (Integer)class_156.method_656(() -> {
            List<class_303.class_7590> visibles = this.access.chatpatches$getVisibleMessages();
            int l = 1;
            for (int j = this.visibleMessageIndex + 1; j < visibles.size() && !visibles.get(j).comp_898(); ++j) {
                ++l;
            }
            return l;
        });
        class_2583 s = ChatUtils.getMsgPart(this.selectedLine.comp_893(), 1).method_10866();
        if (s.method_10969() != null && (object = s.method_10969().method_10891(class_2568.class_5247.field_24344)) instanceof class_2568.class_5248) {
            class_2568.class_5248 info = (class_2568.class_5248)object;
            gameProfile = new GameProfile(info.field_24352, info.field_24353.orElse(UNKNOWN.apply(MENU_SENDER.method_27661().method_27693(" " + String.valueOf(info.field_24352)))).getString());
        } else {
            gameProfile = ChatUtils.NIL_MESSAGE_DATA.sender();
        }
        this.messageSender = gameProfile;
    }

    private void registerButton(class_2561 id, int localRow, int col, Supplier<class_2561> tooltipCopyTextSupplier, class_4185.class_4241 pressAction, Object renderObject) {
        int w = ContextMenu.mc().field_1772.method_27525((class_5348)id) + 8;
        int h = 18;
        Object button = class_4185.method_46430((class_2561)id, b -> {
            if (this.noOp) {
                return;
            }
            class_2561 copyText = tooltipCopyTextSupplier != null ? (class_2561)tooltipCopyTextSupplier.get() : class_5244.field_39003;
            String copyStr = class_3544.method_15440((String)copyText.getString());
            if (!copyStr.isEmpty()) {
                ContextMenu.mc().field_1774.method_1455(copyStr);
                ChatPatches.pushInfoToast(class_2561.method_43471((String)"text.chatpatches.context.copied"), copyText);
            }
            if (pressAction != null) {
                pressAction.onPress(b);
            }
        }).method_46434(this.clickPos.xInt(), this.clickPos.yInt(), w, h).method_46431();
        if (renderObject != null) {
            class_4185 src = button;
            button = new class_4264(button.method_46426(), button.method_46427(), button.method_25368() + 16, button.method_25364(), (class_2561)class_2561.method_43470((String)"    ").method_10852(id), (class_4264)src, renderObject, id){
                final class_4185.class_7841 narrationSupplier;
                final /* synthetic */ class_4264 val$src;
                final /* synthetic */ Object val$renderObject;
                final /* synthetic */ class_2561 val$id;
                {
                    this.val$src = class_42642;
                    this.val$renderObject = object;
                    this.val$id = class_25612;
                    super(x, y, width, height, message);
                    this.narrationSupplier = Supplier::get;
                }

                public void method_25306() {
                    this.val$src.method_25306();
                }

                protected void method_48579(class_332 graphics, int mX, int mY, float delta) {
                    super.method_48579(graphics, mX, mY, delta);
                    if (this.val$renderObject instanceof class_1792) {
                        class_1792 icon = (class_1792)this.val$renderObject;
                        graphics.method_51445(icon.method_7854(), this.method_46426() + 1, this.method_46427() + 1);
                    } else if (this.val$renderObject instanceof class_8685) {
                        class_8685 playerSkin = (class_8685)this.val$renderObject;
                        class_7532.method_52722((class_332)graphics, (class_8685)playerSkin, (int)(this.method_46426() + 1), (int)(this.method_46427() + 1), (int)16);
                    }
                }

                public String toString() {
                    return "ContextMenu.ButtonWidget[id=" + this.val$id.getString() + ", renderObject=" + String.valueOf(this.val$renderObject) + "]";
                }

                @NotNull
                protected class_5250 method_25360() {
                    return this.narrationSupplier.createNarrationMessage(() -> super.method_25360());
                }

                public void method_47399(class_6382 builder) {
                    this.method_37021(builder);
                }
            };
        }
        if (tooltipCopyTextSupplier != null) {
            button.method_47400(class_7919.method_47407((class_2561)tooltipCopyTextSupplier.get()));
        }
        this.grid.add((class_4264)button, localRow, col, tooltipCopyTextSupplier, pressAction);
    }

    private void registerProxyActionButton(class_2561 id, class_2561 proxyId, int localRow, int col, Object renderObject) {
        if (id.equals(proxyId)) {
            ChatPatches.logReportMsg(new IllegalArgumentException("Cannot register proxy action button with own id '" + id.getString() + "'"));
            return;
        }
        this.registerButton(id, localRow, col, null, me -> this.grid.get((class_2561)proxyId).button.method_25306(), renderObject);
    }

    private void registerProxyButton(class_2561 id, class_2561 proxyId, Object renderObject) {
        this.registerProxyActionButton(id, proxyId, 0, 0, renderObject);
    }

    private void registerActionButton(class_2561 id, int localRow, class_4185.class_4241 pressAction) {
        this.registerButton(id, localRow, 0, null, pressAction, null);
    }

    private void registerCopyButton(class_2561 id, int localRow, int col, Supplier<class_2561> tooltipCopyTextSupplier, Object renderObject) {
        this.registerButton(id, localRow, col, tooltipCopyTextSupplier, null, renderObject);
    }

    private void registerCopyButton(class_2561 id, int localRow, class_2561 tooltipCopyText) {
        this.registerButton(id, localRow, 1, () -> tooltipCopyText, null, null);
    }

    public void init(Consumer<class_4264> addSelectableChild) {
        if (this.noOp) {
            return;
        }
        class_2561 text = this.selectedLine.comp_893();
        class_2561 timestamp = ChatUtils.getPart(text, 0);
        boolean timestamped = !timestamp.getString().isBlank();
        class_2561 counter = ChatUtils.getPart(text, 2);
        boolean duped = text.method_10855().size() > 2 && !counter.getString().isEmpty();
        int strRow = 0;
        this.registerProxyButton(MENU_STRING, RAW_TEXT, class_1802.field_8788);
        this.registerCopyButton(RAW_TEXT, strRow++, text);
        this.registerCopyButton(FORMATTED_STR, strRow++, (class_2561)class_2561.method_43470((String)TextUtils.toCodedString(text)));
        if (timestamped) {
            this.registerCopyButton(NO_TIMESTAMP_TEXT, strRow++, (class_2561)TextUtils.newSiblings(text, text.method_10855().subList(1, text.method_10855().size())));
        }
        if (duped) {
            this.registerCopyButton(NO_DUPE_TEXT, strRow++, (class_2561)TextUtils.newSiblings(text, text.method_10855().subList(0, 2)));
        }
        this.registerCopyButton(JSON_STR, strRow, TextUtils.textCodec().encodeStart(ChatPatches.regBack(class_2509.field_11560), (Object)text).resultOrPartial(e -> ChatPatches.logReportMsg((Throwable)new JsonParseException(e))).map(class_2512::method_32270).orElse(UNKNOWN.apply(JSON_STR)));
        if (timestamped) {
            this.registerProxyButton(MENU_TIMESTAMP, TIMESTAMP, class_1802.field_8557);
            this.registerCopyButton(TIMESTAMP, 0, timestamp);
            class_2568 event = timestamp.method_10866().method_10969();
            Optional<class_2561> optional = event != null ? Optional.of((class_2561)event.method_10891(class_2568.class_5247.field_24342)) : Optional.empty();
            optional.ifPresent(hoverText -> this.registerCopyButton(TIMESTAMP_HOVER, 1, (class_2561)hoverText));
        }
        if (duped) {
            this.registerProxyButton(MENU_DUPE_COUNTER, COUNTER_TEXT, class_1802.field_8895);
            this.registerCopyButton(COUNTER_TEXT, 0, counter);
            this.registerCopyButton(COUNTER_VALUE, 1, (class_2561)class_2561.method_43470((String)counter.getString().replaceAll("(\u00a7\\d)|\\D", "").trim()));
        }
        this.registerCopyButton(MENU_UNIX, 0, 0, () -> {
            String time = timestamp.method_10866().method_10955();
            return time != null && !time.isEmpty() ? class_2561.method_30163((String)time) : UNKNOWN.apply(MENU_UNIX);
        }, class_1802.field_8725);
        ObjectList webLinks = (ObjectList)class_156.method_654((Object)new ObjectArrayList(), l -> {
            Matcher matcher = URL_PATTERN.get().matcher(text.getString());
            while (matcher.find()) {
                l.add((Object)matcher.group());
            }
        });
        ObjectList filePaths = (ObjectList)class_156.method_654((Object)new ObjectArrayList(), l -> text.method_27658((style, str) -> {
            String v;
            class_2558 ce;
            String patt22676$temp;
            class_2558 patt22626$temp = style.method_10970();
            if (patt22626$temp instanceof class_2558 && (patt22676$temp = (ce = patt22626$temp).method_10844()) instanceof String && !(v = patt22676$temp).isBlank()) {
                if (ce.method_10845() == class_2558.class_2559.field_11749 && !webLinks.contains((Object)v)) {
                    webLinks.add((Object)v);
                } else if (ce.method_10845() == class_2558.class_2559.field_11746 && !l.contains((Object)v)) {
                    l.add((Object)v);
                }
            }
            return Optional.empty();
        }, class_2583.field_24360));
        if (!webLinks.isEmpty() || !filePaths.isEmpty()) {
            int i;
            this.registerProxyButton(MENU_LINKS, (class_2561)LINK_N.apply(1), class_1802.field_23983);
            for (i = 0; i < filePaths.size(); ++i) {
                this.registerCopyButton((class_2561)LINK_N.apply(i + 1), i, class_2561.method_30163((String)("\u00a76\u00a7n" + (String)filePaths.get(i))));
            }
            for (i = filePaths.size(); i < webLinks.size() + filePaths.size(); ++i) {
                this.registerCopyButton((class_2561)LINK_N.apply(i + 1), i, class_2561.method_30163((String)("\u00a79\u00a7n" + (String)webLinks.get(i))));
            }
        }
        if (!this.messageSender.equals((Object)ChatUtils.NIL_MESSAGE_DATA.sender())) {
            String name = this.messageSender.getName();
            String id = this.messageSender.getId().toString();
            this.registerProxyActionButton(MENU_SENDER, NAME, 0, 0, class_1802.field_8448);
            this.registerCopyButton(NAME, 0, class_2561.method_30163((String)name));
            this.registerCopyButton(UUID, 1, class_2561.method_30163((String)id));
            this.registerButton(MENU_REPLY, 0, 0, null, me -> ((ChatScreenAccess)this.screen).chatpatches$getChatField().method_1852(TextUtils.fillVars(ChatPatches.config.contextReplyFormat, name)), ContextMenu.mc().method_1582().method_52862(this.messageSender));
        }
        this.grid.updateButtonPositions();
        this.grid.buttons().forEach(addSelectableChild);
    }

    public void render(class_332 graphics, int mX, int mY, float delta) {
        if (this.noOp) {
            return;
        }
        this.renderSelectionOutline(graphics);
        this.renderMenuButtons(graphics, mX, mY, delta);
    }

    private void renderSelectionOutline(class_332 graphics) {
        if (this.visibleLines == 0 || this.visibleMessageIndex == -1) {
            return;
        }
        int hoveredParts = this.visibleLines;
        double s = this.hud.method_1814();
        int lH = this.access.chatpatches$getLineHeight();
        int sW = class_3532.method_15384((double)((double)this.hud.method_1811() / s));
        int sH = class_3532.method_15357((double)((double)(ContextMenu.mc().method_22683().method_4502() - 40) / s));
        int shift = class_3532.method_15357((double)((double)ChatPatches.config.calcDynamicChatShift() / s));
        int i = this.visibleMessageIndex - this.access.chatpatches$getScrolledLines();
        int hoveredY = sH - i * lH - shift;
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22905((float)s, (float)s, 1.0f);
        int borderW = sW + 8;
        int scissorY1 = class_3532.method_15357((double)((double)(sH - this.hud.method_1813() * lH - shift - 1) * s));
        int scissorY2 = class_3532.method_15357((double)((double)(sH - shift + 1) * s));
        int selectionY1 = hoveredY - lH * hoveredParts;
        int selectionH = lH * hoveredParts + 1;
        graphics.method_44379(0, scissorY1, borderW, scissorY2);
        graphics.method_49601(0, selectionY1, borderW, selectionH, RenderUtils.opaque(ChatPatches.config.contextOutlineColor));
        graphics.method_44380();
        graphics.method_51448().method_22909();
    }

    private void renderMenuButtons(class_332 graphics, int mX, int mY, float delta) {
        this.grid.buttons().forEach(w -> w.method_25394(graphics, mX, mY, delta));
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        class_4264 tabbed;
        if (this.noOp) {
            return false;
        }
        class_364 focused = this.screen.method_25399();
        if (keyCode == 258 && focused instanceof class_4264 && this.grid.contains(tabbed = (class_4264)focused)) {
            this.updateButtons(Optional.of(tabbed));
            return true;
        }
        return this.grid.contains(focused) && focused.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double mX, double mY, int button) {
        if (!this.noOp && button == 0) {
            Optional<class_4264> opt = this.getHoveredButton(mX, mY);
            return opt.isPresent() && opt.get().method_25402(mX, mY, button);
        }
        return false;
    }

    public void method_16014(double mX, double mY) {
        Optional<class_4264> opt;
        if (!this.noOp && (opt = this.getHoveredButton(mX, mY)).orElse(null) != this.screen.method_25399()) {
            this.updateButtons(opt);
        }
    }

    public boolean method_25405(double mX, double mY) {
        return !this.noOp && mX >= (double)this.grid.widget.method_46426() && mX <= (double)(this.grid.widget.method_46426() + this.grid.widget.method_25368()) && mY >= (double)this.grid.widget.method_46427() && mY <= (double)(this.grid.widget.method_46427() + this.grid.widget.method_25364());
    }

    public void close(Consumer<class_4264> remove) {
        if (this.noOp) {
            return;
        }
        this.noOp = true;
        this.grid.buttons().forEach(remove);
        this.grid.clear();
        this.screen.method_25395((class_364)((ChatScreenAccess)this.screen).chatpatches$getChatField());
    }

    public boolean isFunctional() {
        return !this.noOp;
    }

    public boolean method_25370() {
        return !this.noOp && !this.grid.buttons().isEmpty() && this.grid.buttons().get(0).method_25370();
    }

    @Deprecated
    public void method_25365(boolean focused) {
        if (this.noOp) {
            return;
        }
        if (!this.grid.buttons().isEmpty()) {
            this.grid.buttons().get(0).method_48206(MENU_STRING_BUTTON -> MENU_STRING_BUTTON.method_25365(focused));
        }
    }

    public void updateButtons(Optional<class_4264> widgetOptional) {
        if (widgetOptional.isEmpty()) {
            this.screen.method_25395(null);
            return;
        }
        class_4264 hoveredButton = widgetOptional.get();
        this.screen.method_25395((class_364)hoveredButton);
        for (ObjectList group : this.grid.groups) {
            for (Grid.Entry itr : group) {
                class_4264 class_42642;
                if (itr.col > 0) {
                    itr.button.field_22764 = group.contains((Object)this.grid.get(hoveredButton.method_25369()));
                }
                if (itr.button != hoveredButton || group.size() <= 1 || !((class_42642 = ((Grid.Entry)group.get((int)1)).button) instanceof class_4264)) continue;
                class_4264 firstHoverButton = class_42642;
                boolean hide = itr.col > 0 && itr.row == ((Grid.Entry)group.get((int)0)).row;
                boolean show = itr.col == 0;
                firstHoverButton.method_25355((class_2561)firstHoverButton.method_25369().method_27661().method_27694(s -> s.method_30938(Boolean.valueOf(show || !hide))));
            }
        }
    }

    private Optional<class_4264> getHoveredButton(double mX, double mY) {
        return this.method_25405(mX, mY) ? this.screen.method_19355(mX, mY).map(e -> {
            class_4264 p;
            return e instanceof class_4264 ? (p = (class_4264)e) : null;
        }) : Optional.empty();
    }

    class Grid {
        private final class_7845 widget;
        private final ObjectList<Entry> entries;
        private final ObjectList<ObjectList<Entry>> groups;
        private int currentRow = -1;
        private int groupCount = 0;

        public Grid() {
            this.widget = new class_7845(ContextMenu.this.clickPos.xInt(), ContextMenu.this.clickPos.yInt());
            this.entries = new ObjectArrayList(MAX_ROWS * 2);
            this.groups = new ObjectArrayList(MAX_ROWS);
        }

        public void add(class_4264 button, int localRow, int col, Supplier<class_2561> tooltipCopyTextSupplier, class_4185.class_4241 pressAction) {
            int groupId;
            button.field_22764 = col == 0;
            boolean newGroup = button.field_22764;
            if (newGroup) {
                int n = this.groupCount;
                v1 = n;
                this.groupCount = n + 1;
            } else {
                v1 = groupId = this.groupCount - 1;
            }
            if (newGroup) {
                ++this.currentRow;
            }
            int absRow = this.currentRow + localRow;
            Entry entry = new Entry(absRow, col, groupId, button, tooltipCopyTextSupplier, pressAction);
            this.widget.method_46452((class_8021)button, absRow, col);
            this.entries.add((Object)entry);
            if (this.groups.size() > groupId) {
                ((ObjectList)this.groups.get(groupId)).add((Object)entry);
            } else {
                this.groups.add(groupId, (Object)new ObjectArrayList((ObjectList)ObjectArrayList.of((Object[])new Entry[]{entry})));
            }
        }

        public Entry get(class_2561 id) {
            for (Entry e : this.entries) {
                if (!e.button.method_25369().getString().equals(id.getString())) continue;
                return e;
            }
            return null;
        }

        @Contract(value="null -> false")
        public boolean contains(Object o) {
            class_4264 b;
            return o instanceof class_4264 && this.get((b = (class_4264)o).method_25369()) != null;
        }

        public void clear() {
            this.entries.clear();
            this.groups.clear();
            ((GridWidgetAccessor)this.widget).getChildren().clear();
        }

        public List<class_4264> buttons() {
            try {
                return ((GridWidgetAccessor)this.widget).getChildren();
            }
            catch (ClassCastException e) {
                ChatPatches.logReportMsg(e);
                return ObjectList.of();
            }
        }

        public void updateButtonPositions() {
            this.widget.method_48222();
            int mainWidth = this.entries.stream().filter(e -> e.col == 0).mapToInt(e -> e.button.method_25368()).max().orElse(32);
            this.entries.stream().filter(e -> e.col == 0).forEach(e -> e.button.method_25358(mainWidth));
            IntArrayList groupWidths = IntArrayList.toList((IntStream)this.groups.stream().mapToInt(g -> g.stream().skip(1L).mapToInt(e -> e.button.method_25368()).max().orElse(24)));
            this.groups.forEach(arg_0 -> this.lambda$updateButtonPositions$7((IntList)groupWidths, arg_0));
            int y = this.widget.method_46427();
            int h = ContextMenu.mc().method_22683().method_4502();
            if (this.widget.method_25364() + y > h) {
                this.widget.method_46419(y - (this.widget.method_25364() + y - h) - 4);
            }
            int x = this.widget.method_46426();
            int w = ContextMenu.mc().method_22683().method_4486();
            if (this.widget.method_25368() + x > w) {
                this.widget.method_46421(x - (this.widget.method_25368() + x - w) - 4);
            }
        }

        private /* synthetic */ void lambda$updateButtonPositions$7(IntList groupWidths, ObjectList g) {
            g.subList(1, g.size()).forEach(b -> b.button.method_25358(groupWidths.getInt(this.groups.indexOf((Object)g))));
        }

        record Entry(int row, int col, int groupId, class_4264 button, @NotNull Supplier<class_2561> tooltipCopyTextSupplier, @Nullable class_4185.class_4241 pressAction) {
        }
    }
}

