/*
 * Decompiled with CFR 0.152.
 */
package obro1961.chatpatches;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import obro1961.chatpatches.ChatLog;
import obro1961.chatpatches.config.Config;
import obro1961.chatpatches.util.TextUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatPatches
implements ClientModInitializer {
    public static final String MOD_ID = "chatpatches";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Chat Patches");
    public static Config config = Config.initialize();

    public static class_2960 id(String path) {
        return class_2960.method_43902((String)MOD_ID, (String)path);
    }

    public void onInitializeClient() {
        ClientPlayConnectionEvents.DISCONNECT.register((network, client) -> ChatLog.serialize());
        ScreenEvents.AFTER_INIT.register((client, screen, sW, sH) -> ChatLog.saveIfPaused(screen));
        ClientTickEvents.END_WORLD_TICK.register(world -> ChatLog.tickSaveCounter());
        ClientPlayConnectionEvents.JOIN.register((network, packetSender, client) -> {
            ChatLog.load(false);
            config.sendBoundaryLine();
            ChatLog.hideRecentMessages();
        });
        LOGGER.info("[ChatPatches()] Finished setup!");
    }

    public static String getBracedCaller(boolean skipExtraFrame) {
        String lambda;
        StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        StackWalker.StackFrame caller = walker.walk(frames -> (StackWalker.StackFrame)frames.skip(skipExtraFrame ? 2L : 1L).findFirst().orElseThrow());
        String clazz = caller.getDeclaringClass().getSimpleName();
        String method = caller.getMethodName();
        String string = lambda = method.startsWith("lambda$") ? String.format("(->%s)", method.substring(method.lastIndexOf("$") + 1)) : "";
        if (clazz.isEmpty()) {
            Class<?> callingClass = caller.getDeclaringClass();
            clazz = callingClass.isAnonymousClass() ? "<anonymous>" : (callingClass.isHidden() ? "<hidden>" : "<unnamed>");
        }
        if (method.startsWith("lambda$static$")) {
            method = "<static_init>";
        } else if (!lambda.isEmpty()) {
            method = method.substring(7, method.lastIndexOf("$"));
        }
        return String.format("[%s.%s%s]", clazz, method, lambda);
    }

    public static void logReportMsg(@NotNull Throwable error) {
        String message = ChatPatches.getBracedCaller(true) + " /!\\ Please report this error on GitHub or Discord with the full log file attached! /!\\";
        LOGGER.error(message, error);
    }

    public static void logDuration(long start, long threshold) {
        double duration = (double)(System.currentTimeMillis() - start) / 1000.0;
        double max = (double)threshold / 1000.0;
        String caller = ChatPatches.getBracedCaller(true);
        if (duration >= max) {
            LOGGER.warn("{} Took {} seconds, but should've taken less than {}s. Consider reporting this to the GitHub or Discord", new Object[]{caller, duration, max});
        } else {
            LOGGER.info("{} Took {} seconds", (Object)caller, (Object)duration);
        }
    }

    public static CompletableFuture<Void> executeIoTask(Runnable task) {
        ExecutorService IO_POOL = class_156.method_27958();
        return CompletableFuture.runAsync(task, IO_POOL).exceptionallyAsync(e -> {
            ChatPatches.logReportMsg(e);
            return null;
        }, (Executor)IO_POOL);
    }

    private static void pushToast(boolean error, Object header, Object description) {
        int MAX_LEN = 60;
        class_5250 head = TextUtils.truncate((class_2561)TextUtils.asText(header), 60);
        class_5250 desc = TextUtils.truncate((class_2561)TextUtils.asText(description), 60);
        if (!head.equals((Object)TextUtils.asText(header))) {
            head.method_10852((class_2561)class_5244.field_39678.method_27661().method_27692(class_124.field_1080));
        }
        if (!desc.equals((Object)TextUtils.asText(description))) {
            desc.method_10852((class_2561)class_5244.field_39678.method_27661().method_27692(class_124.field_1080));
        }
        class_370.method_27024((class_374)class_310.method_1551().method_1566(), (class_370.class_371)(error ? class_370.class_371.field_21809 : class_370.class_371.field_36445), (class_2561)head, (class_2561)desc);
    }

    public static void pushErrorToast(Object header, Object description) {
        ChatPatches.pushToast(true, header, description);
    }

    public static void pushInfoToast(Object header, Object description) {
        ChatPatches.pushToast(false, header, description);
    }

    public static DynamicOps<JsonElement> regJsonOps() {
        return ChatPatches.regBack(JsonOps.INSTANCE);
    }

    public static <T> DynamicOps<T> regBack(DynamicOps<T> ops) {
        return ops;
    }
}

