/*
 * Decompiled with CFR 0.152.
 */
package obro1961.chatpatches.config;

import dev.isxander.yacl3.api.Binding;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionFlag;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.ColorControllerBuilder;
import dev.isxander.yacl3.api.controller.ControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.gui.YACLScreen;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_338;
import net.minecraft.class_437;
import net.minecraft.class_4844;
import net.minecraft.class_5250;
import obro1961.chatpatches.ChatLog;
import obro1961.chatpatches.ChatPatches;
import obro1961.chatpatches.config.Config;
import obro1961.chatpatches.util.RenderUtils;
import obro1961.chatpatches.util.TextUtils;

public class YaclConfig
extends Config {
    public static final String LANG_PREFIX = "text.chatpatches.";
    public static final String DESCRIPTION_KEY = "desc.";
    public static final String DESCRIPTION_PREFIX = "text.chatpatches.desc.";
    public static final String CATEGORY_PREFIX = "text.chatpatches.category.";
    public static final String CATEGORY_DESC_PREFIX = "text.chatpatches.category.desc.";
    public static final String HELP_PREFIX = "text.chatpatches.help.";
    public static final String SEARCH_PREFIX = "text.chatpatches.search.";
    private static final Matcher STRING_DATE_FORMAT_OPTION = Pattern.compile(".*(?:Str|Date|Format)$").matcher("");

    @Override
    public class_437 getConfigScreen(class_437 parent) {
        ObjectArrayList timeOpts = new ObjectArrayList();
        ObjectArrayList hoverOpts = new ObjectArrayList();
        ObjectArrayList counterOpts = new ObjectArrayList();
        ObjectArrayList compactOpts = new ObjectArrayList();
        ObjectArrayList boundaryOpts = new ObjectArrayList();
        ObjectArrayList chatlogOpts = new ObjectArrayList();
        ObjectArrayList chatlogActions = new ObjectArrayList();
        ObjectArrayList chatOpts = new ObjectArrayList();
        ObjectArrayList nameOpts = new ObjectArrayList();
        ObjectArrayList contextMenuOpts = new ObjectArrayList();
        ObjectArrayList searchOpts = new ObjectArrayList();
        ObjectArrayList helpOpts = new ObjectArrayList();
        ChatPatches.config.getOptions().forEach(arg_0 -> this.lambda$getConfigScreen$2((ObjectList)timeOpts, (ObjectList)hoverOpts, (ObjectList)counterOpts, (ObjectList)compactOpts, (ObjectList)boundaryOpts, (ObjectList)chatlogOpts, (ObjectList)nameOpts, (ObjectList)contextMenuOpts, (ObjectList)searchOpts, (ObjectList)helpOpts, (ObjectList)chatOpts, arg_0));
        ObjectList actionKeys = ObjectList.of((Object[])new String[]{"chatlogClear", "chatlogClearHistory", "chatlogClearMessages", "chatlogLoad", "chatlogSave", "chatlogBackup", "chatlogOpenFolder"});
        for (String key : actionKeys) {
            Object[] args = new Object[]{key.equals("chatlogClearMessages") ? ChatLog.messageCount() : (key.equals("chatlogClearHistory") ? ChatLog.historyCount() : -1)};
            chatlogActions.add((Object)YaclConfig.action(key, args));
        }
        YetAnotherConfigLib.Builder builder = YetAnotherConfigLib.createBuilder().title((class_2561)class_2561.method_43471((String)"text.chatpatches.title")).category(YaclConfig.tabCat("message", ObjectList.of(), YaclConfig.subGroup("time", timeOpts, null), YaclConfig.subGroup("hover", hoverOpts, null), YaclConfig.subGroup("counter", counterOpts, null), YaclConfig.subGroup("compact", compactOpts, class_2583.field_24360.method_10958(TextUtils.openUrl("https://modrinth.com/mod/compact-chat"))))).category(YaclConfig.tabCat("boundary", boundaryOpts, new OptionGroup[0])).category(YaclConfig.tabCat("chatlog", chatlogOpts, new OptionGroup[]{YaclConfig.subGroup("chatlog.actions", chatlogActions, null)})).category(YaclConfig.tabCat("chat", chatOpts, new OptionGroup[]{YaclConfig.subGroup("name", nameOpts, null), YaclConfig.subGroup("context", contextMenuOpts, null), YaclConfig.subGroup("search", searchOpts, null)})).category(YaclConfig.tabCat("help", ObjectList.of((Object[])new Option[]{YaclConfig.action("help.reloadConfig", -1), (Option)helpOpts.get(0), YaclConfig.label(class_2561.method_43471((String)"text.chatpatches.help.dateFormat"), "https://docs.oracle.com/javase/7/docs/api/java/text/SimpleDateFormat.html"), YaclConfig.label(class_2561.method_43471((String)"text.chatpatches.help.formatCodes"), "https://minecraft.wiki/w/Formatting_codes"), YaclConfig.label(class_2561.method_43471((String)"text.chatpatches.help.faq"), "https://github.com/mrbuilder1961/ChatPatches#faq"), YaclConfig.label(class_2561.method_43471((String)"text.chatpatches.help.regex"), "https://docs.oracle.com/javase/7/docs/api/java/util/regex/Pattern.html"), YaclConfig.label(class_2561.method_43471((String)"text.chatpatches.help.regexTester"), "https://regex101.com/")}), new OptionGroup[0])).save(Config::serialize);
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            builder.category(YaclConfig.tabCat("debug", ObjectList.of((Object)ButtonOption.createBuilder().name(class_2561.method_30163((String)"Print and Copy option table")).action((screen, option) -> {
                StringBuilder str = new StringBuilder();
                ChatPatches.config.getOptions().forEach(arg_0 -> YaclConfig.lambda$getConfigScreen$3(str, arg_0));
                YaclConfig.mc().field_1774.method_1455(str.toString());
                ChatPatches.LOGGER.warn("[YaclConfig.exportGithubTables] {}", (Object)str);
            }).build(), (Object)ButtonOption.createBuilder().name(class_2561.method_30163((String)"Convert id arrays to strings")).action((screen, option) -> Arrays.stream(FabricLoader.getInstance().getGameDir().resolve("logs").toFile().listFiles(f -> f.getName().endsWith(".json"))).sorted(Comparator.comparingLong(File::lastModified)).skip(1L).findFirst().ifPresentOrElse(f -> {
                Pattern regex = Pattern.compile("\"id\"\\s*:\\s*\\[\\s*(-?\\d+)\\s*,\\s*(-?\\d+)\\s*,\\s*(-?\\d+)\\s*,\\s*(-?\\d+)\\s*]");
                try {
                    int n = 0;
                    String content = Files.readString(f.toPath());
                    Matcher m = regex.matcher(content);
                    while (m.find()) {
                        ++n;
                        int[] bits = Stream.of(m.group(1), m.group(2), m.group(3), m.group(4)).mapToInt(Integer::parseInt).toArray();
                        content = content.replace(m.group(), "\"id\":\"" + String.valueOf(class_4844.method_26276((int[])bits)) + "\"");
                    }
                    Files.writeString(f.toPath(), (CharSequence)content, new OpenOption[0]);
                    ChatPatches.LOGGER.info("[YaclConfig.revertIdArrays] Reverted {} id arrays in '{}'", (Object)n, (Object)f.getAbsolutePath());
                }
                catch (IOException e) {
                    ChatPatches.LOGGER.warn("[YaclConfig.revertIdArrays] An error occurred reading '{}'.. good luck with this guy:", (Object)f.getAbsolutePath(), (Object)e);
                }
            }, () -> ChatPatches.LOGGER.warn("[YaclConfig.revertIdArrays] No log files found"))).build()), new OptionGroup[0]));
        }
        return builder.build().generateScreen(parent);
    }

    private static <T> ControllerBuilder<T> getController(Option<T> opt, String key) {
        Object builder = STRING_DATE_FORMAT_OPTION.reset(key).matches() ? StringControllerBuilder.create(opt) : (key.contains("Color") ? ColorControllerBuilder.create(opt) : (ChatPatches.config.getOption(key).get() instanceof Integer ? ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create(opt).range((Number)YaclConfig.getMinOrMax(key, true), (Number)YaclConfig.getMinOrMax(key, false))).step((Number)YaclConfig.getInterval(key)) : BooleanControllerBuilder.create(opt).coloured(true)));
        return builder;
    }

    private static BiConsumer<YACLScreen, ButtonOption> getAction(String key) {
        return (screen, option) -> {
            if (key.contains("Clear")) {
                if (key.endsWith("History")) {
                    ChatLog.clearHistory();
                }
                if (key.endsWith("Messages")) {
                    ChatLog.clearMessages();
                }
            } else {
                switch (key) {
                    case "chatlogLoad": {
                        ChatLog.load(true);
                        break;
                    }
                    case "chatlogSave": {
                        ChatLog.serialize();
                        break;
                    }
                    case "chatlogBackup": {
                        ChatLog.backup();
                        break;
                    }
                    case "chatlogOpenFolder": {
                        class_156.method_668().method_672(ChatLog.PATH.getParent().toFile());
                        break;
                    }
                    case "help.reloadConfig": {
                        YaclConfig.deserialize();
                    }
                }
            }
        };
    }

    private static <T> Binding<T> getBinding(Config.Setting<?> option) {
        Config.Setting<?> o = option;
        if (o.key.contains("Date")) {
            return Binding.generic(o.def, o::get, inc -> {
                try {
                    new SimpleDateFormat(inc.toString());
                    o.set(inc);
                }
                catch (IllegalArgumentException e) {
                    ChatPatches.LOGGER.error("[YaclConfig.getBinding] Invalid date format '{}' provided for '{}'", inc, (Object)o.key);
                }
            });
        }
        if (o.key.contains("Format")) {
            return Binding.generic(o.def, o::get, inc -> {
                if (inc.toString().contains("$")) {
                    o.set(inc);
                }
            });
        }
        return Binding.generic(o.def, o::get, o::set);
    }

    private static int getMinOrMax(String key, boolean min) {
        if (min) {
            return switch (key) {
                case "compactDistance", "chatHeight", "chatWidth", "chatShift", "chatlogSaveInterval" -> 0;
                case "chatMaxMessages" -> 1;
                default -> {
                    ChatPatches.logReportMsg(new IllegalArgumentException("No minimum value specified for option '" + key + "'"));
                    yield 0;
                }
            };
        }
        return switch (key) {
            case "chatMaxMessages" -> Short.MAX_VALUE;
            case "chatWidth" -> YaclConfig.mc().method_22683().method_4486();
            case "chatHeight" -> YaclConfig.mc().method_22683().method_4502();
            case "chatlogSaveInterval" -> 180;
            case "compactDistance" -> {
                class_338 var5_6 = YaclConfig.mc().field_1705.method_1743();
                if (var5_6 instanceof class_338) {
                    class_338 chatHud = var5_6;
                    yield chatHud.method_1813();
                }
                yield 25;
            }
            case "chatShift" -> 100;
            default -> {
                ChatPatches.logReportMsg(new IllegalArgumentException("No maximum value specified for option '" + key + "'"));
                yield 100;
            }
        };
    }

    private static int getInterval(String key) {
        return switch (key) {
            case "chatMaxMessages" -> 16;
            case "chatlogSaveInterval" -> 5;
            default -> 1;
        };
    }

    private static ConfigCategory tabCat(String key, ObjectList<Option<?>> options, OptionGroup ... groups) {
        ConfigCategory.Builder builder = ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)(CATEGORY_PREFIX + key)));
        class_5250 tooltip = class_2561.method_43471((String)(CATEGORY_DESC_PREFIX + key));
        if (!tooltip.getString().equals(CATEGORY_DESC_PREFIX + key)) {
            builder.tooltip(new class_2561[]{tooltip});
        }
        if (groups.length > 0) {
            builder.groups(List.of(groups));
        }
        if (!options.isEmpty()) {
            builder.options(options);
        }
        return builder.build();
    }

    private static OptionGroup subGroup(String key, ObjectList<Option<?>> options, class_2583 descStyle) {
        class_5250 desc = class_2561.method_43471((String)(CATEGORY_DESC_PREFIX + key));
        return OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)(CATEGORY_PREFIX + key))).description(desc.getString().equals(CATEGORY_DESC_PREFIX + key) ? OptionDescription.EMPTY : OptionDescription.of((class_2561[])new class_2561[]{desc.method_27696(descStyle != null ? descStyle : class_2583.field_24360)})).options(options).build();
    }

    private static OptionDescription desc(Config.Setting<?> opt) {
        OptionDescription.Builder builder = OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)(DESCRIPTION_PREFIX + opt.key))});
        String image = "textures/preview/" + opt.key.replaceAll("([A-Z])", "_$1").toLowerCase(Locale.ROOT) + ".webp";
        class_2960 id = ChatPatches.id(image);
        try {
            if (YaclConfig.mc().method_1478().method_14486(id).isPresent()) {
                builder.webpImage(id);
            }
        }
        catch (Throwable e) {
            ChatPatches.LOGGER.error("[YaclConfig.desc] An error occurred while trying to use '{}:{}' :", new Object[]{"chatpatches", image, e});
        }
        return builder.build();
    }

    private static Option<class_2561> label(class_5250 labelText, String urlTooltip) {
        return LabelOption.create((class_2561)labelText.method_27694(style -> style.method_10958(TextUtils.openUrl(urlTooltip))));
    }

    private static ButtonOption action(String key, Object ... args) {
        Object o = new Object();
        return ButtonOption.createBuilder().name((class_2561)class_2561.method_43469((String)(LANG_PREFIX + key), (Object[])(args[0].equals(-1) ? new Object[]{} : args))).description(YaclConfig.desc(new Config.Setting<Object>(o, o, key))).action(YaclConfig.getAction(key)).build();
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ void lambda$getConfigScreen$3(StringBuilder str, Config.Setting opt) {
        k = opt.key;
        d = opt.def;
        search = class_1074.method_4663((String)("text.chatpatches.search." + k));
        prefix = search != false ? "text.chatpatches.search." : "text.chatpatches.";
        v0 = new Object[4];
        v0[0] = class_1074.method_4662((String)(prefix + k), (Object[])new Object[0]);
        if (!(d instanceof Integer)) ** GOTO lbl-1000
        i = (Integer)d;
        if (k.contains("Color")) {
            v1 = "`0x%06X`".formatted(new Object[]{i});
            patt10191$temp = TextUtils.COLOR_TO_FORMATTING.get(i.intValue());
            if (patt10191$temp instanceof class_124) {
                f = (class_124)patt10191$temp;
                v2 = " (" + f.method_537().toLowerCase(Locale.ROOT) + ")";
            } else {
                v2 = "";
            }
            v3 = v1 + (String)v2;
        } else lbl-1000:
        // 2 sources

        {
            v3 = opt.getType().equals(String.class) != false ? "`\"" + String.valueOf(d) + "\"`" : "`" + String.valueOf(d) + "`";
        }
        v0[1] = v3;
        v0[2] = class_1074.method_4662((String)(prefix + "desc." + k), (Object[])new Object[0]).replace("\n", "");
        v0[3] = prefix + k;
        str.append("\n| %s | %s | %s | `%s` |".formatted(v0));
    }

    private /* synthetic */ void lambda$getConfigScreen$2(ObjectList timeOpts, ObjectList hoverOpts, ObjectList counterOpts, ObjectList compactOpts, ObjectList boundaryOpts, ObjectList chatlogOpts, ObjectList nameOpts, ObjectList contextMenuOpts, ObjectList searchOpts, ObjectList helpOpts, ObjectList chatOpts, Config.Setting opt) {
        OptionFlag[] optionFlagArray;
        String key = opt.key;
        String cat = key.split("[A-Z]")[0];
        if (class_1074.method_4663((String)(SEARCH_PREFIX + key))) {
            cat = "_";
        } else if (key.equals("logMessageStructures")) {
            cat = "help";
        } else if (!class_1074.method_4663((String)(CATEGORY_PREFIX + cat))) {
            cat = "chat";
        }
        if (key.endsWith("Color")) {
            opt = new Config.Setting<Color>(new Color((Integer)opt.val), new Color((Integer)opt.def), key){

                @Override
                public Color get() {
                    return new Color((Integer)YaclConfig.this.getOption(this.key).get());
                }

                @Override
                public void set(Object value) {
                    super.set(RenderUtils.smartOpaque(((Color)value).getRGB()));
                }
            };
        }
        Option.Builder builder = Option.createBuilder().name((class_2561)class_2561.method_43471((String)(LANG_PREFIX + key))).description(YaclConfig.desc(opt)).controller(me -> YaclConfig.getController(me, key)).binding(YaclConfig.getBinding(opt));
        if (cat.equals("counter") || cat.equals("compact")) {
            OptionFlag[] optionFlagArray2 = new OptionFlag[1];
            optionFlagArray = optionFlagArray2;
            optionFlagArray2[0] = client -> client.field_1705.method_1743().method_1817();
        } else {
            optionFlagArray = new OptionFlag[]{};
        }
        Option yaclOpt = builder.flag(optionFlagArray).build();
        switch (cat) {
            case "_": {
                break;
            }
            case "time": {
                timeOpts.add((Object)yaclOpt);
                break;
            }
            case "hover": {
                hoverOpts.add((Object)yaclOpt);
                break;
            }
            case "counter": {
                counterOpts.add((Object)yaclOpt);
                break;
            }
            case "compact": {
                compactOpts.add((Object)yaclOpt);
                break;
            }
            case "boundary": {
                boundaryOpts.add((Object)yaclOpt);
                break;
            }
            case "chatlog": {
                chatlogOpts.add((Object)yaclOpt);
                break;
            }
            case "name": {
                nameOpts.add((Object)yaclOpt);
                break;
            }
            case "context": {
                contextMenuOpts.add((Object)yaclOpt);
                break;
            }
            case "search": {
                searchOpts.add((Object)yaclOpt);
                break;
            }
            case "help": {
                helpOpts.add((Object)yaclOpt);
                break;
            }
            default: {
                chatOpts.add((Object)yaclOpt);
            }
        }
    }
}

