/*
 * Decompiled with CFR 0.152.
 */
package lillouarts.magicvibedecorations;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import lillouarts.magicvibedecorations.init.MagicVibeDecorationsModBlocks;
import lillouarts.magicvibedecorations.init.MagicVibeDecorationsModItems;
import lillouarts.magicvibedecorations.init.MagicVibeDecorationsModTabs;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="magic_vibe_decorations")
public class MagicVibeDecorationsMod {
    public static final Logger LOGGER = LogManager.getLogger(MagicVibeDecorationsMod.class);
    public static final String MODID = "magic_vibe_decorations";
    private static final Queue<AbstractMap.SimpleEntry<Runnable, Integer>> WORK_QUEUE = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();
    private static final String PROTOCOL_VERSION = "1";

    public MagicVibeDecorationsMod() {
        BusGroup bus = FMLJavaModLoadingContext.get().getModBusGroup();
        FMLJavaModLoadingContext.get().getModBusGroup();
        MagicVibeDecorationsModBlocks.REGISTRY.register(bus);
        MagicVibeDecorationsModItems.register(bus);
        MagicVibeDecorationsModTabs.REGISTRY.register(bus);
        TickEvent.ServerTickEvent.Post.BUS.addListener(this::onServerTick);
        LOGGER.info("Mod {} successfully initialized!", (Object)MODID);
    }

    public static void queueServerWork(int ticksDelay, Runnable action) {
        WORK_QUEUE.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, ticksDelay));
    }

    private void onServerTick(TickEvent.ServerTickEvent.Post event) {
        if (WORK_QUEUE.isEmpty()) {
            return;
        }
        ArrayList<AbstractMap.SimpleEntry> due = new ArrayList<AbstractMap.SimpleEntry>();
        for (AbstractMap.SimpleEntry simpleEntry : WORK_QUEUE) {
            simpleEntry.setValue((Integer)simpleEntry.getValue() - 1);
            if ((Integer)simpleEntry.getValue() > 0) continue;
            due.add(simpleEntry);
        }
        for (AbstractMap.SimpleEntry simpleEntry : due) {
            ((Runnable)simpleEntry.getKey()).run();
        }
        WORK_QUEUE.removeAll(due);
    }
}

