/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.mixins;

import dev.tr7zw.notenoughanimations.NEAnimationsLoader;
import dev.tr7zw.notenoughanimations.access.ExtendedLivingRenderState;
import dev.tr7zw.notenoughanimations.access.PlayerData;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerModel.class})
public abstract class PlayerEntityModelMixin
extends HumanoidModel<AvatarRenderState> {
    @Unique
    private static final String SETUP_ANIM_METHOD = "setupAnim";

    public PlayerEntityModelMixin() {
        super(null);
    }

    @Inject(method={"setupAnim(Lnet/minecraft/client/renderer/entity/state/AvatarRenderState;)V"}, at={@At(value="HEAD")})
    public void setupAnimHEAD(AvatarRenderState state, CallbackInfo info) {
        LivingEntity livingEntity;
        if (state == null || !(state instanceof ExtendedLivingRenderState)) {
            return;
        }
        float limbSwing = state.walkAnimationPos;
        PlayerModel model = (PlayerModel)this;
        AbstractClientPlayer player = null;
        if (((ExtendedLivingRenderState)state).getEntity() != null && (livingEntity = ((ExtendedLivingRenderState)state).getEntity()) instanceof AbstractClientPlayer) {
            AbstractClientPlayer p;
            player = p = (AbstractClientPlayer)livingEntity;
        }
        if (player == null) {
            return;
        }
        NEAnimationsLoader.INSTANCE.playerTransformer.preUpdate(player, model, limbSwing, info);
    }

    @Inject(method={"setupAnim(Lnet/minecraft/client/renderer/entity/state/AvatarRenderState;)V"}, at={@At(value="RETURN")})
    public void setupAnim(AvatarRenderState state, CallbackInfo info) {
        LivingEntity livingEntity;
        float limbSwing = state.walkAnimationPos;
        PlayerModel model = (PlayerModel)this;
        AbstractClientPlayer player = null;
        if (((ExtendedLivingRenderState)state).getEntity() != null && (livingEntity = ((ExtendedLivingRenderState)state).getEntity()) instanceof AbstractClientPlayer) {
            AbstractClientPlayer p;
            player = p = (AbstractClientPlayer)livingEntity;
        }
        if (player == null) {
            return;
        }
        NEAnimationsLoader.INSTANCE.playerTransformer.updateModel(player, model, limbSwing, info);
    }

    @Inject(method={"setupAnim(Lnet/minecraft/client/renderer/entity/state/AvatarRenderState;)V"}, at={@At(value="RETURN")})
    public void setupAnimEnd(AvatarRenderState state, CallbackInfo info) {
        LivingEntity livingEntity;
        AbstractClientPlayer player = null;
        if (((ExtendedLivingRenderState)state).getEntity() != null && (livingEntity = ((ExtendedLivingRenderState)state).getEntity()) instanceof AbstractClientPlayer) {
            AbstractClientPlayer p;
            player = p = (AbstractClientPlayer)livingEntity;
        }
        if (player == null) {
            return;
        }
        PlayerData data = (PlayerData)player;
        if (data.getPoseOverwrite() != null) {
            player.setPose(data.getPoseOverwrite());
            data.setPoseOverwrite(null);
        }
    }
}

