/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.mixins;

import dev.tr7zw.notenoughanimations.access.PlayerData;
import dev.tr7zw.notenoughanimations.renderlayer.SwordRenderLayer;
import dev.tr7zw.notenoughanimations.util.RenderStateHolder;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.world.entity.Avatar;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AvatarRenderer.class})
public abstract class PlayerRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, HumanoidRenderState, HumanoidModel<HumanoidRenderState>> {
    public PlayerRendererMixin(EntityRendererProvider.Context context, HumanoidModel<HumanoidRenderState> model, float shadowRadius) {
        super(context, model, shadowRadius);
    }

    @Inject(method={"<init>*"}, at={@At(value="RETURN")})
    public void onCreate(CallbackInfo info) {
        this.addLayer(new SwordRenderLayer((RenderLayerParent<HumanoidRenderState, HumanoidModel<HumanoidRenderState>>)this));
    }

    @Inject(method={"extractRenderState(Lnet/minecraft/world/entity/Avatar;Lnet/minecraft/client/renderer/entity/state/AvatarRenderState;F)V"}, at={@At(value="HEAD")})
    private void includeData(Avatar abstractClientPlayer, AvatarRenderState playerRenderState, float f, CallbackInfo ci) {
        if (abstractClientPlayer instanceof PlayerData) {
            PlayerData playerData = (PlayerData)abstractClientPlayer;
            RenderStateHolder.RenderStateData data = playerData.getData(RenderStateHolder.INSTANCE, RenderStateHolder.RenderStateData::new);
            data.renderState = playerRenderState;
        }
    }
}

