/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.mixins;

import dev.tr7zw.notenoughanimations.access.PlayerData;
import dev.tr7zw.notenoughanimations.renderlayer.SwordRenderLayer;
import dev.tr7zw.notenoughanimations.util.RenderStateHolder;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, HumanoidRenderState, HumanoidModel<HumanoidRenderState>> {
    public PlayerRendererMixin(EntityRendererProvider.Context context, HumanoidModel model, float shadowRadius) {
        super(context, (EntityModel)model, shadowRadius);
    }

    @Inject(method={"<init>*"}, at={@At(value="RETURN")})
    public void onCreate(CallbackInfo info) {
        this.addLayer(new SwordRenderLayer((RenderLayerParent<HumanoidRenderState, HumanoidModel<HumanoidRenderState>>)this));
    }

    @Inject(method={"extractRenderState(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;F)V"}, at={@At(value="HEAD")})
    private void includeData(AbstractClientPlayer abstractClientPlayer, PlayerRenderState playerRenderState, float f, CallbackInfo ci) {
        if (abstractClientPlayer instanceof PlayerData) {
            PlayerData playerData = (PlayerData)abstractClientPlayer;
            RenderStateHolder.RenderStateData data = playerData.getData(RenderStateHolder.INSTANCE, RenderStateHolder.RenderStateData::new);
            data.renderState = playerRenderState;
        }
    }
}

