/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.util;

import dev.tr7zw.notenoughanimations.versionless.NEABaseMod;
import dev.tr7zw.notenoughanimations.versionless.animations.BodyPart;
import dev.tr7zw.transition.mc.GeneralUtil;
import dev.tr7zw.transition.mc.ItemUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_2960;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;

public class AnimationUtil {
    static class_1792 crossbow = ItemUtil.getItem((class_2960)GeneralUtil.getResourceLocation((String)"minecraft", (String)"crossbow"));

    public static Set<class_1792> parseItemList(Collection<String> list) {
        HashSet<class_1792> items = new HashSet<class_1792>();
        class_1792 invalid = ItemUtil.getItem((class_2960)GeneralUtil.getResourceLocation((String)"minecraft", (String)"air"));
        for (String itemId : list) {
            try {
                String[] parts = itemId.split(":");
                if (parts.length != 2) {
                    String string = itemId;
                    NEABaseMod.LOGGER.info("Invalid item ID format (expected namespace:path): " + string);
                    continue;
                }
                class_1792 item = ItemUtil.getItem((class_2960)GeneralUtil.getResourceLocation((String)parts[0], (String)parts[1]));
                if (invalid == item) continue;
                items.add(item);
            }
            catch (Exception ex) {
                String string = itemId;
                NEABaseMod.LOGGER.info("Unknown item to add to the bow list: " + string);
            }
        }
        return items;
    }

    public static boolean isUsingBothHands(class_572.class_573 pose) {
        return pose == class_572.class_573.field_3403 || pose == class_572.class_573.field_3405 || pose == class_572.class_573.field_3408;
    }

    public static boolean isSwingingArm(class_742 player, BodyPart arm) {
        if (!player.field_6252) {
            return false;
        }
        if (arm == BodyPart.LEFT_ARM) {
            return player.method_6068() == class_1306.field_6182 && player.field_6266 == class_1268.field_5808 || player.method_6068() == class_1306.field_6183 && player.field_6266 == class_1268.field_5810;
        }
        return player.method_6068() == class_1306.field_6183 && player.field_6266 == class_1268.field_5808 || player.method_6068() == class_1306.field_6182 && player.field_6266 == class_1268.field_5810;
    }

    public static class_572.class_573 getArmPose(class_742 abstractClientPlayerEntity, class_1268 hand) {
        class_1799 itemStack = abstractClientPlayerEntity.method_5998(hand);
        if (itemStack.method_7960()) {
            return class_572.class_573.field_3409;
        }
        if (abstractClientPlayerEntity.method_6058() == hand && abstractClientPlayerEntity.method_6014() > 0) {
            class_1839 useAction = itemStack.method_7976();
            if (useAction == class_1839.field_8949) {
                return class_572.class_573.field_3406;
            }
            if (useAction == class_1839.field_8953) {
                return class_572.class_573.field_3403;
            }
            if (useAction == class_1839.field_8951) {
                return class_572.class_573.field_3407;
            }
            if (useAction == class_1839.field_8947 && hand.equals((Object)abstractClientPlayerEntity.method_6058())) {
                return class_572.class_573.field_3405;
            }
        } else if (!abstractClientPlayerEntity.field_6252 && itemStack.method_7909().equals(crossbow) && AnimationUtil.isChargedCrossbow(itemStack)) {
            return class_572.class_573.field_3408;
        }
        return class_572.class_573.field_3410;
    }

    public static boolean isChargedCrossbow(class_1799 item) {
        return class_1764.method_7781((class_1799)item);
    }

    public static void applyArmTransforms(class_591 model, class_1306 arm, float pitch, float yaw, float roll) {
        class_630 part = arm == class_1306.field_6183 ? model.field_3401 : model.field_3390;
        part.field_3654 = pitch;
        part.field_3675 = yaw;
        if (arm == class_1306.field_6182) {
            part.field_3675 *= -1.0f;
        }
        part.field_3674 = roll;
        if (arm == class_1306.field_6182) {
            part.field_3674 *= -1.0f;
        }
    }

    public static void applyTransforms(class_591 model, BodyPart bodyPart, float pitch, float yaw, float roll) {
        boolean mirror = false;
        switch (bodyPart) {
            case LEFT_ARM: {
                mirror = true;
                class_630 part = model.field_3390;
                break;
            }
            case RIGHT_ARM: {
                class_630 part = model.field_3401;
                break;
            }
            case LEFT_LEG: {
                mirror = true;
                class_630 part = model.field_3397;
                break;
            }
            case RIGHT_LEG: {
                class_630 part = model.field_3392;
                break;
            }
            default: {
                return;
            }
        }
        part.field_3654 = pitch;
        part.field_3675 = yaw;
        if (mirror) {
            part.field_3675 *= -1.0f;
        }
        part.field_3674 = roll;
        if (mirror) {
            part.field_3674 *= -1.0f;
        }
    }

    public static void minMaxHeadRotation(class_1657 livingEntity, class_591 model) {
        float value = AnimationUtil.legacyWrapDegrees(model.field_3398.field_3675);
        float min = AnimationUtil.legacyWrapDegrees(model.field_3391.field_3675 - 1.5707964f);
        float max = AnimationUtil.legacyWrapDegrees(model.field_3391.field_3675 + 1.5707964f);
        value = Math.min(value, max);
        value = Math.max(value, min);
        AnimationUtil.setHeadYRot(model, value);
    }

    public static void setHeadYRot(class_591 model, float value) {
        model.field_3398.field_3675 = value;
        model.field_3394.field_3675 = value;
    }

    public static float interpolateRotation(float start, float end, float amount) {
        float wrappedStart = AnimationUtil.wrapDegrees(start);
        float wrappedEnd = AnimationUtil.wrapDegrees(end);
        float diff = wrappedEnd - wrappedStart;
        if (diff > (float)Math.PI) {
            wrappedEnd -= (float)Math.PI * 2;
        } else if (diff < (float)(-Math.PI)) {
            wrappedEnd += (float)Math.PI * 2;
        }
        return AnimationUtil.wrapDegrees(wrappedStart + (wrappedEnd - wrappedStart) * amount);
    }

    public static float interpolateRotation2(float start, float end, float amount) {
        float wrappedStart = AnimationUtil.wrapDegrees2(start);
        float wrappedEnd = AnimationUtil.wrapDegrees2(end);
        float diff = wrappedEnd - wrappedStart;
        if (diff > 180.0f) {
            wrappedEnd -= 360.0f;
        } else if (diff < -180.0f) {
            wrappedEnd += 360.0f;
        }
        return AnimationUtil.wrapDegrees2(wrappedStart + (wrappedEnd - wrappedStart) * amount);
    }

    public static float lerpAngle(float delta, float start, float end) {
        float wrappedStart = AnimationUtil.wrapDegrees(start);
        float wrappedEnd = AnimationUtil.wrapDegrees(end);
        float difference = wrappedEnd - wrappedStart;
        float shortestPath = (difference + (float)Math.PI) % ((float)Math.PI * 2) - (float)Math.PI;
        return AnimationUtil.wrapDegrees(wrappedStart + shortestPath * delta);
    }

    public static float wrapDegrees(float angle) {
        return (angle + (float)Math.PI) % ((float)Math.PI * 2) - (float)Math.PI;
    }

    public static float wrapDegrees2(float angle) {
        float wrapped = (angle + 180.0f) % 360.0f;
        if (wrapped < 0.0f) {
            wrapped += 360.0f;
        }
        return wrapped - 180.0f;
    }

    public static float legacyWrapDegrees(float f) {
        float g = f % 6.283185f;
        if (g >= 3.1415925f) {
            g -= 6.283185f;
        }
        if (g < -3.1415925f) {
            g += 6.283185f;
        }
        return g;
    }
}

