/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.animations.hands;

import dev.tr7zw.notenoughanimations.access.PlayerData;
import dev.tr7zw.notenoughanimations.api.BasicAnimation;
import dev.tr7zw.notenoughanimations.util.AnimationUtil;
import dev.tr7zw.notenoughanimations.versionless.NEABaseMod;
import dev.tr7zw.notenoughanimations.versionless.animations.BodyPart;
import dev.tr7zw.transition.mc.EntityUtil;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class PetAnimation
extends BasicAnimation {
    private Entity targetPet = null;
    private final BodyPart[] leftHanded = new BodyPart[]{BodyPart.LEFT_ARM};
    private final BodyPart[] rightHanded = new BodyPart[]{BodyPart.RIGHT_ARM};

    @Override
    public boolean isEnabled() {
        return NEABaseMod.config.petAnimation;
    }

    @Override
    public boolean isValid(AbstractClientPlayer entity, PlayerData data) {
        TamableAnimal pet;
        double dif;
        AABB aABB;
        if (!entity.m_6047_()) {
            return false;
        }
        double d = 1.0;
        Vec3 vec3 = entity.m_20299_(0.0f);
        Vec3 vec32 = entity.m_20252_(1.0f);
        Vec3 vec33 = vec3.m_82520_(vec32.f_82479_ * d, vec32.f_82480_ * d, vec32.f_82481_ * d);
        EntityHitResult entHit = ProjectileUtil.m_37287_((Entity)entity, (Vec3)vec3, (Vec3)vec33, (AABB)(aABB = entity.m_20191_().m_82369_(vec32.m_82490_(d)).m_82377_(1.0, 1.0, 1.0)), en -> !en.m_5833_(), (double)d);
        if (entHit != null && (entHit.m_82443_().m_6095_() == EntityType.f_20499_ || entHit.m_82443_().m_6095_() == EntityType.f_20553_) && Math.abs(dif = (pet = (TamableAnimal)entHit.m_82443_()).m_20186_() - entity.m_20186_()) < 0.6) {
            this.targetPet = pet;
            return true;
        }
        this.targetPet = null;
        return false;
    }

    @Override
    public BodyPart[] getBodyParts(AbstractClientPlayer entity, PlayerData data) {
        return entity.m_5737_() == HumanoidArm.RIGHT ? this.rightHanded : this.leftHanded;
    }

    @Override
    public int getPriority(AbstractClientPlayer entity, PlayerData data) {
        return 2100;
    }

    @Override
    public void apply(AbstractClientPlayer entity, PlayerData data, PlayerModel model, BodyPart part, float delta, float tickCounter) {
        if (Math.random() < 0.005) {
            this.targetPet.m_7822_((byte)18);
        }
        HumanoidArm arm = part == BodyPart.LEFT_ARM ? HumanoidArm.LEFT : HumanoidArm.RIGHT;
        AnimationUtil.applyArmTransforms(model, arm, -Mth.m_14179_((float)(-1.0f * (EntityUtil.getXRot((Entity)entity) - 90.0f) / 180.0f), (float)1.0f, (float)2.0f), -0.6f, 0.3f + Mth.m_14031_((float)((float)(System.currentTimeMillis() % 20000L) / 60.0f)) * 0.2f);
        this.targetPet = null;
    }
}

