/*
 * Decompiled with CFR 0.152.
 */
package net.lunarini.lunarinispread.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.lunarini.lunarinispread.api.JsonHelper;
import net.lunarini.lunarinispread.effect.EffectModifier;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EffectModifierManager {
    private static final Map<ResourceLocation, List<EffectModifier>> CACHE = new HashMap<ResourceLocation, List<EffectModifier>>();
    private static final Logger LOGGER = LogManager.getLogger();

    public static void loadModifiers(MinecraftServer server, MobEffect effect, String effectName) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"lunarinispread", (String)("effects/" + effectName + ".json"));
        LOGGER.info("\ud83d\udd27 \u6b63\u5728\u52a0\u8f7d\u6548\u679c\u4fee\u9970\u7b26: {}", (Object)effectName);
        ServerLevel level = server.overworld();
        JsonElement json = JsonHelper.loadJson(server.getResourceManager(), id);
        System.out.println(json);
        if (json == null || !json.isJsonObject()) {
            LOGGER.error("\u274c \u672a\u627e\u5230\u6216\u65e0\u6cd5\u89e3\u6790 JSON: {}", (Object)id);
            return;
        }
        JsonObject jsonObject = json.getAsJsonObject();
        JsonArray modifiersArray = jsonObject.getAsJsonArray("modifiers");
        if (modifiersArray == null || modifiersArray.isEmpty()) {
            LOGGER.warn("\ud83d\udfe1 \u4fee\u9970\u7b26\u5217\u8868\u4e3a\u7a7a: {}", (Object)id);
            return;
        }
        RegistryAccess registryAccess = level.registryAccess();
        if (registryAccess == null) {
            LOGGER.error("\u274c RegistryAccess \u4e3a null\uff01");
            return;
        }
        LOGGER.info("\u2705 \u5f00\u59cb\u6ce8\u518c {} \u4e2a\u4fee\u9970\u7b26", (Object)modifiersArray.size());
        modifiersArray.asList().stream().map(elem -> EffectModifier.CODEC.parse((DynamicOps)JsonOps.INSTANCE, elem).result().orElse(null)).filter(Objects::nonNull).forEach(modifier -> EffectModifierManager.registerModifier(effect, modifier, registryAccess));
    }

    private static void registerModifier(MobEffect effect, EffectModifier modifier, RegistryAccess registryAccess) {
        try {
            ResourceLocation attributeLoc = modifier.attribute();
            ResourceKey attributeKey = ResourceKey.create((ResourceKey)Registries.ATTRIBUTE, (ResourceLocation)attributeLoc);
            Holder.Reference attributeHolder = registryAccess.lookupOrThrow(Registries.ATTRIBUTE).getOrThrow(attributeKey);
            AttributeModifier.Operation operation = EffectModifierManager.toVanillaOp(modifier.operation());
            effect.addAttributeModifier((Holder)attributeHolder, modifier.id(), operation, level -> modifier.amount() * (1.0 + (double)level * 0.2));
            LOGGER.debug("\u6210\u529f\u6ce8\u518c\u5c5e\u6027\u52a0\u6210: {} -> {} ({})", (Object)attributeLoc, (Object)modifier.amount(), (Object)operation);
        }
        catch (Exception e) {
            LOGGER.error("\u274c \u6ce8\u518c\u5c5e\u6027\u4fee\u9970\u7b26\u5931\u8d25: effect={}, attribute={}", (Object)effect, (Object)modifier.attribute(), (Object)e);
        }
    }

    private static AttributeModifier.Operation toVanillaOp(EffectModifier.Operation op) {
        return switch (op) {
            default -> throw new MatchException(null, null);
            case EffectModifier.Operation.ADDITION -> AttributeModifier.Operation.ADD_VALUE;
            case EffectModifier.Operation.MULTIPLY_BASE -> AttributeModifier.Operation.ADD_MULTIPLIED_BASE;
            case EffectModifier.Operation.MULTIPLY_TOTAL -> AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL;
        };
    }

    private static Level getServerLevel() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return server != null ? server.overworld() : null;
    }
}

