/*
 * Decompiled with CFR 0.152.
 */
package net.lunarini.lunarinispread.event;

import com.github.ysbbbbbb.kaleidoscopecookery.block.food.FoodBiteBlock;
import java.util.List;
import net.lunarini.lunarinispread.api.EffectModifierManager;
import net.lunarini.lunarinispread.attribute.ModAttributes;
import net.lunarini.lunarinispread.effect.ModEffects;
import net.lunarini.lunarinispread.util.ModTools;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.event.entity.EntityMountEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class ModEvents {
    @SubscribeEvent
    public static void addAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.PLAYER, ModAttributes.COOKING_SKILL);
    }

    @SubscribeEvent
    public static void onEntityMount(EntityMountEvent event) {
        Entity mounting = event.getEntityMounting();
        Entity mounted = event.getEntityBeingMounted();
        boolean isDismounting = event.isDismounting();
        if (mounting instanceof Player) {
            Player player = (Player)mounting;
            if (isDismounting) {
                ModTools.digestion(player);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockDestroy(BlockEvent.BreakEvent event) {
        ModTools.destroyFoodBiteBlock(event.getState(), event.getPlayer().level(), event.getPos());
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        BlockItem blockItem;
        Block block;
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        Level level = event.getEntity().level();
        Item item = stack.getItem();
        if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).getBlock()) instanceof FoodBiteBlock) {
            long productionDate = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getLong("production_date");
            long a = (level.getGameTime() - productionDate) / 12000L;
            int freshness = 5 - (int)Math.min(a, 10L);
            List tooltip = event.getToolTip();
            String key = "tooltip.lunarinispread.freshness";
            MutableComponent message = Component.translatable((String)key, (Object[])new Object[]{freshness}).withStyle(ChatFormatting.GRAY);
            tooltip.add(message);
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        if (level.isClientSide) {
            return;
        }
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (!(block instanceof FoodBiteBlock)) {
            return;
        }
        FoodBiteBlock foodBiteBlock = (FoodBiteBlock)block;
        event.setCanceled(true);
        if (!player.isPassenger()) {
            ModTools.sendActionBarMessage((LivingEntity)player, "should_not_eat_on_ground");
            return;
        }
        List<BlockPos> connected = ModTools.connectFoodBiteBlock(level, pos, 10);
        if (connected == null || connected.isEmpty()) {
            return;
        }
        boolean anyAte = false;
        for (BlockPos p : connected) {
            Vec3 hitVec;
            BlockHitResult fakeHit;
            FoodBiteBlock otherBlock;
            InteractionResult result;
            BlockState otherState = level.getBlockState(p);
            Block block2 = otherState.getBlock();
            if (!(block2 instanceof FoodBiteBlock) || !(result = (otherBlock = (FoodBiteBlock)block2).useWithoutItem(otherState, level, p, player, fakeHit = new BlockHitResult(hitVec = new Vec3((double)p.getX() + 0.5, (double)p.getY() + 0.5, (double)p.getZ() + 0.5), event.getFace(), p, false))).consumesAction()) continue;
            anyAte = true;
        }
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        EffectModifierManager.loadModifiers(server, (MobEffect)ModEffects.BEAST_1_EFFECT.value(), "beast1");
        EffectModifierManager.loadModifiers(server, (MobEffect)ModEffects.BEAST_2_EFFECT.value(), "beast2");
        EffectModifierManager.loadModifiers(server, (MobEffect)ModEffects.FISH_1_EFFECT.value(), "fish1");
        EffectModifierManager.loadModifiers(server, (MobEffect)ModEffects.FISH_2_EFFECT.value(), "fish2");
        EffectModifierManager.loadModifiers(server, (MobEffect)ModEffects.FLOW_1_EFFECT.value(), "flow1");
        EffectModifierManager.loadModifiers(server, (MobEffect)ModEffects.FLOW_2_EFFECT.value(), "flow2");
        EffectModifierManager.loadModifiers(server, (MobEffect)ModEffects.MONSTER_1_EFFECT.value(), "monster1");
        EffectModifierManager.loadModifiers(server, (MobEffect)ModEffects.MONSTER_2_EFFECT.value(), "monster2");
        EffectModifierManager.loadModifiers(server, (MobEffect)ModEffects.SWEET_1_EFFECT.value(), "sweet1");
        EffectModifierManager.loadModifiers(server, (MobEffect)ModEffects.SWEET_2_EFFECT.value(), "sweet2");
        EffectModifierManager.loadModifiers(server, (MobEffect)ModEffects.NETHER_1_EFFECT.value(), "nether1");
        EffectModifierManager.loadModifiers(server, (MobEffect)ModEffects.NETHER_2_EFFECT.value(), "nether2");
        EffectModifierManager.loadModifiers(server, (MobEffect)ModEffects.FROST_1_EFFECT.value(), "frost1");
        EffectModifierManager.loadModifiers(server, (MobEffect)ModEffects.FROST_2_EFFECT.value(), "frost2");
        EffectModifierManager.loadModifiers(server, (MobEffect)ModEffects.ENDER_1_EFFECT.value(), "ender1");
        EffectModifierManager.loadModifiers(server, (MobEffect)ModEffects.ENDER_2_EFFECT.value(), "ender2");
    }
}

