/*
 * Decompiled with CFR 0.152.
 */
package net.lunarini.lunarinispread.item.customItem;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import java.util.Objects;
import net.lunarini.lunarinispread.api.JsonHelper;
import net.lunarini.lunarinispread.effect.EffectModifier;
import net.lunarini.lunarinispread.util.ModTags;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class Chopsticks
extends Item {
    public static final int MAX_USE_DURATION = 72000;

    public Chopsticks(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.getLevel();
        if (level.isClientSide()) {
            return InteractionResult.PASS;
        }
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"lunarinispread", (String)"effects/beast1.json");
        ResourceManager manager = level.getServer().getResourceManager();
        JsonElement json = JsonHelper.loadJson(manager, id);
        if (json != null && json.isJsonObject()) {
            System.out.println("\u2705 JSON \u52a0\u8f7d\u6210\u529f: " + String.valueOf(json));
            JsonObject jsonObject = json.getAsJsonObject();
            JsonArray modifiersArray = jsonObject.getAsJsonArray("modifiers");
            if (modifiersArray == null) {
                System.err.println("\u274c JSON \u4e2d\u6ca1\u6709\u627e\u5230 'modifiers' \u5b57\u6bb5");
                return InteractionResult.SUCCESS;
            }
            System.out.println("\ud83d\udd27 modifiers \u6570\u7ec4: " + String.valueOf(modifiersArray));
            List<EffectModifier> modifiers = modifiersArray.asList().stream().map(elem -> {
                DataResult result = EffectModifier.CODEC.parse((DynamicOps)JsonOps.INSTANCE, elem);
                if (result.error().isPresent()) {
                    System.err.println("\u274c \u89e3\u6790\u5931\u8d25: " + ((DataResult.Error)result.error().get()).message());
                }
                return result.result().orElse(null);
            }).filter(Objects::nonNull).toList();
            System.out.println("\u2705 \u89e3\u6790\u51fa " + modifiers.size() + " \u4e2a\u4fee\u9970\u7b26: " + String.valueOf(modifiers));
        } else {
            System.out.println("\u274c JSON \u52a0\u8f7d\u5931\u8d25\u6216\u4e0d\u662f\u5bf9\u8c61");
        }
        return InteractionResult.SUCCESS;
    }

    private boolean isValidBlock(BlockState blockState) {
        return blockState.is(ModTags.Blocks.SPREAD_ADDITION_BLOCKS);
    }
}

