/*
 * Decompiled with CFR 0.152.
 */
package net.lunarini.lunarinispread.mixin;

import com.github.ysbbbbbb.kaleidoscopecookery.block.food.FoodBiteBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.block.food.FoodBlock;
import net.lunarini.lunarinispread.blockEntity.FoodBiteBlockEntity;
import net.lunarini.lunarinispread.util.ModTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={FoodBiteBlock.class})
public abstract class FoodBiteBlockMixin
extends FoodBlock
implements EntityBlock {
    @Shadow
    @Final
    private IntegerProperty bites;
    @Shadow
    @Final
    private int maxBites;

    @Shadow
    public abstract int getMaxBites();

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FoodBiteBlockEntity(pos, state);
    }

    @Overwrite
    @NotNull
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        ModTools.removeAllModEffects(player);
        FoodBiteBlockEntity blockEntity = (FoodBiteBlockEntity)level.getBlockEntity(pos);
        if (level.isClientSide || blockEntity == null) {
            return InteractionResult.SUCCESS;
        }
        if (!player.isPassenger()) {
            ModTools.sendActionBarMessage((LivingEntity)player, "should_not_eat_on_ground");
            return InteractionResult.SUCCESS;
        }
        int bites = (Integer)state.getValue((Property)this.bites);
        int maxBites = this.getMaxBites();
        CompoundTag nbt = blockEntity.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess());
        CompoundTag nbt1 = nbt.getCompound("components");
        CompoundTag nbt2 = nbt1.getCompound("minecraft:custom_data");
        long productionDate = nbt2.getLong("production_date");
        int quality = nbt2.getInt("quality");
        if (bites >= maxBites) {
            return InteractionResult.SUCCESS;
        }
        Boolean result = ModTools.recordEatFood(player, blockEntity, productionDate, quality, maxBites);
        if (!result.booleanValue()) {
            ModTools.sendActionBarMessage((LivingEntity)player, "cannot_eat_anymore");
            return InteractionResult.SUCCESS;
        }
        level.setBlock(pos, (BlockState)state.setValue((Property)this.bites, (Comparable)Integer.valueOf(bites + 1)), 3);
        level.playSound((Player)null, pos, SoundEvents.GENERIC_EAT, SoundSource.PLAYERS, 0.5f, level.getRandom().nextFloat() * 0.1f + 0.9f);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            int current = serverPlayer.getFoodData().getFoodLevel();
            int newFood = Math.min(current + 5, 20);
            serverPlayer.getFoodData().setFoodLevel(newFood);
        }
        return InteractionResult.SUCCESS;
    }
}

