/*
 * Decompiled with CFR 0.152.
 */
package net.lunarini.lunarinispread.mixin;

import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.PotBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.item.BowlFoodBlockItem;
import net.lunarini.lunarinispread.attribute.ModAttributes;
import net.lunarini.lunarinispread.util.ModTools;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PotBlockEntity.class})
public class PotBlockEntityMixin {
    @Shadow
    private ItemStack result;

    @Inject(method={"takeOutWithCarrier"}, at={@At(value="RETURN")})
    private void takeOutWithCarrier(Level level, LivingEntity user, ItemStack mainHandItem, ItemStack finallyResult, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            if (!(finallyResult.getItem() instanceof BowlFoodBlockItem)) {
                return;
            }
            if (!finallyResult.isEmpty()) {
                AttributeInstance attribute = user.getAttribute(ModAttributes.COOKING_SKILL);
                if (attribute == null) {
                    return;
                }
                double cookingSkill = attribute.getValue();
                int quality = ModTools.getQuality(level, finallyResult, cookingSkill);
                long productionDate = level.getGameTime();
                CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)finallyResult, tag -> tag.putInt("quality", quality));
                CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)finallyResult, tag -> tag.putLong("production_date", productionDate));
                ModTools.applyQualityName(finallyResult, quality);
                ModTools.addPlayerSkill(user, "cooking_skill", 25.0);
            }
        }
    }
}

