/*
 * Decompiled with CFR 0.152.
 */
package net.lunarini.lunarinispread.util;

import com.github.ysbbbbbb.kaleidoscopecookery.block.food.FoodBiteBlock;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.lunarini.lunarinispread.attribute.ModAttributes;
import net.lunarini.lunarinispread.foodSynergy.FoodSynergy;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ModTools {
    public static int getQuality(Level level, ItemStack stack, double cookingSkill) {
        RandomSource random = RandomSource.create();
        double baseMean = cookingSkill * 0.19;
        double variance = 0.35;
        double rawQuality = baseMean + random.nextGaussian() * Math.sqrt(variance);
        return Mth.clamp((int)((int)Math.round(rawQuality)), (int)0, (int)5);
    }

    public static void applyQualityName(ItemStack stack, int quality) {
        String key = "quality.suffix." + quality;
        MutableComponent suffix = Component.translatable((String)key);
        Component originalName = stack.getDisplayName();
        String originalText = originalName.getString();
        if (originalText.startsWith("[") && originalText.endsWith("]")) {
            originalText = originalText.substring(1, originalText.length() - 1);
        }
        originalName = Component.literal((String)originalText);
        MutableComponent newName = Component.literal((String)"").append(originalName).append((Component)suffix);
        stack.set(DataComponents.CUSTOM_NAME, (Object)newName.copy().setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false))));
    }

    public static void addPlayerSkill(LivingEntity user, String skillName, double addExp) {
        CompoundTag persistentData = user.getPersistentData();
        if (!persistentData.contains("lunarinispread:skill", 10)) {
            persistentData.put("lunarinispread:skill", (Tag)new CompoundTag());
        }
        CompoundTag skill = persistentData.getCompound("lunarinispread:skill");
        double exp = skill.getDouble(skillName);
        AttributeInstance attribute = user.getAttribute(ModAttributes.COOKING_SKILL);
        if (attribute == null) {
            return;
        }
        double skillLevel = attribute.getValue();
        double expResult = exp + addExp;
        if (expResult < (skillLevel += 1.0) * 100.0) {
            skill.putDouble(skillName, expResult);
        } else {
            skill.putDouble(skillName, expResult - skillLevel * 100.0);
            attribute.setBaseValue(skillLevel);
            if (user instanceof Player) {
                Player player = (Player)user;
                ModTools.sendSystemMessage(player, "cooking_level_up");
                user.level().playSound(null, user.getX(), user.getY(), user.getZ(), SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 0.5f, 0.8f + 0.4f * user.getRandom().nextFloat());
            }
        }
    }

    public static Boolean recordEatFood(Player player, BlockEntity blockEntity, long productionDate, int quality, int maxBites) {
        CompoundTag food;
        int bitesToAdd;
        CompoundTag stomach;
        int bites;
        int bitesResult;
        BlockState state = blockEntity.getBlockState();
        CompoundTag persistentData = player.getPersistentData();
        if (!persistentData.contains("lunarinispread:stomach", 10)) {
            persistentData.put("lunarinispread:stomach", (Tag)new CompoundTag());
        }
        if ((bitesResult = (bites = (stomach = persistentData.getCompound("lunarinispread:stomach")).getInt("bites")) + (bitesToAdd = 60 / maxBites)) > 360) {
            return false;
        }
        stomach.putInt("bites", bitesResult);
        ListTag eatenList = stomach.getList("lunarinispread:eaten_food_list", 8);
        String foodId = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).toString();
        boolean alreadyEaten = false;
        for (int i = 0; i < eatenList.size(); ++i) {
            if (!eatenList.getString(i).equals(foodId)) continue;
            alreadyEaten = true;
            break;
        }
        if (!alreadyEaten) {
            eatenList.add((Object)StringTag.valueOf((String)foodId));
        }
        stomach.put("lunarinispread:eaten_food_list", (Tag)eatenList);
        if (stomach.contains(foodId, 10)) {
            food = stomach.getCompound(foodId);
            int previousBites = food.getInt("bitesAdded");
            food.putInt("bitesAdded", previousBites + bitesToAdd);
        } else {
            food = new CompoundTag();
            food.putLong("production_date", productionDate);
            food.putInt("quality", quality);
            food.putInt("bitesAdded", bitesToAdd);
        }
        food.putInt("quality", Math.min(food.getInt("quality"), quality));
        food.putLong("production_date", Math.min(food.getLong("production_date"), productionDate));
        stomach.put(foodId, (Tag)food);
        return true;
    }

    public static void digestion(Player player) {
        double quality = 0.0;
        double foodCount = 0.0;
        double freshness = 0.0;
        double eachFreshness = 0.0;
        int score = 0;
        CompoundTag persistentData = player.getPersistentData();
        CompoundTag stomach = persistentData.getCompound("lunarinispread:stomach");
        ListTag eatenList = stomach.getList("lunarinispread:eaten_food_list", 8);
        if (eatenList.isEmpty()) {
            return;
        }
        HashSet<TagKey<Item>> eatenTags = new HashSet<TagKey<Item>>();
        HashMap<TagKey<Item>, Integer> tagCount = new HashMap<TagKey<Item>, Integer>();
        for (int i = 0; i < eatenList.size(); ++i) {
            Item item;
            CompoundTag foodData;
            int bitesAdded;
            String foodId = eatenList.getString(i);
            if (!stomach.contains(foodId, 10) || (bitesAdded = (foodData = stomach.getCompound(foodId)).getInt("bitesAdded")) < 60) continue;
            long a = (player.level().getGameTime() - foodData.getLong("production_date")) / 12000L;
            a = Math.min(a, 10L);
            System.out.println("a:" + a);
            eachFreshness = 5L - a;
            freshness += (double)((int)eachFreshness);
            quality += (double)foodData.getInt("quality");
            foodCount += 1.0;
            ResourceLocation itemId = ResourceLocation.tryParse((String)foodId);
            if (itemId == null || (item = (Item)BuiltInRegistries.ITEM.get(itemId)) == Items.AIR) continue;
            ItemStack stack = new ItemStack((ItemLike)item);
            for (Map.Entry<TagKey<Item>, Map<Integer, MobEffectInstance>> entry : FoodSynergy.SYNERGIES.entrySet()) {
                TagKey<Item> tag = entry.getKey();
                if (!stack.is(tag)) continue;
                eatenTags.add(tag);
                tagCount.merge(tag, 1, Integer::sum);
            }
        }
        score = (int)(quality = (double)Math.round(quality / foodCount)) + (int)(freshness = (double)Math.round(freshness / foodCount)) - 4;
        if (score < 0) {
            if (foodCount < 1.0) {
                ModTools.sendSystemMessage(player, "not_full");
                return;
            }
            ModTools.sendSystemMessage(player, "these_dishes_taste_awful");
            player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 60, 0, false, false));
            persistentData.remove("lunarinispread:stomach");
            return;
        }
        block7: for (Map.Entry<TagKey<Item>, Map<Integer, MobEffectInstance>> entry : FoodSynergy.SYNERGIES.entrySet()) {
            TagKey<Item> tag = entry.getKey();
            Map<Integer, MobEffectInstance> effects = entry.getValue();
            int count = tagCount.getOrDefault(tag, 0);
            for (Map.Entry<Integer, MobEffectInstance> effectEntry : effects.entrySet()) {
                int threshold = effectEntry.getKey();
                if (count < threshold) continue;
                MobEffectInstance effect = effectEntry.getValue();
                player.addEffect(new MobEffectInstance(effect.getEffect(), effect.getDuration(), effect.getAmplifier() + score, false, false));
                continue block7;
            }
        }
        switch (score) {
            case 4: {
                ModTools.sendSystemMessage(player, "these_dishes_are_ok");
                break;
            }
            case 5: {
                ModTools.sendSystemMessage(player, "these_dishes_are_good");
                break;
            }
            case 6: {
                ModTools.sendSystemMessage(player, "these_dishes_are_great");
            }
        }
        persistentData.remove("lunarinispread:stomach");
    }

    public static void sendActionBarMessage(LivingEntity user, String type) {
        if (user instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)user;
            String key = "tip.lunarinispread." + type;
            MutableComponent message = Component.translatable((String)key);
            serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)message));
        }
    }

    public static void sendSystemMessage(Player player, String type) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            String key = "tip.lunarinispread." + type;
            MutableComponent message = Component.translatable((String)key);
            player.sendSystemMessage((Component)message);
        }
    }

    public static void destroyFoodBiteBlock(BlockState state, Level level, BlockPos pos) {
        Block block = state.getBlock();
        if (!(block instanceof FoodBiteBlock)) {
            return;
        }
        FoodBiteBlock foodBiteBlock = (FoodBiteBlock)block;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity == null || level.isClientSide) {
            return;
        }
        CompoundTag persistentData = blockEntity.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess());
        CompoundTag components = persistentData.getCompound("components");
        CompoundTag customData = components.getCompound("minecraft:custom_data");
        int bites = (Integer)state.getValue((Property)foodBiteBlock.getBites());
        if (bites != 0) {
            return;
        }
        int quality = customData.getInt("quality");
        long productionDate = customData.getLong("production_date");
        System.out.println("quality: " + quality);
        System.out.println("production_date: " + productionDate);
        ItemStack itemStack = new ItemStack((ItemLike)state.getBlock().asItem());
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemStack, tag -> tag.putInt("quality", quality));
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemStack, tag -> tag.putLong("production_date", productionDate));
        ModTools.applyQualityName(itemStack, quality);
        ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, itemStack);
        itemEntity.setDeltaMovement(new Vec3(0.0, 0.1, 0.0));
        level.addFreshEntity((Entity)itemEntity);
        level.destroyBlock(pos, false);
    }

    public static List<BlockPos> connectFoodBiteBlock(Level level, BlockPos pos, int maxBlocks) {
        if (!level.isLoaded(pos)) {
            return null;
        }
        BlockState startState = level.getBlockState(pos);
        Block targetBlock = startState.getBlock();
        if (targetBlock == Blocks.AIR) {
            return null;
        }
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        ArrayList<BlockPos> connected = new ArrayList<BlockPos>();
        queue.add(pos);
        visited.add(pos);
        while (!queue.isEmpty() && connected.size() < maxBlocks) {
            BlockPos current = (BlockPos)queue.poll();
            connected.add(current);
            for (Direction direction : Direction.values()) {
                BlockState state;
                BlockPos neighbor = current.relative(direction);
                if (!level.isLoaded(neighbor) || visited.contains(neighbor) || !((state = level.getBlockState(neighbor)).getBlock() instanceof FoodBiteBlock)) continue;
                visited.add(neighbor);
                queue.add(neighbor);
            }
        }
        ArrayList<BlockPos> connected_1 = new ArrayList<BlockPos>();
        for (BlockPos p : connected) {
            BlockState state = level.getBlockState(p);
            FoodBiteBlock foodBiteBlock = (FoodBiteBlock)state.getBlock();
            int maxBites = foodBiteBlock.getMaxBites();
            int bites = (Integer)state.getValue((Property)foodBiteBlock.getBites());
            if (bites >= maxBites) continue;
            connected_1.add(p);
        }
        ArrayList<BlockPos> randomThree = new ArrayList<BlockPos>();
        if (!connected_1.isEmpty()) {
            Collections.shuffle(connected_1, new Random());
            int count = Math.min(3, connected_1.size());
            for (int i = 0; i < count; ++i) {
                randomThree.add((BlockPos)connected_1.get(i));
            }
        }
        return randomThree;
    }

    public static void removeAllModEffects(Player player) {
        if (player.level().isClientSide()) {
            return;
        }
        TagKey Tag2 = TagKey.create((ResourceKey)Registries.MOB_EFFECT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"lunarinispread", (String)"spread_effects"));
        Collection activeEffects = player.getActiveEffects();
        System.out.println("activeEffects: " + String.valueOf(activeEffects));
        ArrayList<Holder> effectsToRemove = new ArrayList<Holder>();
        for (MobEffectInstance instance : player.getActiveEffects()) {
            Holder effect = instance.getEffect();
            if (!effect.is(Tag2)) continue;
            effectsToRemove.add(effect);
        }
        for (Holder effect : effectsToRemove) {
            player.removeEffect(effect);
        }
    }
}

