/*
 * Decompiled with CFR 0.152.
 */
package yiseyo.sculpture.core.client;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yiseyo.sculpture.core.manager.camera.EntityDetectionManager;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="sculpture", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public final class CameraHudRenderer {
    private static final int COLOR_ALLOWED = 0x55FF55;
    private static final int COLOR_FORBIDDEN = 0xFF5555;
    private static final int COLOR_BACKGROUND = Integer.MIN_VALUE;
    private static final int COLOR_TEXT_SHADOW = 0x222222;
    private static final int HUD_OFFSET_X = 10;
    private static final int HUD_OFFSET_Y = -30;
    private static final int PADDING = 4;
    private static final int BORDER_WIDTH = 1;

    private CameraHudRenderer() {
    }

    @SubscribeEvent
    public static void onRenderGuiOverlay(RenderGuiOverlayEvent.Post event) {
        block10: {
            try {
                LivingEntity targetEntity;
                if (!EntityDetectionManager.shouldShowHud()) {
                    return;
                }
                Minecraft mc = Minecraft.m_91087_();
                LocalPlayer player = mc.f_91074_;
                if (player == null || mc.f_91073_ == null) {
                    return;
                }
                try {
                    targetEntity = EntityDetectionManager.getTargetedEntity((Player)player);
                }
                catch (Exception detectionError) {
                    System.err.println("Error during entity detection: " + detectionError.getMessage());
                    return;
                }
                if (targetEntity == null) break block10;
                try {
                    CameraHudRenderer.renderEntityInfo(event.getGuiGraphics(), targetEntity, event.getWindow().m_85445_(), event.getWindow().m_85446_());
                }
                catch (Exception renderError) {
                    System.err.println("Error rendering entity info for " + targetEntity.m_7755_().getString() + ": " + renderError.getMessage());
                    try {
                        CameraHudRenderer.renderErrorInfo(event.getGuiGraphics(), "\u6e32\u67d3\u9519\u8bef", event.getWindow().m_85445_(), event.getWindow().m_85446_());
                    }
                    catch (Exception fallbackError) {
                        System.err.println("Failed to render error info: " + fallbackError.getMessage());
                    }
                }
            }
            catch (Exception generalError) {
                System.err.println("Unexpected error in HUD rendering: " + generalError.getMessage());
                generalError.printStackTrace();
            }
        }
    }

    private static void renderEntityInfo(GuiGraphics guiGraphics, LivingEntity entity, int screenWidth, int screenHeight) {
        try {
            boolean isAllowed;
            String permissionStatus;
            String entityName;
            Minecraft mc = Minecraft.m_91087_();
            Font font = mc.f_91062_;
            if (font == null) {
                System.err.println("Font is null, cannot render entity info");
                return;
            }
            try {
                entityName = entity != null && entity.m_5446_() != null ? entity.m_5446_().getString() : "\u672a\u77e5\u5b9e\u4f53";
                permissionStatus = EntityDetectionManager.getEntityPermissionStatus(entity);
                if (permissionStatus == null) {
                    permissionStatus = "\u72b6\u6001\u672a\u77e5";
                }
                isAllowed = permissionStatus.equals("\u5141\u8bb8\u62cd\u6444");
            }
            catch (Exception infoError) {
                System.err.println("Error getting entity info: " + infoError.getMessage());
                entityName = "\u4fe1\u606f\u83b7\u53d6\u5931\u8d25";
                permissionStatus = "\u9519\u8bef";
                isAllowed = false;
            }
            int centerX = screenWidth / 2;
            int centerY = screenHeight / 2;
            int hudX = centerX + 10;
            int hudY = centerY + -30;
            int nameWidth = font.m_92895_(entityName);
            int statusWidth = font.m_92895_(permissionStatus);
            int maxWidth = Math.max(nameWidth, statusWidth);
            int totalWidth = maxWidth + 8;
            Objects.requireNonNull(font);
            int totalHeight = 9 * 2 + 12;
            hudX = Math.max(0, Math.min(hudX, screenWidth - totalWidth));
            hudY = Math.max(0, Math.min(hudY, screenHeight - totalHeight));
            try {
                guiGraphics.m_280509_(hudX, hudY, hudX + totalWidth, hudY + totalHeight, Integer.MIN_VALUE);
            }
            catch (Exception bgError) {
                System.err.println("Error rendering background: " + bgError.getMessage());
            }
            int borderColor = isAllowed ? 0x55FF55 : 0xFF5555;
            try {
                CameraHudRenderer.renderBorder(guiGraphics, hudX, hudY, totalWidth, totalHeight, borderColor);
            }
            catch (Exception borderError) {
                System.err.println("Error rendering border: " + borderError.getMessage());
            }
            int textX = hudX + 4;
            int textY = hudY + 4;
            try {
                guiGraphics.m_280056_(font, entityName, textX + 1, textY + 1, 0x222222, false);
                guiGraphics.m_280056_(font, entityName, textX, textY, 0xFFFFFF, false);
            }
            catch (Exception nameError) {
                System.err.println("Error rendering entity name: " + nameError.getMessage());
            }
            Objects.requireNonNull(font);
            textY += 9 + 4;
            try {
                guiGraphics.m_280056_(font, permissionStatus, textX + 1, textY + 1, 0x222222, false);
                guiGraphics.m_280056_(font, permissionStatus, textX, textY, borderColor, false);
            }
            catch (Exception statusError) {
                System.err.println("Error rendering permission status: " + statusError.getMessage());
            }
        }
        catch (Exception e) {
            System.err.println("Error in renderEntityInfo: " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    private static void renderBorder(GuiGraphics guiGraphics, int x, int y, int width, int height, int color) {
        guiGraphics.m_280509_(x, y, x + width, y + 1, color);
        guiGraphics.m_280509_(x, y + height - 1, x + width, y + height, color);
        guiGraphics.m_280509_(x, y, x + 1, y + height, color);
        guiGraphics.m_280509_(x + width - 1, y, x + width, y + height, color);
    }

    private static void renderErrorInfo(GuiGraphics guiGraphics, String errorMessage, int screenWidth, int screenHeight) {
        try {
            Minecraft mc = Minecraft.m_91087_();
            Font font = mc.f_91062_;
            if (font == null) {
                return;
            }
            int centerX = screenWidth / 2;
            int centerY = screenHeight / 2;
            int hudX = centerX + 10;
            int hudY = centerY + -30;
            int messageWidth = font.m_92895_(errorMessage);
            int totalWidth = messageWidth + 8;
            Objects.requireNonNull(font);
            int totalHeight = 9 + 8;
            hudX = Math.max(0, Math.min(hudX, screenWidth - totalWidth));
            hudY = Math.max(0, Math.min(hudY, screenHeight - totalHeight));
            guiGraphics.m_280509_(hudX, hudY, hudX + totalWidth, hudY + totalHeight, Integer.MIN_VALUE);
            CameraHudRenderer.renderBorder(guiGraphics, hudX, hudY, totalWidth, totalHeight, 0xFF5555);
            int textX = hudX + 4;
            int textY = hudY + 4;
            guiGraphics.m_280056_(font, errorMessage, textX + 1, textY + 1, 0x222222, false);
            guiGraphics.m_280056_(font, errorMessage, textX, textY, 0xFF5555, false);
        }
        catch (Exception e) {
            System.err.println("Failed to render error info: " + e.getMessage());
        }
    }

    private static void renderCrosshairEnhancement(GuiGraphics guiGraphics, int screenWidth, int screenHeight, boolean isTargetingEntity, boolean isAllowed) {
        if (!isTargetingEntity) {
            return;
        }
        int centerX = screenWidth / 2;
        int centerY = screenHeight / 2;
        int color = isAllowed ? 0x55FF55 : 0xFF5555;
        int radius = 8;
        for (int i = 0; i < 4; ++i) {
            double angle = (double)i * Math.PI / 2.0;
            int dotX = centerX + (int)(Math.cos(angle) * (double)radius);
            int dotY = centerY + (int)(Math.sin(angle) * (double)radius);
            guiGraphics.m_280509_(dotX - 1, dotY - 1, dotX + 1, dotY + 1, color);
        }
    }
}

