/*
 * Decompiled with CFR 0.152.
 */
package yiseyo.sculpture.core.controller.capture;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import yiseyo.sculpture.core.controller.capture.IEntityInfoAccessor;
import yiseyo.sculpture.core.controller.capture.accessor.EnderDragonPartInfoAccessor;
import yiseyo.sculpture.core.controller.capture.accessor.EntityInfoAccessor;
import yiseyo.sculpture.core.controller.capture.accessor.LivingEntityInfoAccessor;
import yiseyo.sculpture.core.controller.capture.accessor.PartEntityInfoAccessor;
import yiseyo.sculpture.core.controller.capture.accessor.ShulkerInfoAccessor;
import yiseyo.sculpture.core.controller.capture.accessor.SquidInfoAccessor;

public class EntityInfoController {
    private static final List<IEntityInfoAccessor> ACCESSORS = List.of(new EntityInfoAccessor(), new PartEntityInfoAccessor(), new EnderDragonPartInfoAccessor(), new LivingEntityInfoAccessor(), new ShulkerInfoAccessor(), new SquidInfoAccessor());

    public static CompoundTag serializeEntity(Entity entity) {
        CompoundTag tag = new CompoundTag();
        for (IEntityInfoAccessor accessor : ACCESSORS) {
            if (!accessor.isApplicableTo(entity)) continue;
            accessor.writeEntityInfo(entity, tag);
        }
        return tag;
    }

    public static void deserializeEntity(Entity entity, CompoundTag tag) {
        for (IEntityInfoAccessor accessor : ACCESSORS) {
            if (!accessor.isApplicableTo(entity)) continue;
            accessor.readEntityInfo(entity, tag);
        }
    }
}

