/*
 * Decompiled with CFR 0.152.
 */
package yiseyo.sculpture.core.controller.capture.accessor;

import java.lang.reflect.Field;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import yiseyo.sculpture.Sculpture;
import yiseyo.sculpture.core.controller.capture.IEntityInfoAccessor;

public class LivingEntityInfoAccessor
implements IEntityInfoAccessor {
    private static final Field RUN_F;
    private static final Field ORUN_F;
    private static final Field WALK_POS_F;
    private static final Field WALK_SPD_F;
    private static final Field WALK_SPDOLD_F;

    @Override
    public void writeEntityInfo(Entity entity, CompoundTag tag) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        try {
            tag.m_128350_("RunPos", RUN_F.getFloat(entity));
            tag.m_128350_("RunPosO", ORUN_F.getFloat(entity));
            WalkAnimationState was = livingEntity.f_267362_;
            tag.m_128350_("WalkPos", WALK_POS_F.getFloat(was));
            tag.m_128350_("WalkSpd", WALK_SPD_F.getFloat(was));
            tag.m_128350_("WalkSpdO", WALK_SPDOLD_F.getFloat(was));
        }
        catch (IllegalAccessException e) {
            Sculpture.LOGGER.warn(e.getMessage());
        }
    }

    @Override
    public void readEntityInfo(Entity entity, CompoundTag tag) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        float prevBody = livingEntity.f_20883_;
        float prevHead = livingEntity.f_20885_;
        livingEntity.f_20883_ = prevBody;
        livingEntity.f_20885_ = prevHead;
        try {
            if (tag.m_128425_("RunPos", 5)) {
                RUN_F.setFloat(entity, tag.m_128457_("RunPos"));
            }
            if (tag.m_128425_("RunPosO", 5)) {
                ORUN_F.setFloat(entity, tag.m_128457_("RunPosO"));
            }
            WalkAnimationState was = livingEntity.f_267362_;
            if (tag.m_128425_("WalkPos", 5)) {
                WALK_POS_F.setFloat(was, tag.m_128457_("WalkPos"));
            }
            if (tag.m_128425_("WalkSpd", 5)) {
                WALK_SPD_F.setFloat(was, tag.m_128457_("WalkSpd"));
            }
            if (tag.m_128425_("WalkSpdO", 5)) {
                WALK_SPDOLD_F.setFloat(was, tag.m_128457_("WalkSpdO"));
            }
        }
        catch (IllegalAccessException e) {
            Sculpture.LOGGER.warn(e.getMessage());
        }
    }

    @Override
    public boolean isApplicableTo(Entity entity) {
        return entity instanceof LivingEntity;
    }

    static {
        try {
            RUN_F = LivingEntity.class.getDeclaredField("run");
            ORUN_F = LivingEntity.class.getDeclaredField("oRun");
            RUN_F.setAccessible(true);
            ORUN_F.setAccessible(true);
            WALK_POS_F = ObfuscationReflectionHelper.findField(WalkAnimationState.class, (String)"f_267358_");
            WALK_SPD_F = ObfuscationReflectionHelper.findField(WalkAnimationState.class, (String)"f_267371_");
            WALK_SPDOLD_F = ObfuscationReflectionHelper.findField(WalkAnimationState.class, (String)"f_267406_");
            WALK_POS_F.setAccessible(true);
            WALK_SPD_F.setAccessible(true);
            WALK_SPDOLD_F.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("\u53cd\u5c04\u5b9e\u4f53\u7c7b\u5931\u8d25", e);
        }
    }
}

