/*
 * Decompiled with CFR 0.152.
 */
package yiseyo.sculpture.core.controller.capture.accessor;

import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.entity.PartEntity;
import yiseyo.sculpture.core.controller.capture.IEntityInfoAccessor;

public class PartEntityInfoAccessor
implements IEntityInfoAccessor {
    private static final String KEY_PARENT_UUID = "ParentUUID";
    private static final String KEY_PARENT_TYPE = "ParentType";
    private static final String KEY_REL_X = "RelX";
    private static final String KEY_REL_Y = "RelY";
    private static final String KEY_REL_Z = "RelZ";

    @Override
    public void writeEntityInfo(Entity entity, CompoundTag tag) {
        if (!(entity instanceof PartEntity)) {
            return;
        }
        PartEntity part = (PartEntity)entity;
        Entity parent = part.getParent();
        if (parent != null) {
            tag.m_128362_(KEY_PARENT_UUID, parent.m_20148_());
            ResourceLocation key = BuiltInRegistries.f_256780_.m_7981_((Object)parent.m_6095_());
            if (key != null) {
                tag.m_128359_(KEY_PARENT_TYPE, key.toString());
            }
            tag.m_128347_(KEY_REL_X, entity.m_20185_() - parent.m_20185_());
            tag.m_128347_(KEY_REL_Y, entity.m_20186_() - parent.m_20186_());
            tag.m_128347_(KEY_REL_Z, entity.m_20189_() - parent.m_20189_());
        }
    }

    @Override
    public void readEntityInfo(Entity entity, CompoundTag tag) {
        if (!(entity instanceof PartEntity)) {
            return;
        }
        PartEntity part = (PartEntity)entity;
        Entity parent = part.getParent();
        if (parent == null) {
            return;
        }
        boolean uuidOk = true;
        if (tag.m_128425_(KEY_PARENT_UUID, 11)) {
            UUID expect = tag.m_128342_(KEY_PARENT_UUID);
            uuidOk = parent.m_20148_().equals(expect);
        }
        if (!uuidOk) {
            return;
        }
        if (tag.m_128425_(KEY_REL_X, 6) && tag.m_128425_(KEY_REL_Y, 6) && tag.m_128425_(KEY_REL_Z, 6)) {
            double x = parent.m_20185_() + tag.m_128459_(KEY_REL_X);
            double y = parent.m_20186_() + tag.m_128459_(KEY_REL_Y);
            double z = parent.m_20189_() + tag.m_128459_(KEY_REL_Z);
            entity.m_6034_(x, y, z);
        }
    }

    @Override
    public boolean isApplicableTo(Entity entity) {
        return entity instanceof PartEntity;
    }
}

