/*
 * Decompiled with CFR 0.152.
 */
package yiseyo.sculpture.core.controller.capture.accessor;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import yiseyo.sculpture.core.controller.capture.IEntityInfoAccessor;

public class ShulkerInfoAccessor
implements IEntityInfoAccessor {
    private static final Field PEEK_AMOUNT_F;
    private static final Field PREV_PEEK_AMOUNT_F;
    private static final Method SET_RAW_PEEK;
    private static final Method GET_RAW_PEEK;
    private static final EntityDataAccessor<Byte> DATA_PEEK_ID;

    @Override
    public void writeEntityInfo(Entity entity, CompoundTag tag) {
        int rawPeek;
        if (!(entity instanceof Shulker)) {
            return;
        }
        Shulker shulker = (Shulker)entity;
        try {
            rawPeek = (Integer)GET_RAW_PEEK.invoke((Object)shulker, new Object[0]);
        }
        catch (Throwable ignored) {
            rawPeek = ((Byte)shulker.m_20088_().m_135370_(DATA_PEEK_ID)).byteValue();
        }
        tag.m_128344_("ShulkerPeekRaw", (byte)rawPeek);
        tag.m_128350_("ShulkerPeek", (float)rawPeek / 100.0f);
    }

    @Override
    public void readEntityInfo(Entity entity, CompoundTag tag) {
        if (!(entity instanceof Shulker)) {
            return;
        }
        Shulker shulker = (Shulker)entity;
        if (!tag.m_128441_("ShulkerPeekRaw")) {
            return;
        }
        int rawPeek = tag.m_128445_("ShulkerPeekRaw") & 0xFF;
        boolean applied = false;
        try {
            SET_RAW_PEEK.invoke((Object)shulker, rawPeek);
            applied = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!applied) {
            shulker.m_20088_().m_135381_(DATA_PEEK_ID, (Object)((byte)rawPeek));
        }
        float opened = (float)rawPeek / 100.0f;
        try {
            PEEK_AMOUNT_F.setFloat(shulker, opened);
            PREV_PEEK_AMOUNT_F.setFloat(shulker, opened);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("\u8bfb\u53d6\u6f5c\u5f71\u8d1d\u7279\u6709\u5b57\u6bb5\u5931\u8d25", e);
        }
        shulker.m_6210_();
    }

    @Override
    public boolean isApplicableTo(Entity entity) {
        return entity instanceof Shulker;
    }

    static {
        DATA_PEEK_ID = (EntityDataAccessor)ObfuscationReflectionHelper.getPrivateValue(Shulker.class, null, (String)"DATA_PEEK_ID");
        try {
            PEEK_AMOUNT_F = ObfuscationReflectionHelper.findField(Shulker.class, (String)"currentPeekAmount");
            PREV_PEEK_AMOUNT_F = ObfuscationReflectionHelper.findField(Shulker.class, (String)"currentPeekAmountO");
            SET_RAW_PEEK = ObfuscationReflectionHelper.findMethod(Shulker.class, (String)"setRawPeekAmount", (Class[])new Class[]{Integer.TYPE});
            GET_RAW_PEEK = ObfuscationReflectionHelper.findMethod(Shulker.class, (String)"getRawPeekAmount", (Class[])new Class[0]);
            SET_RAW_PEEK.setAccessible(true);
            GET_RAW_PEEK.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("\u53cd\u5c04\u6f5c\u5f71\u8d1d\u7c7b\u5931\u8d25", e);
        }
    }
}

