/*
 * Decompiled with CFR 0.152.
 */
package yiseyo.sculpture.core.controller.capture.accessor;

import java.lang.reflect.Field;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Squid;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import yiseyo.sculpture.core.controller.capture.IEntityInfoAccessor;

public class SquidInfoAccessor
implements IEntityInfoAccessor {
    private static final Field X_BODY_ROT_F;
    private static final Field PREV_X_BODY_ROT_F;
    private static final Field Z_BODY_ROT_F;
    private static final Field PREV_Z_BODY_ROT_F;
    private static final Field TENTACLE_MOV_F;
    private static final Field PREV_TENTACLE_MOV_F;
    private static final Field TENTACLE_ANGLE_F;
    private static final Field PREV_TENTACLE_ANGLE_F;

    @Override
    public void writeEntityInfo(Entity entity, CompoundTag tag) {
        if (!(entity instanceof Squid)) {
            return;
        }
        Squid squid = (Squid)entity;
        try {
            tag.m_128350_("BodyRotX", X_BODY_ROT_F.getFloat(squid));
            tag.m_128350_("BodyRotZ", Z_BODY_ROT_F.getFloat(squid));
            tag.m_128350_("TentacleMove", TENTACLE_MOV_F.getFloat(squid));
            tag.m_128350_("TentacleAngle", TENTACLE_ANGLE_F.getFloat(squid));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void readEntityInfo(Entity entity, CompoundTag tag) {
        if (!(entity instanceof Squid)) {
            return;
        }
        Squid squid = (Squid)entity;
        if (!tag.m_128441_("BodyRotX")) {
            return;
        }
        float xRot = tag.m_128457_("BodyRotX");
        float zRot = tag.m_128457_("BodyRotZ");
        float tentacleMove = tag.m_128457_("TentacleMove");
        float tentacleAng = tag.m_128457_("TentacleAngle");
        try {
            X_BODY_ROT_F.setFloat(squid, xRot);
            PREV_X_BODY_ROT_F.setFloat(squid, xRot);
            Z_BODY_ROT_F.setFloat(squid, zRot);
            PREV_Z_BODY_ROT_F.setFloat(squid, zRot);
            TENTACLE_MOV_F.setFloat(squid, tentacleMove);
            PREV_TENTACLE_MOV_F.setFloat(squid, tentacleMove);
            TENTACLE_ANGLE_F.setFloat(squid, tentacleAng);
            PREV_TENTACLE_ANGLE_F.setFloat(squid, tentacleAng);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isApplicableTo(Entity entity) {
        return entity instanceof Squid;
    }

    static {
        try {
            X_BODY_ROT_F = ObfuscationReflectionHelper.findField(Squid.class, (String)"xBodyRot");
            PREV_X_BODY_ROT_F = ObfuscationReflectionHelper.findField(Squid.class, (String)"xBodyRotO");
            Z_BODY_ROT_F = ObfuscationReflectionHelper.findField(Squid.class, (String)"zBodyRot");
            PREV_Z_BODY_ROT_F = ObfuscationReflectionHelper.findField(Squid.class, (String)"zBodyRotO");
            TENTACLE_MOV_F = ObfuscationReflectionHelper.findField(Squid.class, (String)"tentacleMovement");
            PREV_TENTACLE_MOV_F = ObfuscationReflectionHelper.findField(Squid.class, (String)"oldTentacleMovement");
            TENTACLE_ANGLE_F = ObfuscationReflectionHelper.findField(Squid.class, (String)"tentacleAngle");
            PREV_TENTACLE_ANGLE_F = ObfuscationReflectionHelper.findField(Squid.class, (String)"oldTentacleAngle");
        }
        catch (Exception e) {
            throw new RuntimeException("\u53cd\u5c04\u9c7f\u9c7c\u7c7b\u5931\u8d25", e);
        }
    }
}

