/*
 * Decompiled with CFR 0.152.
 */
package yiseyo.sculpture.core.controller.render.accessor;

import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import yiseyo.sculpture.core.controller.render.LayerHeaderAccessor;
import yiseyo.sculpture.utils.RenderTextureUtil;

public final class VanillaLayerAccessor
implements LayerHeaderAccessor {
    private static final byte FLAG_CUTOUT = 0;
    private static final byte FLAG_TRANSLUCENT = 1;
    private static final byte FLAG_EMISSIVE = 2;
    private static final byte FLAG_ITEM_GLINT = 3;
    private static final byte FLAG_ARMOR_GLINT = 4;
    private static final byte FLAG_SWIRL = 5;
    private static final byte FLAG_SOLID = 6;

    @Override
    public boolean supports(RenderType rt) {
        String n = rt.toString().toLowerCase();
        return n.contains("cutout") || n.contains("translucent") || n.contains("emissive") || n.contains("solid") || n.contains("eyes") || n.contains("glint") || n.contains("swirl");
    }

    @Override
    public void encode(RenderType rt, FriendlyByteBuf buf) {
        buf.m_130085_(RenderTextureUtil.textureOf(rt));
        buf.writeByte((int)VanillaLayerAccessor.layerFlag(rt));
    }

    @Override
    public RenderType decode(FriendlyByteBuf buf) {
        ResourceLocation tex = buf.m_130281_();
        byte flag = buf.readByte();
        return switch (flag) {
            case 1 -> RenderType.m_110473_((ResourceLocation)tex);
            case 2 -> RenderType.m_234338_((ResourceLocation)tex);
            case 3 -> RenderType.m_110496_();
            case 4 -> RenderType.m_110484_();
            case 5 -> RenderType.m_110436_((ResourceLocation)tex, (float)0.0f, (float)0.0f);
            case 6 -> RenderType.m_110446_((ResourceLocation)tex);
            default -> RenderType.m_110458_((ResourceLocation)tex);
        };
    }

    private static byte layerFlag(RenderType rt) {
        String name = rt.toString().toLowerCase();
        if (name.contains("solid") && !name.contains("cutout")) {
            return 6;
        }
        if (name.contains("translucent")) {
            return 1;
        }
        if (name.contains("emissive") || name.contains("eyes")) {
            return 2;
        }
        if (name.contains("armor_glint")) {
            return 4;
        }
        if (name.contains("glint")) {
            return 3;
        }
        if (name.contains("swirl")) {
            return 5;
        }
        return 0;
    }
}

