/*
 * Decompiled with CFR 0.152.
 */
package yiseyo.sculpture.core.manager.camera;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import yiseyo.sculpture.core.manager.camera.CameraConfigHelper;
import yiseyo.sculpture.core.net.ModNet;
import yiseyo.sculpture.core.net.packet.C2SEntityDetection;
import yiseyo.sculpture.core.world.CameraItem;

public final class EntityDetectionManager {
    private static Entity lastDetectedEntity = null;
    private static long lastDetectionTime = 0L;
    private static final long CACHE_DURATION_MS = 50L;
    private static final Map<Integer, EntityInfo> networkEntityCache = new ConcurrentHashMap<Integer, EntityInfo>();

    private EntityDetectionManager() {
    }

    public static LivingEntity getTargetedEntity(Player player) {
        Entity detected;
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastDetectionTime < 50L && lastDetectedEntity != null && lastDetectedEntity.m_6084_() && !lastDetectedEntity.m_213877_()) {
            return lastDetectedEntity instanceof LivingEntity ? (LivingEntity)lastDetectedEntity : null;
        }
        lastDetectedEntity = detected = EntityDetectionManager.performRaycast(player);
        lastDetectionTime = currentTime;
        return detected instanceof LivingEntity ? (LivingEntity)detected : null;
    }

    private static Entity performRaycast(Player player) {
        Entity hitEntity;
        double distance;
        Predicate<Entity> entityFilter;
        AABB searchBox;
        Vec3 viewVector;
        Vec3 endPosition;
        double detectionRange = CameraConfigHelper.getDetectionRange();
        Vec3 eyePosition = player.m_146892_();
        EntityHitResult hitResult = ProjectileUtil.m_37287_((Entity)player, (Vec3)eyePosition, (Vec3)(endPosition = eyePosition.m_82549_(viewVector = player.m_20252_(1.0f).m_82490_(detectionRange))), (AABB)(searchBox = player.m_20191_().m_82369_(viewVector).m_82400_(1.0)), entityFilter = entity -> {
            if (entity.m_5833_() || !entity.m_6087_()) {
                return false;
            }
            if (entity == player) {
                return false;
            }
            if (!(entity instanceof LivingEntity)) {
                return false;
            }
            return CameraConfigHelper.isEntityAllowed(entity);
        }, (double)(detectionRange * detectionRange));
        if (hitResult != null && (distance = (double)player.m_20270_(hitEntity = hitResult.m_82443_())) <= detectionRange) {
            return hitEntity;
        }
        return null;
    }

    public static boolean canCaptureEntity(Player player, LivingEntity target) {
        if (!CameraConfigHelper.isEntityAllowed((Entity)target)) {
            return false;
        }
        double distance = player.m_20270_((Entity)target);
        return distance <= CameraConfigHelper.getDetectionRange();
    }

    public static String getEntityPermissionStatus(LivingEntity entity) {
        if (entity == null) {
            return "\u65e0\u76ee\u6807";
        }
        EntityInfo cachedInfo = networkEntityCache.get(entity.m_19879_());
        if (cachedInfo != null && !cachedInfo.isExpired()) {
            return cachedInfo.permissionStatus;
        }
        EntityDetectionManager.requestEntityInfo(entity);
        if (CameraConfigHelper.isEntityAllowed((Entity)entity)) {
            return "\u5141\u8bb8\u62cd\u6444";
        }
        return "\u7981\u6b62\u62cd\u6444";
    }

    private static void requestEntityInfo(LivingEntity entity) {
        if (entity == null) {
            return;
        }
        try {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.m_91403_() == null) {
                System.err.println("Cannot send entity detection request: not connected to server");
                return;
            }
            C2SEntityDetection packet = new C2SEntityDetection(entity.m_19879_());
            ModNet.CHANNEL.sendToServer((Object)packet);
        }
        catch (Exception e) {
            System.err.println("Failed to send entity detection request for entity ID " + entity.m_19879_() + ": " + e.getMessage());
            e.printStackTrace();
            networkEntityCache.remove(entity.m_19879_());
        }
    }

    public static void updateEntityInfo(int entityId, String name, boolean canCapture, String permissionStatus, float distance) {
        try {
            if (name == null) {
                name = "\u672a\u77e5\u5b9e\u4f53";
            }
            if (permissionStatus == null) {
                permissionStatus = "\u72b6\u6001\u672a\u77e5";
            }
            EntityInfo info = new EntityInfo(name, canCapture, permissionStatus, distance);
            networkEntityCache.put(entityId, info);
            try {
                networkEntityCache.entrySet().removeIf(entry -> ((EntityInfo)entry.getValue()).isExpired());
            }
            catch (Exception cleanupError) {
                System.err.println("Error during cache cleanup: " + cleanupError.getMessage());
            }
        }
        catch (Exception e) {
            System.err.println("Error updating entity info for ID " + entityId + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static EntityInfo getCachedEntityInfo(int entityId) {
        EntityInfo info = networkEntityCache.get(entityId);
        if (info != null && info.isExpired()) {
            networkEntityCache.remove(entityId);
            return null;
        }
        return info;
    }

    public static void clearCache() {
        lastDetectedEntity = null;
        lastDetectionTime = 0L;
    }

    public static boolean shouldShowHud() {
        if (!CameraConfigHelper.shouldShowHudInfo()) {
            return false;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return false;
        }
        return mc.f_91074_.m_21205_().m_41720_() instanceof CameraItem || mc.f_91074_.m_21206_().m_41720_() instanceof CameraItem;
    }

    public static class EntityInfo {
        public final String name;
        public final boolean canCapture;
        public final String permissionStatus;
        public final float distance;
        public final long timestamp;

        public EntityInfo(String name, boolean canCapture, String permissionStatus, float distance) {
            this.name = name;
            this.canCapture = canCapture;
            this.permissionStatus = permissionStatus;
            this.distance = distance;
            this.timestamp = System.currentTimeMillis();
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > 200L;
        }
    }
}

