/*
 * Decompiled with CFR 0.152.
 */
package yiseyo.sculpture.core.manager.capture;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import yiseyo.sculpture.core.data.capture.CaptureResult;
import yiseyo.sculpture.core.data.capture.MeshBufferSource;
import yiseyo.sculpture.core.net.ModNet;
import yiseyo.sculpture.core.net.packet.S2CRequestCapture;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public abstract class CaptureManager {
    private static final Int2ObjectMap<CaptureCallback> capturing = new Int2ObjectOpenHashMap();
    private static final IntSet captureLocks = new IntOpenHashSet();

    @SubscribeEvent
    public static void onEvent(RenderLivingEvent.Pre<?, ?> event) {
        LivingEntity entity = event.getEntity();
        int id = entity.m_19879_();
        if (capturing.containsKey(id) && !captureLocks.contains(id)) {
            captureLocks.add(id);
            MeshBufferSource recorder = new MeshBufferSource();
            Minecraft mc = Minecraft.m_91087_();
            float partialTick = event.getPartialTick();
            float f = Mth.m_14179_((float)partialTick, (float)entity.f_19859_, (float)entity.m_146908_());
            PoseStack poseStack = new PoseStack();
            poseStack.m_85837_(0.5, 0.0, 0.5);
            mc.m_91290_().m_114384_((Entity)entity, 0.0, 0.0, 0.0, f, event.getPartialTick(), poseStack, (MultiBufferSource)recorder, 0xF000F0);
            ((CaptureCallback)capturing.get(id)).accept(new CaptureResult(recorder.freeze()));
            capturing.remove(id);
            captureLocks.remove(id);
        }
    }

    public static void capture(int entityId, CaptureCallback callback) {
        capturing.put(entityId, (Object)callback);
    }

    public static void pendingCapturePacket(Player player, BlockPos pos, Entity entity) {
        ModNet.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new S2CRequestCapture(pos, entity.m_19879_()));
    }

    @FunctionalInterface
    public static interface CaptureCallback
    extends Consumer<CaptureResult> {
    }
}

