/*
 * Decompiled with CFR 0.152.
 */
package yiseyo.sculpture.core.manager.render;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.FriendlyByteBuf;
import yiseyo.sculpture.core.controller.render.LayerHeaderAccessor;
import yiseyo.sculpture.core.controller.render.accessor.VanillaLayerAccessor;

public abstract class LayerManager {
    private static final List<LayerHeaderAccessor> CODECS = new CopyOnWriteArrayList<LayerHeaderAccessor>();

    public static void register(LayerHeaderAccessor codec) {
        CODECS.add(codec);
    }

    public static void writeHeader(RenderType rt, FriendlyByteBuf buf) {
        int id = LayerManager.find(rt);
        buf.writeByte(id);
        CODECS.get(id).encode(rt, buf);
    }

    public static RenderType readHeader(FriendlyByteBuf buf) {
        short id = buf.readUnsignedByte();
        return CODECS.get(id).decode(buf);
    }

    private static int find(RenderType rt) {
        for (int i = 0; i < CODECS.size(); ++i) {
            if (!CODECS.get(i).supports(rt)) continue;
            return i;
        }
        throw new IllegalStateException("\u672a\u627e\u5230\u8bbf\u95ee\u5668\uff1a " + rt);
    }

    static {
        LayerManager.register(new VanillaLayerAccessor());
    }
}

