/*
 * Decompiled with CFR 0.152.
 */
package yiseyo.sculpture.core.net;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.FriendlyByteBuf;
import yiseyo.sculpture.core.data.capture.CaptureResult;
import yiseyo.sculpture.core.data.capture.Vertex;
import yiseyo.sculpture.core.manager.render.LayerManager;

public abstract class MeshCompressor {
    public static byte[] compress(CaptureResult res) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        Map<RenderType, List<Vertex>> mesh = res.byRenderType();
        buf.m_130130_(mesh.size());
        mesh.forEach((rt, verts) -> {
            LayerManager.writeHeader(rt, buf);
            buf.m_130130_(verts.size());
            verts.forEach(v -> MeshCompressor.writeVertex(buf, v));
        });
        byte[] data = new byte[buf.readableBytes()];
        buf.readBytes(data);
        return data;
    }

    public static CaptureResult decompress(byte[] data) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])data));
        int layerCount = buf.m_130242_();
        HashMap<RenderType, List<Vertex>> mesh = new HashMap<RenderType, List<Vertex>>(layerCount);
        for (int i = 0; i < layerCount; ++i) {
            RenderType rt = LayerManager.readHeader(buf);
            int vCount = buf.m_130242_();
            ArrayList<Vertex> vs = new ArrayList<Vertex>(vCount);
            for (int j = 0; j < vCount; ++j) {
                vs.add(MeshCompressor.readVertex(buf));
            }
            mesh.put(rt, vs);
        }
        return new CaptureResult(mesh);
    }

    private static void writeVertex(FriendlyByteBuf buf, Vertex v) {
        buf.writeFloat(v.x());
        buf.writeFloat(v.y());
        buf.writeFloat(v.z());
        buf.writeFloat(v.u());
        buf.writeFloat(v.v());
        buf.writeInt(v.colorARGB());
        buf.writeInt(v.lightPacked());
        buf.writeInt(v.overlayPacked());
        buf.writeFloat(v.nx());
        buf.writeFloat(v.ny());
        buf.writeFloat(v.nz());
    }

    private static Vertex readVertex(FriendlyByteBuf buf) {
        float x = buf.readFloat();
        float y = buf.readFloat();
        float z = buf.readFloat();
        float u = buf.readFloat();
        float v = buf.readFloat();
        int c = buf.readInt();
        int light = buf.readInt();
        int ovl = buf.readInt();
        float nx = buf.readFloat();
        float ny = buf.readFloat();
        float nz = buf.readFloat();
        return new Vertex(x, y, z, u, v, c, light, ovl, nx, ny, nz);
    }
}

