/*
 * Decompiled with CFR 0.152.
 */
package yiseyo.sculpture.core.net.packet;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;
import yiseyo.sculpture.Sculpture;
import yiseyo.sculpture.core.manager.camera.CameraConfigHelper;
import yiseyo.sculpture.core.net.ModNet;
import yiseyo.sculpture.core.net.packet.S2CEntityInfo;

public record C2SEntityDetection(int entityId) {
    public static void encode(C2SEntityDetection msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
    }

    public static C2SEntityDetection decode(FriendlyByteBuf buf) {
        return new C2SEntityDetection(buf.readInt());
    }

    public static void handle(C2SEntityDetection msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null || player.m_9236_() == null) {
                Sculpture.LOGGER.warn("Received C2SEntityDetection from null player or level");
                return;
            }
            try {
                Entity entity = player.m_9236_().m_6815_(msg.entityId);
                if (entity instanceof LivingEntity) {
                    double maxRange;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    boolean isAllowed = CameraConfigHelper.isEntityAllowed((Entity)livingEntity);
                    double distance = player.m_20270_((Entity)livingEntity);
                    boolean inRange = distance <= (maxRange = CameraConfigHelper.getDetectionRange());
                    String entityName = livingEntity.m_5446_().getString();
                    S2CEntityInfo response = new S2CEntityInfo(msg.entityId, entityName, isAllowed && inRange, isAllowed ? "\u5141\u8bb8\u62cd\u6444" : "\u7981\u6b62\u62cd\u6444", (float)distance);
                    ModNet.CHANNEL.reply((Object)response, context);
                    Sculpture.LOGGER.debug("Processed entity detection for {} (ID: {}, Distance: {:.2f}, Allowed: {})", new Object[]{entityName, msg.entityId, distance, isAllowed && inRange});
                } else {
                    S2CEntityInfo response = new S2CEntityInfo(msg.entityId, "\u672a\u77e5\u5b9e\u4f53", false, "\u5b9e\u4f53\u4e0d\u5b58\u5728", -1.0f);
                    ModNet.CHANNEL.reply((Object)response, context);
                    Sculpture.LOGGER.debug("Entity not found or not living entity for ID: {}", (Object)msg.entityId);
                }
            }
            catch (Exception e) {
                Sculpture.LOGGER.error("Error processing entity detection for ID: {}", (Object)msg.entityId, (Object)e);
                S2CEntityInfo errorResponse = new S2CEntityInfo(msg.entityId, "\u9519\u8bef", false, "\u670d\u52a1\u5668\u9519\u8bef", -1.0f);
                ModNet.CHANNEL.reply((Object)errorResponse, context);
            }
        });
        context.setPacketHandled(true);
    }
}

