/*
 * Decompiled with CFR 0.152.
 */
package yiseyo.sculpture.core.net.packet;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import yiseyo.sculpture.Sculpture;
import yiseyo.sculpture.common.ModBlocks;
import yiseyo.sculpture.core.world.StatueBlock;
import yiseyo.sculpture.core.world.StatueBlockEntity;

public record C2SUploadMesh(BlockPos pos, byte[] mesh) {
    public static void encode(C2SUploadMesh msg, FriendlyByteBuf buf) {
        try {
            buf.m_130064_(msg.pos);
            buf.m_130087_(msg.mesh);
        }
        catch (Exception e) {
            Sculpture.LOGGER.error("encode fail", (Throwable)e);
        }
    }

    public static C2SUploadMesh decode(FriendlyByteBuf buf) {
        try {
            BlockPos pos = buf.m_130135_();
            byte[] mesh = buf.m_130052_();
            return new C2SUploadMesh(pos, mesh);
        }
        catch (Exception e) {
            Sculpture.LOGGER.error("decode fail", (Throwable)e);
            throw e;
        }
    }

    public static void handle(C2SUploadMesh msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            ServerLevel level = player.m_284548_();
            if (level.m_8055_(msg.pos).m_60734_() == Blocks.f_50016_) {
                level.m_46597_(msg.pos, ((StatueBlock)((Object)((Object)ModBlocks.STATUE.get()))).m_49966_());
                BlockEntity blockEntity = level.m_7702_(msg.pos);
                if (blockEntity instanceof StatueBlockEntity) {
                    StatueBlockEntity statueBlockEntity = (StatueBlockEntity)blockEntity;
                    statueBlockEntity.acceptMesh(msg.mesh());
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

