/*
 * Decompiled with CFR 0.152.
 */
package yiseyo.sculpture.core.net.packet;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import yiseyo.sculpture.Sculpture;
import yiseyo.sculpture.core.manager.camera.EntityDetectionManager;

public record S2CEntityInfo(int entityId, String entityName, boolean canCapture, String permissionStatus, float distance) {
    public static void encode(S2CEntityInfo msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
        buf.m_130072_(msg.entityName, 256);
        buf.writeBoolean(msg.canCapture);
        buf.m_130072_(msg.permissionStatus, 64);
        buf.writeFloat(msg.distance);
    }

    public static S2CEntityInfo decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        String entityName = buf.m_130136_(256);
        boolean canCapture = buf.readBoolean();
        String permissionStatus = buf.m_130136_(64);
        float distance = buf.readFloat();
        return new S2CEntityInfo(entityId, entityName, canCapture, permissionStatus, distance);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handle(S2CEntityInfo msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            try {
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91074_ == null || mc.f_91073_ == null) {
                    Sculpture.LOGGER.warn("Received S2CEntityInfo but player or level is null");
                    return;
                }
                EntityDetectionManager.updateEntityInfo(msg.entityId, msg.entityName, msg.canCapture, msg.permissionStatus, msg.distance);
                Sculpture.LOGGER.debug("Updated entity info for {} (ID: {}, Distance: {:.2f}, Can Capture: {})", new Object[]{msg.entityName, msg.entityId, Float.valueOf(msg.distance), msg.canCapture});
            }
            catch (Exception e) {
                Sculpture.LOGGER.error("Error handling S2CEntityInfo for entity ID: {}", (Object)msg.entityId, (Object)e);
            }
        });
        context.setPacketHandled(true);
    }

    public static S2CEntityInfo createNotFoundResponse(int entityId) {
        return new S2CEntityInfo(entityId, "\u5b9e\u4f53\u4e0d\u5b58\u5728", false, "\u672a\u627e\u5230\u5b9e\u4f53", -1.0f);
    }

    public static S2CEntityInfo createPermissionDeniedResponse(int entityId, String entityName, float distance) {
        return new S2CEntityInfo(entityId, entityName, false, "\u7981\u6b62\u62cd\u6444", distance);
    }

    public static S2CEntityInfo createOutOfRangeResponse(int entityId, String entityName, float distance) {
        return new S2CEntityInfo(entityId, entityName, false, "\u8ddd\u79bb\u8fc7\u8fdc", distance);
    }

    public static S2CEntityInfo createAllowedResponse(int entityId, String entityName, float distance) {
        return new S2CEntityInfo(entityId, entityName, true, "\u5141\u8bb8\u62cd\u6444", distance);
    }
}

