/*
 * Decompiled with CFR 0.152.
 */
package yiseyo.sculpture.core.net.packet;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.network.NetworkEvent;
import yiseyo.sculpture.Sculpture;
import yiseyo.sculpture.core.manager.capture.CaptureManager;
import yiseyo.sculpture.core.net.MeshCompressor;
import yiseyo.sculpture.core.net.ModNet;
import yiseyo.sculpture.core.net.packet.C2SUploadMesh;

public record S2CRequestCapture(BlockPos pos, int entityId) {
    public static void encode(S2CRequestCapture msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        buf.m_130130_(msg.entityId);
    }

    public static S2CRequestCapture decode(FriendlyByteBuf buf) {
        return new S2CRequestCapture(buf.m_130135_(), buf.m_130242_());
    }

    public static void handle(S2CRequestCapture msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level.m_8055_(msg.pos).m_60734_() == Blocks.f_50016_) {
                try {
                    CaptureManager.capture(msg.entityId, result -> ModNet.CHANNEL.sendToServer((Object)new C2SUploadMesh(msg.pos(), MeshCompressor.compress(result))));
                }
                catch (Exception e) {
                    Sculpture.LOGGER.error("Statue mesh pipeline failed @ {}", (Object)msg.pos(), (Object)e);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

