/*
 * Decompiled with CFR 0.152.
 */
package yiseyo.sculpture.core.world;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import yiseyo.sculpture.Sculpture;
import yiseyo.sculpture.core.manager.camera.CameraConfigHelper;
import yiseyo.sculpture.core.manager.camera.EntityDetectionManager;
import yiseyo.sculpture.core.manager.capture.CaptureManager;

public final class CameraItem
extends Item {
    private static final long CAPTURE_COOLDOWN_MS = 2000L;
    private static final Map<UUID, Long> playerCooldowns = new HashMap<UUID, Long>();

    public CameraItem(Item.Properties props) {
        super(props);
    }

    private InteractionResult performEntityCapture(ItemStack stack, Player player, LivingEntity target, InteractionHand hand, long startTime) {
        Sculpture.LOGGER.debug("[Camera] Player {} attempting to capture entity {} at {}", new Object[]{player.m_7755_().getString(), target.m_7755_().getString(), target.m_20183_()});
        try {
            Level level = player.m_9236_();
            if (!(level instanceof ServerLevel)) {
                return InteractionResult.FAIL;
            }
            ServerLevel level2 = (ServerLevel)level;
            if (target == null) {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u9519\u8bef\uff1a\u76ee\u6807\u5b9e\u4f53\u4e0d\u5b58\u5728"));
                Sculpture.LOGGER.warn("[Camera] Player {} attempted to capture null entity", (Object)player.m_7755_().getString());
                return InteractionResult.FAIL;
            }
            if (!target.m_6084_()) {
                Sculpture.LOGGER.debug("[Camera] Entity {} is not alive, capture failed", (Object)target.m_7755_().getString());
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u65e0\u6cd5\u62cd\u6444\u5df2\u6b7b\u4ea1\u7684\u5b9e\u4f53"));
                return InteractionResult.FAIL;
            }
            Sculpture.LOGGER.debug("[Camera] Basic validation passed for entity {}", (Object)target.m_7755_().getString());
            long configCheckStart = System.currentTimeMillis();
            try {
                if (!CameraConfigHelper.isEntityAllowed((Entity)target)) {
                    Sculpture.LOGGER.debug("[Camera] Entity {} not allowed by configuration", (Object)target.m_7755_().getString());
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u8be5\u5b9e\u4f53\u4e0d\u5141\u8bb8\u62cd\u6444"));
                    return InteractionResult.FAIL;
                }
                double distance = player.m_20270_((Entity)target);
                double maxRange = CameraConfigHelper.getDetectionRange();
                Sculpture.LOGGER.debug("[Camera] Distance check: {:.2f}m (max: {:.2f}m)", (Object)distance, (Object)maxRange);
                if (distance > maxRange) {
                    player.m_213846_((Component)Component.m_237113_((String)String.format("\u00a7c\u8ddd\u79bb\u8fc7\u8fdc (%.1fm > %.1fm)", distance, maxRange)));
                    return InteractionResult.FAIL;
                }
                long configCheckTime = System.currentTimeMillis() - configCheckStart;
                Sculpture.LOGGER.debug("[Camera] Configuration check completed in {}ms", (Object)configCheckTime);
            }
            catch (Exception configError) {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u914d\u7f6e\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6"));
                Sculpture.LOGGER.error("[Camera] Configuration error while checking entity permissions", (Throwable)configError);
                return InteractionResult.FAIL;
            }
            long positionSearchStart = System.currentTimeMillis();
            BlockPos pos = this.findOptimalStatuePosition(level2, target, player);
            long positionSearchTime = System.currentTimeMillis() - positionSearchStart;
            if (pos == null) {
                Sculpture.LOGGER.debug("[Camera] No suitable position found for statue placement (search took {}ms)", (Object)positionSearchTime);
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u9644\u8fd1\u6ca1\u6709\u5408\u9002\u7684\u4f4d\u7f6e\u653e\u7f6e\u96d5\u50cf"));
                return InteractionResult.FAIL;
            }
            Sculpture.LOGGER.debug("[Camera] Found statue position {} in {}ms", (Object)pos, (Object)positionSearchTime);
            long networkStart = System.currentTimeMillis();
            try {
                CaptureManager.pendingCapturePacket(player, pos, (Entity)target);
                long networkTime = System.currentTimeMillis() - networkStart;
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7a\u6210\u529f\u62cd\u6444 ").m_7220_(target.m_7755_()).m_130946_(" \u00a7a\u5e76\u751f\u6210\u96d5\u50cf"));
                long totalTime = System.currentTimeMillis() - startTime;
                Sculpture.LOGGER.info("[Camera] Player {} successfully captured entity {} at {} (total time: {}ms, network: {}ms)", new Object[]{player.m_7755_().getString(), target.m_7755_().getString(), pos, totalTime, networkTime});
                long soundStart = System.currentTimeMillis();
                try {
                    level2.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.6f, 1.8f);
                    level2.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundEvents.f_12490_.m_203334_(), SoundSource.PLAYERS, 0.4f, 2.0f);
                    long soundTime = System.currentTimeMillis() - soundStart;
                    Sculpture.LOGGER.debug("[Camera] Sound effects played in {}ms", (Object)soundTime);
                }
                catch (Exception soundError) {
                    long soundTime = System.currentTimeMillis() - soundStart;
                    Sculpture.LOGGER.debug("[Camera] Failed to play camera sound effect (after {}ms)", (Object)soundTime, (Object)soundError);
                }
                long particleStart = System.currentTimeMillis();
                try {
                    if (level2 instanceof ServerLevel) {
                        ServerLevel serverLevel = level2;
                        double entityX = target.m_20185_();
                        double entityY = target.m_20186_() + (double)(target.m_20206_() / 2.0f);
                        double entityZ = target.m_20189_();
                        for (int i = 0; i < 12; ++i) {
                            double angle = (double)i / 12.0 * 2.0 * Math.PI;
                            double offsetX = Math.cos(angle) * 1.5;
                            double offsetZ = Math.sin(angle) * 1.5;
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123747_, entityX + offsetX, entityY, entityZ + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                        }
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 8, 0.3, 0.3, 0.3, 0.1);
                        long particleTime = System.currentTimeMillis() - particleStart;
                        Sculpture.LOGGER.debug("[Camera] Particle effects spawned in {}ms (20 particles total)", (Object)particleTime);
                    }
                }
                catch (Exception particleError) {
                    long particleTime = System.currentTimeMillis() - particleStart;
                    Sculpture.LOGGER.debug("[Camera] Failed to spawn camera particles (after {}ms)", (Object)particleTime, (Object)particleError);
                }
            }
            catch (Exception networkError) {
                long networkTime = System.currentTimeMillis() - networkStart;
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7e\u96d5\u50cf\u5df2\u751f\u6210\uff0c\u4f46\u7f51\u7edc\u540c\u6b65\u53ef\u80fd\u5931\u8d25"));
                Sculpture.LOGGER.error("[Camera] Network error while processing capture for player {} (failed after {}ms)", new Object[]{player.m_7755_().getString(), networkTime, networkError});
            }
            long durabilityStart = System.currentTimeMillis();
            try {
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                long durabilityTime = System.currentTimeMillis() - durabilityStart;
                Sculpture.LOGGER.debug("[Camera] Item durability updated in {}ms", (Object)durabilityTime);
            }
            catch (Exception durabilityError) {
                long durabilityTime = System.currentTimeMillis() - durabilityStart;
                Sculpture.LOGGER.warn("[Camera] Error applying durability damage to camera item (after {}ms)", (Object)durabilityTime, (Object)durabilityError);
            }
            this.setCooldown(player);
            long totalTime = System.currentTimeMillis() - startTime;
            Sculpture.LOGGER.info("[Camera] Capture process completed successfully in {}ms for player {} -> entity {}", new Object[]{totalTime, player.m_7755_().getString(), target.m_7755_().getString()});
            return InteractionResult.CONSUME;
        }
        catch (Exception generalError) {
            long totalTime = System.currentTimeMillis() - startTime;
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u62cd\u6444\u8fc7\u7a0b\u4e2d\u53d1\u751f\u672a\u77e5\u9519\u8bef"));
            Sculpture.LOGGER.error("[Camera] Unexpected error during entity capture by player {} (failed after {}ms)", new Object[]{player.m_7755_().getString(), totalTime, generalError});
            return InteractionResult.FAIL;
        }
    }

    private boolean isOnCooldown(Player player) {
        UUID playerId = player.m_20148_();
        Long lastUseTime = playerCooldowns.get(playerId);
        if (lastUseTime == null) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        return currentTime - lastUseTime < 2000L;
    }

    private void setCooldown(Player player) {
        playerCooldowns.put(player.m_20148_(), System.currentTimeMillis());
    }

    private double getRemainingCooldown(Player player) {
        UUID playerId = player.m_20148_();
        Long lastUseTime = playerCooldowns.get(playerId);
        if (lastUseTime == null) {
            return 0.0;
        }
        long currentTime = System.currentTimeMillis();
        long elapsed = currentTime - lastUseTime;
        if (elapsed >= 2000L) {
            return 0.0;
        }
        return (double)(2000L - elapsed) / 1000.0;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        long startTime = System.currentTimeMillis();
        if (level.f_46443_) {
            Sculpture.LOGGER.debug("[Camera] Client-side use() called for player {}", (Object)player.m_7755_().getString());
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        Sculpture.LOGGER.debug("[Camera] Server-side use() called for player {} at position {}", (Object)player.m_7755_().getString(), (Object)player.m_20183_());
        if (this.isOnCooldown(player)) {
            double remainingTime = this.getRemainingCooldown(player);
            Sculpture.LOGGER.debug("[Camera] Player {} on cooldown in use(), remaining: {:.1f}s", (Object)player.m_7755_().getString(), (Object)remainingTime);
            player.m_213846_((Component)Component.m_237113_((String)String.format("\u00a7c\u76f8\u673a\u51b7\u5374\u4e2d\uff0c\u8fd8\u9700\u7b49\u5f85 %.1f \u79d2", remainingTime)));
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        try {
            LivingEntity target = EntityDetectionManager.getTargetedEntity(player);
            if (target == null) {
                Sculpture.LOGGER.debug("[Camera] No target entity found, showing usage hint");
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7e\u8bf7\u5c06\u51c6\u661f\u5bf9\u51c6\u8981\u62cd\u6444\u7684\u751f\u7269\uff0c\u7136\u540e\u53f3\u952e\u70b9\u51fb"));
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            Sculpture.LOGGER.debug("[Camera] Target entity found: {} at distance {:.2f}", (Object)target.m_7755_().getString(), (Object)Float.valueOf(player.m_20270_((Entity)target)));
            InteractionResult captureResult = this.performEntityCapture(stack, player, target, hand, startTime);
            if (captureResult == InteractionResult.CONSUME) {
                return InteractionResultHolder.m_19096_((Object)stack);
            }
            if (captureResult == InteractionResult.FAIL) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        catch (Exception e) {
            Sculpture.LOGGER.error("[Camera] Error during entity detection and capture in use() method", (Throwable)e);
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u62cd\u6444\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef"));
            return InteractionResultHolder.m_19100_((Object)stack);
        }
    }

    private BlockPos findOptimalStatuePosition(ServerLevel level, LivingEntity target, Player player) {
        BlockPos targetPos = target.m_20183_();
        Sculpture.LOGGER.debug("[Camera] Searching for statue position near target at {}", (Object)targetPos);
        if (this.isValidStatuePosition(level, targetPos)) {
            Sculpture.LOGGER.debug("[Camera] Using target position {} for statue", (Object)targetPos);
            return targetPos;
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                if (dx == 0 && dz == 0) continue;
                BlockPos candidatePos = targetPos.m_7918_(dx, 0, dz);
                if (this.isValidStatuePosition(level, candidatePos)) {
                    Sculpture.LOGGER.debug("[Camera] Using nearby position {} for statue", (Object)candidatePos);
                    return candidatePos;
                }
                BlockPos upperPos = candidatePos.m_7494_();
                BlockPos lowerPos = candidatePos.m_7495_();
                if (this.isValidStatuePosition(level, upperPos)) {
                    Sculpture.LOGGER.debug("[Camera] Using upper position {} for statue", (Object)upperPos);
                    return upperPos;
                }
                if (!this.isValidStatuePosition(level, lowerPos)) continue;
                Sculpture.LOGGER.debug("[Camera] Using lower position {} for statue", (Object)lowerPos);
                return lowerPos;
            }
        }
        BlockPos playerPos = player.m_20183_();
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                BlockPos candidatePos = playerPos.m_7918_(dx, 0, dz);
                if (candidatePos.m_123331_((Vec3i)targetPos) > 25.0 || !this.isValidStatuePosition(level, candidatePos)) continue;
                Sculpture.LOGGER.debug("[Camera] Using player-nearby position {} for statue", (Object)candidatePos);
                return candidatePos;
            }
        }
        Sculpture.LOGGER.debug("[Camera] No suitable position found for statue placement");
        return null;
    }

    private boolean isValidStatuePosition(ServerLevel level, BlockPos pos) {
        try {
            BlockState currentState = level.m_8055_(pos);
            if (!currentState.m_247087_()) {
                return false;
            }
            BlockPos belowPos = pos.m_7495_();
            BlockState belowState = level.m_8055_(belowPos);
            if (belowState.m_60795_()) {
                return false;
            }
            BlockPos abovePos = pos.m_7494_();
            BlockState aboveState = level.m_8055_(abovePos);
            if (!aboveState.m_247087_()) {
                return false;
            }
            return level.m_46739_(pos);
        }
        catch (Exception e) {
            Sculpture.LOGGER.debug("Error checking statue position validity at {}", (Object)pos, (Object)e);
            return false;
        }
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        return this.performEntityCapture(stack, player, target, hand, System.currentTimeMillis());
    }
}

