/*
 * Decompiled with CFR 0.152.
 */
package yiseyo.sculpture.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import yiseyo.sculpture.core.data.capture.CaptureResult;
import yiseyo.sculpture.core.data.capture.Vertex;
import yiseyo.sculpture.core.net.MeshCompressor;
import yiseyo.sculpture.core.world.StatueBlockEntity;
import yiseyo.sculpture.utils.RenderTextureUtil;

public class StatueBER
implements BlockEntityRenderer<StatueBlockEntity> {
    public StatueBER(BlockEntityRendererProvider.Context ctx) {
    }

    private static int layerPriority(RenderType rt) {
        String n = rt.toString().toLowerCase();
        if (n.contains("glint")) {
            return 3;
        }
        if (n.contains("emissive") || n.contains("eyes")) {
            return 2;
        }
        if (n.contains("translucent")) {
            return 1;
        }
        return 0;
    }

    public void render(StatueBlockEntity be, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (!be.hasMesh()) {
            return;
        }
        CaptureResult mesh = MeshCompressor.decompress(be.meshBytes());
        if (mesh == null || mesh.byRenderType().isEmpty()) {
            return;
        }
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        long time = be.m_58904_() != null ? be.m_58904_().m_46467_() : 0L;
        float swirl = ((float)time + partialTicks) * 0.01f;
        mesh.byRenderType().entrySet().stream().sorted(Comparator.comparingInt(e -> StatueBER.layerPriority((RenderType)e.getKey()))).forEach(entry -> {
            RenderType original;
            RenderType rt = original = (RenderType)entry.getKey();
            String n = original.toString().toLowerCase();
            if (n.contains("swirl")) {
                ResourceLocation tex = RenderTextureUtil.textureOf(original);
                rt = RenderType.m_110436_((ResourceLocation)tex, (float)swirl, (float)swirl);
            } else if (n.contains("armor_glint") || n.contains("armor_entity_glint")) {
                rt = RenderType.m_110481_();
            }
            VertexConsumer vc = buffer.m_6299_(rt);
            for (Vertex v : (List)entry.getValue()) {
                int argb = v.colorARGB();
                int a = argb >>> 24 & 0xFF;
                int r = argb >>> 16 & 0xFF;
                int g = argb >>> 8 & 0xFF;
                int b = argb & 0xFF;
                int ovl = v.overlayPacked();
                vc.m_252986_(matrix, v.x(), v.y(), v.z()).m_6122_(r, g, b, a).m_7421_(v.u(), v.v()).m_7122_(ovl & 0xFFFF, ovl >>> 16 & 0xFFFF).m_7120_(packedLight & 0xFFFF, packedLight >>> 16 & 0xFFFF).m_5601_(v.nx(), v.ny(), v.nz()).m_5752_();
            }
        });
    }
}

