/*
 * Decompiled with CFR 0.152.
 */
package com.gamerben.knightsandcastles.startup;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="knights_and_castles", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModStartupAnnouncer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String MOD_ID = "knights_and_castles";
    private static final String MINECRAFT_VERSION = "1.20.1";
    private static String modVersion = "UNKNOWN";
    private static boolean hasAnnounced = false;
    private static int ticksUntilBroadcast = -1;
    private static MinecraftServer cachedServer = null;

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!hasAnnounced && ticksUntilBroadcast == -1) {
            cachedServer = event.getEntity().m_20194_();
            ticksUntilBroadcast = 40;
            LOGGER.info("Server active. Preparing to broadcast startup message.");
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || hasAnnounced || ticksUntilBroadcast < 0) {
            return;
        }
        if (--ticksUntilBroadcast <= 0 && cachedServer != null) {
            ModStartupAnnouncer.broadcastStartupMessage(cachedServer);
            hasAnnounced = true;
            ticksUntilBroadcast = -1;
            cachedServer = null;
        }
    }

    private static void broadcastStartupMessage(MinecraftServer server) {
        ModStartupAnnouncer.sendColored(server, ChatFormatting.GOLD, "==============================");
        server.m_6846_().m_11314_().forEach(player -> player.m_213846_((Component)Component.m_237113_((String)" Knights and Castles            ").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})));
        ModStartupAnnouncer.sendColored(server, ChatFormatting.YELLOW, " VERSION: ").m_7220_((Component)Component.m_237113_((String)modVersion).m_130940_(ChatFormatting.AQUA));
        ModStartupAnnouncer.sendColored(server, ChatFormatting.YELLOW, " Mod ID: knights_and_castles");
        ModStartupAnnouncer.sendColored(server, ChatFormatting.YELLOW, " Minecraft Version: ").m_7220_((Component)Component.m_237113_((String)MINECRAFT_VERSION).m_130940_(ChatFormatting.AQUA));
        server.m_6846_().m_11314_().forEach(player -> {
            MutableComponent line = Component.m_237113_((String)" Multiplayer-safe: ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)"YES").m_130940_(ChatFormatting.GREEN));
            player.m_213846_((Component)line);
        });
        ModStartupAnnouncer.sendColored(server, ChatFormatting.GOLD, "==============================");
        ModStartupAnnouncer.sendColored(server, ChatFormatting.BLUE, " Maintained by");
        ModStartupAnnouncer.sendColored(server, ChatFormatting.AQUA, " gamerbenyt");
        ModStartupAnnouncer.sendColored(server, ChatFormatting.GOLD, "==============================");
        LOGGER.info("KNC startup message sent to all players.");
    }

    private static MutableComponent sendColored(MinecraftServer server, ChatFormatting color, String message) {
        MutableComponent component = Component.m_237113_((String)message).m_130940_(color);
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            player.m_213846_((Component)component);
        }
        return component;
    }

    static {
        ModList.get().getModContainerById(MOD_ID).ifPresent(container -> {
            modVersion = container.getModInfo().getVersion().toString();
        });
        LOGGER.info("KNC loaded. Mod version: {}", (Object)modVersion);
    }
}

