/*
 * Decompiled with CFR 0.152.
 */
package com.gamerben.knightsandcastles.init;

import com.gamerben.knightsandcastles.entity.FireballEntity;
import com.gamerben.knightsandcastles.entity.KnightEntity;
import com.gamerben.knightsandcastles.entity.RubyarrowEntity;
import com.gamerben.knightsandcastles.entity.UndeadKnightEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class KnightsAndCastlesModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"knights_and_castles");
    public static final RegistryObject<EntityType<KnightEntity>> KNIGHT = KnightsAndCastlesModEntities.register("knight", EntityType.Builder.m_20704_(KnightEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(KnightEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<UndeadKnightEntity>> UNDEAD_KNIGHT = KnightsAndCastlesModEntities.register("undead_knight", EntityType.Builder.m_20704_(UndeadKnightEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(UndeadKnightEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<FireballEntity>> FIRESPHERE = KnightsAndCastlesModEntities.register("firesphere", EntityType.Builder.m_20704_(FireballEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(FireballEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<RubyarrowEntity>> RUBYARROW = KnightsAndCastlesModEntities.register("rubyarrow", EntityType.Builder.m_20704_(RubyarrowEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(RubyarrowEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            KnightEntity.init();
            UndeadKnightEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)KNIGHT.get(), KnightEntity.m_28883_().m_22265_());
        event.put((EntityType)UNDEAD_KNIGHT.get(), UndeadKnightEntity.m_34328_().m_22265_());
    }
}

