package xyz.verarr.adjusted_phantom_spawns.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.class_2910;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.verarr.adjusted_phantom_spawns.AdjustedPhantomSpawns;
import xyz.verarr.adjusted_phantom_spawns.GameRuleHelper;
import xyz.verarr.adjusted_phantom_spawns.config.AdjustedPhantomSpawnsConfig;

@Mixin(class_2910.class)
public class PhantomChanceScalerMixin {
    @Unique private GameRuleHelper adjusted_phantom_spawns$PhantomChanceScalerMixin$gameRuleHelper;

    @Inject(method = "spawn(Lnet/minecraft/server/world/ServerWorld;Z)V", at = @At("HEAD"))
    private void getGameRuleHelper(class_3218  world,
                                   boolean      spawnMonsters,
                                   CallbackInfo ci) {
        adjusted_phantom_spawns$PhantomChanceScalerMixin$gameRuleHelper =
            GameRuleHelper.getInstance(world);
    }

    @WrapOperation(
        method = "spawn(Lnet/minecraft/server/world/ServerWorld;Z)V",
        at     = @At(value   = "INVOKE",
                     target  = "Lnet/minecraft/util/math/random/Random;nextInt(I)I",
                     ordinal = 0),
        slice  = @Slice(
            from = @At(
                value = "INVOKE",
                target =
                    "Lnet/minecraft/stat/StatType;getOrCreateStat(Ljava/lang/Object;)Lnet/minecraft/stat/Stat;")))
    private int
    scaleRandomInput(class_5819 random, int j, Operation<Integer> original) {
        float scalar = adjusted_phantom_spawns$PhantomChanceScalerMixin$gameRuleHelper
                           .getPhantomSpawningChanceScalar();
        int newJ = class_3532.method_15340(Math.round((j - 72000) * scalar + 72000), 1, Integer.MAX_VALUE);
        if (AdjustedPhantomSpawnsConfig.debug_print_chance)
            AdjustedPhantomSpawns.LOGGER.info("Random input scaled from {} to {}", j, newJ);
        return original.call(random, newJ);
    }
}
