package xyz.verarr.adjusted_phantom_spawns.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.class_2910;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.verarr.adjusted_phantom_spawns.AdjustedPhantomSpawns;
import xyz.verarr.adjusted_phantom_spawns.GameRuleHelper;
import xyz.verarr.adjusted_phantom_spawns.config.AdjustedPhantomSpawnsConfig;

@Mixin(class_2910.class)
public class RestStatScalerMixin {
    @Unique private GameRuleHelper adjusted_phantom_spawns$RestStatScalerMixin$gameRuleHelper;

    @Inject(method = "spawn(Lnet/minecraft/server/world/ServerWorld;Z)V", at = @At("HEAD"))
    private void getGameRuleHelper(class_3218  world,
                                   boolean      spawnMonsters,
                                   CallbackInfo ci) {
        adjusted_phantom_spawns$RestStatScalerMixin$gameRuleHelper =
            GameRuleHelper.getInstance(world);
    }

    @ModifyExpressionValue(
        method = "spawn(Lnet/minecraft/server/world/ServerWorld;Z)V",
        at     = @At(
            value  = "INVOKE",
            target = "Lnet/minecraft/stat/ServerStatHandler;getStat(Lnet/minecraft/stat/Stat;)I"))
    private int
    scaleRestStatistic(int original) {
        int scaled = Math.round(
            original
            * adjusted_phantom_spawns$RestStatScalerMixin$gameRuleHelper.getRestStatScalar());
        if (AdjustedPhantomSpawnsConfig.debug_print_rest_since)
            AdjustedPhantomSpawns.LOGGER.info("Sleep statistic for player scaled from {} to {}",
                                              original, scaled);
        return scaled;
    }
}
