/*
 * Decompiled with CFR 0.152.
 */
package xyz.verarr.adjusted_phantom_spawns;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import xyz.verarr.adjusted_phantom_spawns.AdjustedPhantomSpawns;

public class GameRuleHelper {
    private static final Map<ServerLevel, GameRuleHelper> instances = new HashMap<ServerLevel, GameRuleHelper>(1);
    private final GameRules gameRules;

    public GameRuleHelper(ServerLevel serverWorld) {
        this.gameRules = serverWorld.getGameRules();
    }

    public static GameRuleHelper getInstance(ServerLevel serverWorld) {
        return instances.computeIfAbsent(serverWorld, GameRuleHelper::new);
    }

    private int getPhantomSpawningThreshold() {
        return this.gameRules.getInt(AdjustedPhantomSpawns.PHANTOM_SPAWNING_THRESHOLD);
    }

    public float getRestStatScalar() {
        return 72000.0f / (float)this.getPhantomSpawningThreshold();
    }

    private int getPhantomSpawningCooldownPercentage() {
        return this.gameRules.getInt(AdjustedPhantomSpawns.PHANTOM_SPAWNING_COOLDOWN_PERCENTAGE);
    }

    public float getPhantomSpawningCooldownScalar() {
        return (float)this.getPhantomSpawningCooldownPercentage() / 100.0f;
    }

    private int getPhantomSpawningChancePercentage() {
        return this.gameRules.getInt(AdjustedPhantomSpawns.PHANTOM_SPAWNING_CHANCE_PERCENTAGE);
    }

    public float getPhantomSpawningChanceScalar() {
        return (float)this.getPhantomSpawningChancePercentage() / 100.0f;
    }
}

