/*
 * Decompiled with CFR 0.152.
 */
package xyz.verarr.adjusted_phantom_spawns.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.levelgen.PhantomSpawner;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.verarr.adjusted_phantom_spawns.AdjustedPhantomSpawns;
import xyz.verarr.adjusted_phantom_spawns.GameRuleHelper;
import xyz.verarr.adjusted_phantom_spawns.config.AdjustedPhantomSpawnsConfig;

@Mixin(value={PhantomSpawner.class})
public class PhantomCooldownScalerMixin {
    @Shadow
    private int nextTick;
    @Unique
    private GameRuleHelper adjusted_phantom_spawns$PhantomCooldownScalerMixin$gameRuleHelper;

    @Inject(method={"tick(Lnet/minecraft/server/level/ServerLevel;Z)V"}, at={@At(value="HEAD")})
    private void getGameRuleHelper(ServerLevel world, boolean spawnMonsters, CallbackInfo ci) {
        this.adjusted_phantom_spawns$PhantomCooldownScalerMixin$gameRuleHelper = GameRuleHelper.getInstance(world);
    }

    @WrapOperation(method={"tick(Lnet/minecraft/server/level/ServerLevel;Z)V"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/levelgen/PhantomSpawner;nextTick:I", opcode=181, ordinal=1)})
    private void wrapCooldownAssignment(PhantomSpawner instance, int value, Operation<Void> original) {
        int origRandValue = (value - this.nextTick) / 20 - 60;
        float scalar = this.adjusted_phantom_spawns$PhantomCooldownScalerMixin$gameRuleHelper.getPhantomSpawningCooldownScalar();
        int increment = Math.round((float)((60 + origRandValue) * 20) * scalar);
        original.call(new Object[]{instance, this.nextTick + increment});
        if (AdjustedPhantomSpawnsConfig.debug_print_cooldown) {
            AdjustedPhantomSpawns.LOGGER.info("Cooldown incremented from {} by {} to {} (by {}%; original {})", new Object[]{this.nextTick - increment, increment, this.nextTick, Float.valueOf(scalar * 100.0f), value});
        }
    }
}

