/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pixelshot.client.handler;

import fuzs.pixelshot.Pixelshot;
import fuzs.pixelshot.client.handler.OrthoViewHandler;
import fuzs.pixelshot.config.ClientConfig;
import fuzs.puzzleslib.api.client.core.v1.context.KeyMappingsContext;
import fuzs.puzzleslib.api.client.key.v1.KeyActivationContext;
import fuzs.puzzleslib.api.client.key.v1.KeyMappingHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import java.io.File;
import java.util.function.Consumer;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_9779;

public class ScreenshotHandler {
    public static final ScreenshotHandler INSTANCE = new ScreenshotHandler();
    public static final class_5250 COMPONENT_SCREENSHOT_TAKE = class_2561.method_43471((String)"screenshot.take");
    public static final class_304 KEY_HIGH_RESOLUTION_SCREENSHOT = KeyMappingHelper.registerKeyMapping((class_2960)Pixelshot.id("high_resolution_screenshot"), (int)298);
    public static final class_304 KEY_PANORAMIC_SCREENSHOT = KeyMappingHelper.registerUnboundKeyMapping((class_2960)Pixelshot.id("panoramic_screenshot"));
    private boolean hugeScreenshotMode;

    public static void onRegisterKeyMappings(KeyMappingsContext context) {
        context.registerKeyMapping(KEY_HIGH_RESOLUTION_SCREENSHOT, KeyActivationContext.GAME);
        context.registerKeyMapping(KEY_PANORAMIC_SCREENSHOT, KeyActivationContext.GAME);
    }

    public boolean isHugeScreenshotMode() {
        return this.hugeScreenshotMode;
    }

    private void setHugeScreenshotMode(boolean hugeScreenshotMode) {
        this.hugeScreenshotMode = hugeScreenshotMode;
        class_757 gameRenderer = class_310.method_1551().field_1773;
        gameRenderer.method_35769(!hugeScreenshotMode);
        gameRenderer.method_35768(!hugeScreenshotMode);
    }

    public EventResult onKeyPress(int keyCode, int scanCode, int action, int modifiers) {
        class_310 minecraft = class_310.method_1551();
        if (action == 1 && minecraft.field_1755 == null) {
            if (KEY_HIGH_RESOLUTION_SCREENSHOT.method_1417(keyCode, scanCode)) {
                int windowWidth = minecraft.method_22683().method_4489();
                int windowHeight = minecraft.method_22683().method_4506();
                int imageWidth = ((ClientConfig)Pixelshot.CONFIG.get(ClientConfig.class)).highResolutionScreenshots.imageWidth;
                int imageHeight = ((ClientConfig)Pixelshot.CONFIG.get(ClientConfig.class)).highResolutionScreenshots.imageHeight;
                Consumer<class_2561> consumer = component -> minecraft.execute(() -> minecraft.field_1705.method_1743().method_1812(component));
                this.setHugeScreenshotMode(true);
                if (((ClientConfig)Pixelshot.CONFIG.get(ClientConfig.class)).highResolutionScreenshots.tiledRendering) {
                    consumer.accept(minecraft.method_35699(minecraft.field_1697, windowWidth, windowHeight, imageWidth, imageHeight));
                } else {
                    this.grabHugeScreenshot(minecraft, windowWidth, windowHeight, imageWidth, imageHeight, consumer);
                }
                this.setHugeScreenshotMode(false);
            }
            if (KEY_PANORAMIC_SCREENSHOT.method_1417(keyCode, scanCode) && !OrthoViewHandler.INSTANCE.isActive()) {
                int panoramicResolution = ((ClientConfig)Pixelshot.CONFIG.get(ClientConfig.class)).highResolutionScreenshots.panoramicResolution;
                class_2561 component2 = this.grabPanoramicScreenshot(minecraft, minecraft.field_1697, panoramicResolution, panoramicResolution);
                minecraft.execute(() -> minecraft.field_1705.method_1743().method_1812(component2));
            }
        }
        return EventResult.PASS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grabHugeScreenshot(class_310 minecraft, int windowWidth, int windowHeight, int imageWidth, int imageHeight, Consumer<class_2561> consumer) {
        class_1041 window = minecraft.method_22683();
        class_276 renderTarget = minecraft.method_1522();
        try {
            window.method_35642(imageWidth);
            window.method_35643(imageHeight);
            renderTarget.method_1234(imageWidth, imageHeight);
            renderTarget.method_1235(true);
            minecraft.field_1773.method_3188(class_9779.field_51956);
            String screenshotName = ScreenshotHandler.getFile(minecraft.field_1697, "huge_", ".png").getName();
            class_318.method_22690((File)minecraft.field_1697, (String)screenshotName, (class_276)renderTarget, consumer);
            consumer.accept((class_2561)COMPONENT_SCREENSHOT_TAKE);
        }
        finally {
            window.method_35642(windowWidth);
            window.method_35643(windowHeight);
            renderTarget.method_1234(windowWidth, windowHeight);
            renderTarget.method_1235(true);
        }
    }

    private void setPanoramicMode(boolean panoramicMode) {
        class_757 gameRenderer = class_310.method_1551().field_1773;
        gameRenderer.method_35769(!panoramicMode);
        gameRenderer.method_35770(panoramicMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private class_2561 grabPanoramicScreenshot(class_310 minecraft, File gameDirectory, int width, int height) {
        class_1041 window = minecraft.method_22683();
        class_746 player = minecraft.field_1724;
        int windowWidth = window.method_4489();
        int windowHeight = window.method_4506();
        class_276 renderTarget = minecraft.method_1522();
        float xRot = player.method_36455();
        float yRot = player.method_36454();
        float xRotO = player.field_6004;
        float yRotO = player.field_5982;
        try {
            this.setPanoramicMode(true);
            window.method_35642(width);
            window.method_35643(height);
            renderTarget.method_1234(width, height);
            File file = ScreenshotHandler.getFile(new File(minecraft.field_1697, "screenshots"), "", "");
            file.mkdirs();
            String fileName = file.getName();
            for (int i = 0; i < 6; ++i) {
                switch (i) {
                    case 0: {
                        player.method_36456(yRot);
                        player.method_36457(0.0f);
                        break;
                    }
                    case 1: {
                        player.method_36456((yRot + 90.0f) % 360.0f);
                        player.method_36457(0.0f);
                        break;
                    }
                    case 2: {
                        player.method_36456((yRot + 180.0f) % 360.0f);
                        player.method_36457(0.0f);
                        break;
                    }
                    case 3: {
                        player.method_36456((yRot - 90.0f) % 360.0f);
                        player.method_36457(0.0f);
                        break;
                    }
                    case 4: {
                        player.method_36456(yRot);
                        player.method_36457(-90.0f);
                        break;
                    }
                    case 5: {
                        player.method_36456(yRot);
                        player.method_36457(90.0f);
                    }
                }
                player.field_5982 = player.method_36454();
                player.field_6004 = player.method_36455();
                renderTarget.method_1235(true);
                minecraft.field_1773.method_3188(class_9779.field_51956);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                class_318.method_22690((File)gameDirectory, (String)(fileName + File.separator + "panorama_" + i + ".png"), (class_276)renderTarget, component -> {});
            }
            class_5250 component2 = class_2561.method_43470((String)fileName).method_27692(class_124.field_1073).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11746, file.getAbsolutePath())));
            class_5250 class_52502 = class_2561.method_43469((String)"screenshot.success", (Object[])new Object[]{component2});
            return class_52502;
        }
        catch (Exception exception) {
            Pixelshot.LOGGER.error("Couldn't save image", (Throwable)exception);
            class_5250 class_52503 = class_2561.method_43469((String)"screenshot.failure", (Object[])new Object[]{exception.getMessage()});
            return class_52503;
        }
        finally {
            player.method_36457(xRot);
            player.method_36456(yRot);
            player.field_6004 = xRotO;
            player.field_5982 = yRotO;
            window.method_35642(windowWidth);
            window.method_35643(windowHeight);
            renderTarget.method_1234(windowWidth, windowHeight);
            this.setPanoramicMode(false);
            renderTarget.method_1235(true);
        }
    }

    private static File getFile(File gameDirectory, String filePrefix, String filePostfix) {
        String fileName = filePrefix + class_156.method_44893();
        int i = 1;
        File file;
        while ((file = new File(gameDirectory, fileName + (String)(i == 1 ? "" : "_" + i) + filePostfix)).exists()) {
            ++i;
        }
        return file;
    }
}

