/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pixelshot.client.helper;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2350;
import net.minecraft.class_3532;
import org.joml.Vector3f;
import org.joml.Vector3i;

public class DirectionHelper {
    static final Map<class_2350, Vector3f> VALUES = (Map)Arrays.stream(class_2350.values()).collect(Maps.toImmutableEnumMap(Function.identity(), DirectionHelper::getAnglesFromRotation));

    static Vector3f getAnglesFromRotation(class_2350 direction) {
        Vector3f vector3f = direction.method_23224().getEulerAnglesXYZ(new Vector3f()).mul(57.295776f).sub(90.0f, 0.0f, 0.0f);
        return vector3f.set(class_3532.method_15393((float)vector3f.x()), class_3532.method_15393((float)vector3f.y()), class_3532.method_15393((float)vector3f.z())).round();
    }

    public static class_2350 cycleForward(class_2350 direction) {
        return class_2350.method_10143((int)(direction.method_10146() + 1));
    }

    public static class_2350 cycleBackward(class_2350 direction) {
        return class_2350.method_10143((int)(direction.method_10146() + 5));
    }

    public static Vector3f getAngles(class_2350 direction) {
        return VALUES.get(direction);
    }

    public static Vector3f cycle(float xRot, float yRot, boolean forward) {
        class_2350 direction = DirectionHelper.getNearest(xRot, yRot);
        Vector3f angles = DirectionHelper.getAngles(direction);
        if (angles.x() == xRot && angles.z() == yRot) {
            direction = forward ? DirectionHelper.cycleForward(direction) : DirectionHelper.cycleBackward(direction);
            return DirectionHelper.getAngles(direction);
        }
        return angles;
    }

    public static Vector3f getDirectionVector(float pitch, float yaw) {
        float x = class_3532.method_15362((float)yaw) * class_3532.method_15362((float)pitch);
        float y = class_3532.method_15374((float)yaw) * class_3532.method_15362((float)pitch);
        float z = class_3532.method_15374((float)pitch);
        return new Vector3f(-y, -z, x);
    }

    public static class_2350 getNearest(float xRot, float yRot) {
        Vector3f vector3f = DirectionHelper.getDirectionVector(xRot * ((float)Math.PI / 180), yRot * ((float)Math.PI / 180));
        int maxComponent = vector3f.absolute(new Vector3f()).maxComponent();
        Vector3i vector3i = new Vector3i().setComponent(maxComponent, (int)Math.signum(vector3f.get(maxComponent)));
        return class_2350.method_62672((int)vector3i.x(), (int)vector3i.y(), (int)vector3i.z(), null);
    }
}

