/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pixelshot.client.gui.screens;

import fuzs.pixelshot.Pixelshot;
import fuzs.pixelshot.client.gui.screens.EditBoxCameraScreen;
import fuzs.pixelshot.client.gui.screens.SliderCameraScreen;
import fuzs.pixelshot.client.handler.OrthoViewHandler;
import fuzs.pixelshot.config.ClientConfig;
import fuzs.puzzleslib.api.client.gui.v2.components.SpritelessImageButton;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public abstract class AbstractCameraScreen
extends Screen {
    static final ResourceLocation WIDGETS_LOCATION = Pixelshot.id("textures/gui/widgets.png");
    static final Component COMPONENT_ON = Component.m_237119_().m_7220_(CommonComponents.f_130653_).m_130940_(ChatFormatting.GREEN);
    static final Component COMPONENT_OFF = Component.m_237119_().m_7220_(CommonComponents.f_130654_).m_130940_(ChatFormatting.RED);
    public static final Component COMPONENT_TITLE = Component.m_237115_((String)"screen.orthographic_camera.title");
    public static final String KEY_FOLLOW_VIEW = "screen.orthographic_camera.follow_view";
    public static final String KEY_NEAR_CLIPPING = "screen.orthographic_camera.near_clipping";
    public static final String KEY_RENDER_SKY = "screen.orthographic_camera.render_sky";
    public static final String KEY_RENDER_PLAYER = "screen.orthographic_camera.render_player";
    static final float DEFAULT_INCREMENT = 1.0f;
    static final float LARGE_INCREMENT = 10.0f;
    static final float SMALL_INCREMENT = 0.1f;
    private static Type lastType = Type.EDIT_BOX;
    final Type type;
    final OrthoViewHandler handler;
    private boolean focusModeActive;

    AbstractCameraScreen(Type type, Component title, OrthoViewHandler handler) {
        super(title);
        this.type = lastType = type;
        this.handler = handler;
    }

    protected void m_7856_() {
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ / 6 + 160, 200, 20).m_253136_());
        ((Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"<<"), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$init$1(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((AbstractCameraScreen)this)).m_252987_((int)(this.f_96543_ / 2 - 136), (int)(this.f_96544_ / 6 - 20), (int)50, (int)20).m_253136_())).f_93623_ = !this.type.isLeft;
        ((Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)">>"), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$init$2(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((AbstractCameraScreen)this)).m_252987_((int)(this.f_96543_ / 2 + 86), (int)(this.f_96544_ / 6 - 20), (int)50, (int)20).m_253136_())).f_93623_ = this.type.isLeft;
        ArrayList<AbstractWidget> rotationWidgets = new ArrayList<AbstractWidget>();
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)AbstractCameraScreen.getOptionComponent(KEY_FOLLOW_VIEW, this.handler.followPlayerView()), button -> {
            this.handler.flipFollowPlayerView();
            button.m_93666_(AbstractCameraScreen.getOptionComponent(KEY_FOLLOW_VIEW, this.handler.followPlayerView()));
            rotationWidgets.forEach(abstractWidget -> {
                abstractWidget.f_93623_ = !this.handler.followPlayerView();
            });
        }).m_252987_(this.f_96543_ / 2 - 154, this.f_96544_ / 6 + 100, 150, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)AbstractCameraScreen.getOptionComponent(KEY_NEAR_CLIPPING, this.handler.nearClipping()), button -> {
            this.handler.flipNearClipping();
            button.m_93666_(AbstractCameraScreen.getOptionComponent(KEY_NEAR_CLIPPING, this.handler.nearClipping()));
        }).m_252987_(this.f_96543_ / 2 + 4, this.f_96544_ / 6 + 100, 150, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)AbstractCameraScreen.getOptionComponent(KEY_RENDER_SKY, this.handler.renderSky()), button -> {
            this.handler.flipRenderSky();
            button.m_93666_(AbstractCameraScreen.getOptionComponent(KEY_RENDER_SKY, this.handler.renderSky()));
        }).m_252987_(this.f_96543_ / 2 - 154, this.f_96544_ / 6 + 126, 150, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)AbstractCameraScreen.getOptionComponent(KEY_RENDER_PLAYER, this.handler.renderPlayerEntity()), button -> {
            this.handler.flipRenderPlayerEntity();
            button.m_93666_(AbstractCameraScreen.getOptionComponent(KEY_RENDER_PLAYER, this.handler.renderPlayerEntity()));
        }).m_252987_(this.f_96543_ / 2 + 4, this.f_96544_ / 6 + 126, 150, 20).m_253136_());
        for (int i = 0; i < OrthoComponent.VALUES.length; ++i) {
            OrthoComponent component = OrthoComponent.VALUES[i];
            ArrayList<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
            this.addControlRow(component, this.f_96544_ / 6 + 20 + i * 25, widgets);
            widgets.forEach(x$0 -> {
                AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
            });
            if (!component.disableWhenFollowingPlayerView()) continue;
            rotationWidgets.addAll(widgets);
        }
        rotationWidgets.forEach(abstractWidget -> {
            abstractWidget.f_93623_ = !this.handler.followPlayerView();
        });
    }

    void addControlRow(OrthoComponent component, int rowHeight, Collection<AbstractWidget> widgets) {
        widgets.add((AbstractWidget)new SpritelessImageButton(this.f_96543_ / 2 + 182, rowHeight, 20, 20, 80, 0, WIDGETS_LOCATION, button -> {
            this.focusModeActive = !this.focusModeActive;
            ((SpritelessImageButton)button).xTexStart = (this.focusModeActive ? 5 : 4) * 20;
            for (GuiEventListener guiEventListener : this.m_6702_()) {
                AbstractWidget abstractWidget;
                if (!(guiEventListener instanceof AbstractWidget) || widgets.contains(abstractWidget = (AbstractWidget)guiEventListener)) continue;
                abstractWidget.f_93624_ = !this.focusModeActive;
            }
        }).setDrawBackground().setTextureLayout(SpritelessImageButton.SINGLE_TEXTURE_LAYOUT));
    }

    AbstractWidget getResetButton(int rowHeight, Runnable runnable) {
        return new SpritelessImageButton(this.f_96543_ / 2 + 158, rowHeight, 20, 20, 120, 0, WIDGETS_LOCATION, button -> runnable.run()).setDrawBackground().setTextureLayout(SpritelessImageButton.SINGLE_TEXTURE_LAYOUT);
    }

    static Component getOptionComponent(String translationKey, boolean onOffState) {
        return Component.m_237110_((String)translationKey, (Object[])new Object[]{onOffState ? COMPONENT_ON : COMPONENT_OFF});
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        if (!this.focusModeActive) {
            guiGraphics.m_280653_(this.f_96547_, COMPONENT_TITLE, this.f_96543_ / 2, this.f_96544_ / 6 - 15, 0xFFFFFF);
        }
    }

    public void m_280273_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.focusModeActive) {
            super.m_280273_(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public static Screen openScreen() {
        return AbstractCameraScreen.lastType.factory.apply(COMPONENT_TITLE, OrthoViewHandler.INSTANCE);
    }

    static float getCurrentIncrement() {
        if (Screen.m_96638_()) {
            return 10.0f;
        }
        if (Screen.m_96639_()) {
            return 0.1f;
        }
        return 1.0f;
    }

    private /* synthetic */ void lambda$init$2(Button button) {
        this.f_96541_.m_91152_(this.type.cycle().factory.apply(this.m_96636_(), this.handler));
    }

    private /* synthetic */ void lambda$init$1(Button button) {
        this.f_96541_.m_91152_(this.type.cycle().factory.apply(this.m_96636_(), this.handler));
    }

    static enum Type {
        SLIDER(SliderCameraScreen::new, false),
        EDIT_BOX(EditBoxCameraScreen::new, true);

        static final Type[] VALUES;
        final BiFunction<Component, OrthoViewHandler, Screen> factory;
        final boolean isLeft;

        private Type(BiFunction<Component, OrthoViewHandler, Screen> factory, boolean isLeft) {
            this.factory = factory;
            this.isLeft = isLeft;
        }

        public Type cycle() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        static {
            VALUES = Type.values();
        }
    }

    static enum OrthoComponent {
        ZOOM("pixelshot.zoom", 0.1f, 500.0f, OrthoViewHandler::getZoom, OrthoViewHandler::setZoom),
        X_ROTATION("pixelshot.x_rot", -90.0f, 90.0f, OrthoViewHandler::getXRot, OrthoViewHandler::setXRot),
        Y_ROTATION("pixelshot.y_rot", -180.0f, 180.0f, OrthoViewHandler::getYRot, OrthoViewHandler::setYRot);

        static final OrthoComponent[] VALUES;
        public final String translationKey;
        public final Component component;
        public final float minValue;
        public final float maxValue;
        public final Function<OrthoViewHandler, Float> supplier;
        public final BiConsumer<OrthoViewHandler, Float> consumer;

        private OrthoComponent(String translationKey, float minValue, float maxValue, Function<OrthoViewHandler, Float> supplier, BiConsumer<OrthoViewHandler, Float> consumer) {
            this.translationKey = translationKey;
            this.component = Component.m_237110_((String)translationKey, (Object[])new Object[]{""});
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.supplier = supplier;
            this.consumer = consumer;
        }

        public boolean disableWhenFollowingPlayerView() {
            return this != ZOOM;
        }

        public boolean supportsLogarithmicScale() {
            return this == ZOOM;
        }

        public float getDefaultValue() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case ZOOM -> (float)((ClientConfig)Pixelshot.CONFIG.get(ClientConfig.class)).orthographicCamera.initialZoomLevel;
                case X_ROTATION -> (float)((ClientConfig)Pixelshot.CONFIG.get(ClientConfig.class)).orthographicCamera.initialXRotation;
                case Y_ROTATION -> (float)((ClientConfig)Pixelshot.CONFIG.get(ClientConfig.class)).orthographicCamera.initialYRotation;
            };
        }

        static {
            VALUES = OrthoComponent.values();
        }
    }

    static class DynamicTooltip
    extends Tooltip {
        private final AbstractWidget abstractWidget;
        private final char sign;

        public DynamicTooltip(AbstractWidget abstractWidget, char sign) {
            super(CommonComponents.f_237098_, null);
            this.abstractWidget = abstractWidget;
            this.sign = sign;
        }

        public List<FormattedCharSequence> m_257408_(Minecraft minecraft) {
            return Collections.singletonList(Language.m_128107_().m_5536_(FormattedText.m_130775_((String)(String.valueOf(this.sign) + AbstractCameraScreen.getCurrentIncrement()))));
        }

        public void m_305623_(boolean hovering, boolean focused, ScreenRectangle screenRectangle) {
            if (this.abstractWidget.f_93623_) {
                super.m_305623_(hovering, focused, screenRectangle);
            }
        }
    }
}

