/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pixelshot.client.gui.screens;

import fuzs.pixelshot.client.gui.screens.AbstractCameraScreen;
import fuzs.pixelshot.client.handler.OrthoViewHandler;
import fuzs.puzzleslib.api.client.gui.v2.components.SpritelessImageButton;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class EditBoxCameraScreen
extends AbstractCameraScreen {
    static final String VALID_NUMBER_PATTERN = "[\\d+\\-.]*";
    static final MutableComponent COMPONENT_ZOOM = Component.m_237110_((String)"pixelshot.zoom", (Object[])new Object[]{""});
    static final MutableComponent COMPONENT_X_ROT = Component.m_237110_((String)"pixelshot.x_rot", (Object[])new Object[]{""});
    static final MutableComponent COMPONENT_Y_ROT = Component.m_237110_((String)"pixelshot.y_rot", (Object[])new Object[]{""});

    public EditBoxCameraScreen(Component title, OrthoViewHandler handler) {
        super(AbstractCameraScreen.Type.EDIT_BOX, title, handler);
    }

    @Override
    void addControlRow(AbstractCameraScreen.OrthoComponent component, int rowHeight, Collection<AbstractWidget> widgets) {
        super.addControlRow(component, rowHeight, widgets);
        Consumer<Float> consumer = value -> component.consumer.accept(this.handler, (Float)value);
        Supplier<Float> supplier = () -> component.supplier.apply(this.handler);
        int maxWidth = EditBoxCameraScreen.getMaxComponentWidth(this.f_96547_);
        int n = this.f_96543_ / 2 - 154 + 67 - maxWidth / 2;
        Objects.requireNonNull(this.f_96547_);
        widgets.add((AbstractWidget)new StringWidget(n, rowHeight + 5, maxWidth, 9, component.component, this.f_96547_));
        EditBox editBox = new EditBox(this.f_96547_, this.f_96543_ / 2 - 20, rowHeight, 150, 20, GameNarrator.f_93310_);
        editBox.m_94153_(string -> string.matches(VALID_NUMBER_PATTERN));
        editBox.m_94144_(String.valueOf(OrthoViewHandler.roundValue(supplier.get().floatValue())));
        editBox.m_94151_(string -> {
            try {
                consumer.accept(Float.valueOf(Float.parseFloat(string)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        widgets.add((AbstractWidget)editBox);
        SpritelessImageButton plusButton = new SpritelessImageButton(this.f_96543_ / 2 + 134, rowHeight, 20, 10, 0, 0, WIDGETS_LOCATION, button -> {
            consumer.accept(Float.valueOf(((Float)supplier.get()).floatValue() + EditBoxCameraScreen.getCurrentIncrement()));
            editBox.m_94144_(String.valueOf(OrthoViewHandler.roundValue(((Float)supplier.get()).floatValue())));
        }).setDrawBackground().setTextureLayout(SpritelessImageButton.SINGLE_TEXTURE_LAYOUT);
        plusButton.m_257544_((Tooltip)new AbstractCameraScreen.DynamicTooltip((AbstractWidget)plusButton, '+'));
        widgets.add((AbstractWidget)plusButton);
        SpritelessImageButton minusButton = new SpritelessImageButton(this.f_96543_ / 2 + 134, rowHeight + 10, 20, 10, 20, 0, WIDGETS_LOCATION, button -> {
            consumer.accept(Float.valueOf(((Float)supplier.get()).floatValue() - EditBoxCameraScreen.getCurrentIncrement()));
            editBox.m_94144_(String.valueOf(OrthoViewHandler.roundValue(((Float)supplier.get()).floatValue())));
        }).setDrawBackground().setTextureLayout(SpritelessImageButton.SINGLE_TEXTURE_LAYOUT);
        minusButton.m_257544_((Tooltip)new AbstractCameraScreen.DynamicTooltip((AbstractWidget)minusButton, '-'));
        widgets.add((AbstractWidget)minusButton);
        widgets.add(this.getResetButton(rowHeight, () -> {
            consumer.accept(Float.valueOf(component.getDefaultValue()));
            editBox.m_94144_(String.valueOf(OrthoViewHandler.roundValue(component.getDefaultValue())));
        }));
    }

    private static int getMaxComponentWidth(Font font) {
        return Math.max(font.m_92852_((FormattedText)COMPONENT_Y_ROT), Math.max(font.m_92852_((FormattedText)COMPONENT_ZOOM), font.m_92852_((FormattedText)COMPONENT_X_ROT)));
    }
}

